/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import junit.framework.TestCase;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.StubBroker;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.activemq.security.JaasCertificateAuthenticationBroker;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.security.StubJaasConfiguration;
import org.apache.activemq.security.StubSecurityContext;
import org.apache.activemq.transport.tcp.StubX509Certificate;

public class JaasCertificateAuthenticationBrokerTest
extends TestCase {
    StubBroker receiveBroker;
    JaasCertificateAuthenticationBroker authBroker;
    ConnectionContext connectionContext;
    ConnectionInfo connectionInfo;

    protected void setUp() throws Exception {
        this.receiveBroker = new StubBroker();
        this.authBroker = new JaasCertificateAuthenticationBroker((Broker)this.receiveBroker, "");
        this.connectionContext = new ConnectionContext();
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.setTransportContext((Object)new StubX509Certificate[0]);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void setConfiguration(Set<String> userNames, Set<String> groupNames, boolean loginShouldSucceed) {
        HashMap<String, String> configOptions = new HashMap<String, String>();
        Iterator<String> iter = userNames.iterator();
        String userNamesString = "" + (iter.hasNext() ? iter.next() : "");
        while (iter.hasNext()) {
            userNamesString = userNamesString + "," + iter.next();
        }
        String groupNamesString = "";
        Iterator<String> iter2 = groupNames.iterator();
        groupNamesString = "" + (iter2.hasNext() ? iter2.next() : "");
        while (iter2.hasNext()) {
            groupNamesString = groupNamesString + "," + iter2.next();
        }
        configOptions.put("org.apache.activemq.jaas.stubproperties.allow_login", loginShouldSucceed ? "true" : "false");
        configOptions.put("org.apache.activemq.jaas.stubproperties.users", userNamesString);
        configOptions.put("org.apache.activemq.jaas.stubproperties.groups", groupNamesString);
        AppConfigurationEntry configEntry = new AppConfigurationEntry("org.apache.activemq.security.StubLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, configOptions);
        StubJaasConfiguration jaasConfig = new StubJaasConfiguration(configEntry);
        Configuration.setConfiguration(jaasConfig);
    }

    public void testAddConnectionSuccess() {
        String dnUserName = "dnUserName";
        HashSet<String> userNames = new HashSet<String>();
        userNames.add(dnUserName);
        HashSet<String> groupNames = new HashSet<String>();
        groupNames.add("testGroup1");
        groupNames.add("testGroup2");
        groupNames.add("tesetGroup3");
        this.setConfiguration(userNames, groupNames, true);
        try {
            this.authBroker.addConnection(this.connectionContext, this.connectionInfo);
        }
        catch (Exception e) {
            JaasCertificateAuthenticationBrokerTest.fail((String)("Call to addConnection failed: " + e.getMessage()));
        }
        JaasCertificateAuthenticationBrokerTest.assertEquals((String)"Number of addConnection calls to underlying Broker must match number of calls made to AuthenticationBroker.", (int)1, (int)this.receiveBroker.addConnectionData.size());
        ConnectionContext receivedContext = this.receiveBroker.addConnectionData.getFirst().connectionContext;
        JaasCertificateAuthenticationBrokerTest.assertEquals((String)"The SecurityContext's userName must be set to that of the UserPrincipal.", (String)dnUserName, (String)receivedContext.getSecurityContext().getUserName());
        Set receivedPrincipals = receivedContext.getSecurityContext().getPrincipals();
        for (Principal currentPrincipal : receivedPrincipals) {
            if (currentPrincipal instanceof UserPrincipal) {
                if (userNames.remove(currentPrincipal.getName())) continue;
                JaasCertificateAuthenticationBrokerTest.fail((String)"Unknown UserPrincipal found");
                continue;
            }
            if (currentPrincipal instanceof GroupPrincipal) {
                if (groupNames.remove(currentPrincipal.getName())) continue;
                JaasCertificateAuthenticationBrokerTest.fail((String)"Unknown GroupPrincipal found.");
                continue;
            }
            JaasCertificateAuthenticationBrokerTest.fail((String)"Unexpected Principal subclass found.");
        }
        if (!userNames.isEmpty()) {
            JaasCertificateAuthenticationBrokerTest.fail((String)"Some usernames were not added as UserPrincipals");
        }
        if (!groupNames.isEmpty()) {
            JaasCertificateAuthenticationBrokerTest.fail((String)"Some group names were not added as GroupPrincipals");
        }
    }

    public void testAddConnectionFailure() {
        HashSet<String> userNames = new HashSet<String>();
        HashSet<String> groupNames = new HashSet<String>();
        groupNames.add("testGroup1");
        groupNames.add("testGroup2");
        groupNames.add("tesetGroup3");
        this.setConfiguration(userNames, groupNames, false);
        boolean connectFailed = false;
        try {
            this.authBroker.addConnection(this.connectionContext, this.connectionInfo);
        }
        catch (SecurityException e) {
            connectFailed = true;
        }
        catch (Exception e) {
            JaasCertificateAuthenticationBrokerTest.fail((String)("Failed to connect for unexpected reason: " + e.getMessage()));
        }
        if (!connectFailed) {
            JaasCertificateAuthenticationBrokerTest.fail((String)"Unauthenticated connection allowed.");
        }
        JaasCertificateAuthenticationBrokerTest.assertEquals((String)"Unauthenticated connection allowed.", (boolean)true, (boolean)this.receiveBroker.addConnectionData.isEmpty());
    }

    public void testRemoveConnection() throws Exception {
        this.connectionContext.setSecurityContext((SecurityContext)new StubSecurityContext());
        this.authBroker.removeConnection(this.connectionContext, this.connectionInfo, new Throwable());
        JaasCertificateAuthenticationBrokerTest.assertEquals((String)"removeConnection should clear ConnectionContext.", null, (Object)this.connectionContext.getSecurityContext());
        JaasCertificateAuthenticationBrokerTest.assertEquals((String)"Incorrect number of calls to underlying broker were made.", (int)1, (int)this.receiveBroker.removeConnectionData.size());
    }
}

