/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URI;
import java.util.Arrays;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryTopic;
import javax.management.ObjectName;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnectionState;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.security.SecurityTestSupport;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthenticationPluginTest
extends SecurityTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleAuthenticationPluginTest.class);

    public static Test suite() {
        return SimpleAuthenticationPluginTest.suite(SimpleAuthenticationPluginTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SimpleAuthenticationPluginTest.suite());
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        return this.createBroker("org/apache/activemq/security/simple-auth-broker.xml");
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }

    public void initCombosForTestPredefinedDestinations() {
        this.addCombinationValues("userName", new Object[]{"guest"});
        this.addCombinationValues("password", new Object[]{"password"});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST.Q")});
    }

    public void testPredefinedDestinations() throws JMSException {
        Message sent = this.doSend(false);
        SimpleAuthenticationPluginTest.assertEquals((String)"guest", (String)((ActiveMQMessage)sent).getUserID());
        SimpleAuthenticationPluginTest.assertEquals((String)"guest", (String)sent.getStringProperty("JMSXUserID"));
    }

    public void testTempDestinations() throws Exception {
        Connection conn = this.factory.createConnection("guest", "password");
        Session sess = conn.createSession(false, 1);
        String name = "org.apache.activemq:BrokerName=localhost,Type=TempTopic";
        try {
            conn.start();
            TemporaryTopic temp = sess.createTemporaryTopic();
            name = name + ",Destination=" + temp.getTopicName().replaceAll(":", "_");
            SimpleAuthenticationPluginTest.fail((String)"Should have failed creating a temp topic");
        }
        catch (Exception temp) {
            // empty catch block
        }
        ObjectName objName = new ObjectName(name);
        TopicViewMBean mbean = (TopicViewMBean)this.broker.getManagementContext().newProxyInstance(objName, TopicViewMBean.class, true);
        try {
            System.out.println(mbean.getName());
            SimpleAuthenticationPluginTest.fail((String)"Shouldn't have created a temp topic");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConnectionStartThrowsJMSSecurityException() throws Exception {
        Connection connection = this.factory.createConnection("badUser", "password");
        try {
            connection.start();
            SimpleAuthenticationPluginTest.fail((String)"Should throw JMSSecurityException");
        }
        catch (JMSSecurityException jMSSecurityException) {
        }
        catch (Exception e) {
            LOG.info("Expected JMSSecurityException but was: {}", e.getClass());
            SimpleAuthenticationPluginTest.fail((String)"Should throw JMSSecurityException");
        }
    }

    public void testSecurityContextClearedOnPurge() throws Exception {
        this.connection.close();
        ActiveMQConnectionFactory tcpFactory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        ActiveMQConnection conn = (ActiveMQConnection)tcpFactory.createConnection("user", "password");
        Session sess = conn.createSession(false, 1);
        conn.start();
        LOG.info("dest list at start:" + Arrays.asList(this.broker.getRegionBroker().getDestinations()));
        final int numDests = this.broker.getRegionBroker().getDestinations().length;
        for (int i = 0; i < 10; ++i) {
            MessageProducer p = sess.createProducer((Destination)new ActiveMQQueue("USERS.PURGE." + i));
            p.close();
        }
        SimpleAuthenticationPluginTest.assertTrue((String)"dests are purged", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("dest list:" + Arrays.asList(SimpleAuthenticationPluginTest.this.broker.getRegionBroker().getDestinations()));
                LOG.info("dests, orig: " + numDests + ", now: " + SimpleAuthenticationPluginTest.this.broker.getRegionBroker().getDestinations().length);
                return numDests == SimpleAuthenticationPluginTest.this.broker.getRegionBroker().getDestinations().length;
            }
        }));
        TransportConnection brokerConnection = (TransportConnection)((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnections().get(0);
        TransportConnectionState transportConnectionState = brokerConnection.lookupConnectionState(conn.getConnectionInfo().getConnectionId());
        SimpleAuthenticationPluginTest.assertEquals((String)"no destinations", (int)0, (int)transportConnectionState.getContext().getSecurityContext().getAuthorizedWriteDests().size());
    }
}

