/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ5153LevelDBSubscribedDestTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ5153LevelDBSubscribedDestTest.class);
    protected BrokerService brokerService;

    protected void setUp() throws Exception {
        super.setUp();
        this.brokerService = this.createBroker();
        this.getConnectionFactory().setClientID(this.getName());
    }

    protected void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost");
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = BrokerFactory.createBroker((URI)new URI("broker:()/localhost?persistent=true"));
        AMQ5153LevelDBSubscribedDestTest.setPersistenceAdapter(broker, TestSupport.PersistenceAdapterChoice.LevelDB);
        broker.deleteAllMessages();
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }

    @Test
    public void testWildcardDurableSubscriptions() throws Exception {
        Destination wildcardJmsDest = this.createDestination("testing.durable.>");
        Destination testJmsDest = this.createDestination("testing.durable.test");
        Connection conn = this.createConnection();
        Session sess = conn.createSession(false, 1);
        TopicSubscriber wildcardConsumer = sess.createDurableSubscriber((javax.jms.Topic)wildcardJmsDest, "durable1");
        TopicSubscriber testConsumer = sess.createDurableSubscriber((javax.jms.Topic)testJmsDest, "durable2");
        MessageProducer producer = sess.createProducer(this.createDestination("testing.durable.>"));
        producer.send((Message)sess.createTextMessage("hello!"));
        Topic wildcardDest = (Topic)AMQ5153LevelDBSubscribedDestTest.getDestination(this.brokerService, ActiveMQDestination.transform((Destination)wildcardJmsDest));
        Topic testDest = (Topic)AMQ5153LevelDBSubscribedDestTest.getDestination(this.brokerService, ActiveMQDestination.transform((Destination)testJmsDest));
        wildcardConsumer.close();
        testConsumer.close();
        conn.close();
        AMQ5153LevelDBSubscribedDestTest.assertEquals((int)1, (int)wildcardDest.getDurableTopicSubs().size());
        AMQ5153LevelDBSubscribedDestTest.assertEquals((int)2, (int)testDest.getDurableTopicSubs().size());
        LOG.info("Stopping broker...");
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
        AMQ5153LevelDBSubscribedDestTest.setPersistenceAdapter(this.brokerService, TestSupport.PersistenceAdapterChoice.LevelDB);
        this.brokerService.start(true);
        this.brokerService.waitUntilStarted();
        wildcardDest = (Topic)AMQ5153LevelDBSubscribedDestTest.getDestination(this.brokerService, ActiveMQDestination.transform((Destination)wildcardJmsDest));
        AMQ5153LevelDBSubscribedDestTest.assertNotNull((Object)wildcardDest);
        testDest = (Topic)AMQ5153LevelDBSubscribedDestTest.getDestination(this.brokerService, ActiveMQDestination.transform((Destination)testJmsDest));
        AMQ5153LevelDBSubscribedDestTest.assertNotNull((Object)testDest);
        AMQ5153LevelDBSubscribedDestTest.assertEquals((int)2, (int)testDest.getDurableTopicSubs().size());
        AMQ5153LevelDBSubscribedDestTest.assertEquals((int)1, (int)wildcardDest.getDurableTopicSubs().size());
    }
}

