/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.security.AuthenticationUser;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.AuthorizationPlugin;
import org.apache.activemq.security.DefaultAuthorizationMap;
import org.apache.activemq.security.SimpleAuthenticationPlugin;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.usecases.DurableSubscriptionOfflineTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class DurableSubscriptionOfflineBrowseRemoveTest
extends DurableSubscriptionOfflineTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubscriptionOfflineBrowseRemoveTest.class);
    public static final String IDENTITY = "milly";
    public boolean keepDurableSubsActive;

    @Parameterized.Parameters(name="PA-{0}.KeepSubsActive-{1}")
    public static Collection<Object[]> getTestParameters() {
        ArrayList<Object[]> testParameters = new ArrayList<Object[]>();
        testParameters.add(new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, Boolean.TRUE});
        testParameters.add(new Object[]{TestSupport.PersistenceAdapterChoice.KahaDB, Boolean.FALSE});
        testParameters.add(new Object[]{TestSupport.PersistenceAdapterChoice.JDBC, Boolean.TRUE});
        testParameters.add(new Object[]{TestSupport.PersistenceAdapterChoice.JDBC, Boolean.FALSE});
        return testParameters;
    }

    public DurableSubscriptionOfflineBrowseRemoveTest(TestSupport.PersistenceAdapterChoice adapter, boolean keepDurableSubsActive) {
        this.defaultPersistenceAdapter = adapter;
        this.usePrioritySupport = true;
        this.keepDurableSubsActive = keepDurableSubsActive;
    }

    @Override
    public void configurePlugins(BrokerService brokerService) throws Exception {
        ArrayList<AuthorizationEntry> authorizationEntries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry entry = new AuthorizationEntry();
        entry.setTopic(">");
        entry.setRead(IDENTITY);
        entry.setWrite(IDENTITY);
        entry.setAdmin(IDENTITY);
        authorizationEntries.add(entry);
        DefaultAuthorizationMap authorizationMap = new DefaultAuthorizationMap(authorizationEntries);
        AuthorizationPlugin authorizationPlugin = new AuthorizationPlugin((AuthorizationMap)authorizationMap);
        ArrayList<AuthenticationUser> users = new ArrayList<AuthenticationUser>();
        users.add(new AuthenticationUser(IDENTITY, IDENTITY, IDENTITY));
        SimpleAuthenticationPlugin authenticationPlugin = new SimpleAuthenticationPlugin(users);
        this.broker.setPlugins(new BrokerPlugin[]{authenticationPlugin, authorizationPlugin});
    }

    @Override
    public PersistenceAdapter setDefaultPersistenceAdapter(BrokerService broker) throws IOException {
        broker.setKeepDurableSubsActive(this.keepDurableSubsActive);
        return super.setPersistenceAdapter(broker, this.defaultPersistenceAdapter);
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://" + this.getName(true));
        connectionFactory.setUserName(IDENTITY);
        connectionFactory.setPassword(IDENTITY);
        connectionFactory.setWatchTopicAdvisories(false);
        return connectionFactory;
    }

    @Test(timeout=60000L)
    public void testBrowseRemoveBrowseOfflineSub() throws Exception {
        Connection con = this.createConnection();
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        for (int i = 0; i < 10; ++i) {
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        session.close();
        con.close();
        ObjectName[] subs = this.broker.getAdminView().getInactiveDurableTopicSubscribers();
        Assert.assertEquals((long)1L, (long)subs.length);
        ObjectName subName = subs[0];
        DurableSubscriptionViewMBean sub = (DurableSubscriptionViewMBean)this.broker.getManagementContext().newProxyInstance(subName, DurableSubscriptionViewMBean.class, true);
        CompositeData[] data = sub.browse();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)10L, (long)data.length);
        LinkedList<String> idToRemove = new LinkedList<String>();
        idToRemove.add((String)data[5].get("JMSMessageID"));
        idToRemove.add((String)data[9].get("JMSMessageID"));
        idToRemove.add((String)data[0].get("JMSMessageID"));
        LOG.info("Removing: " + idToRemove);
        for (String id : idToRemove) {
            sub.removeMessage(id);
        }
        if (this.defaultPersistenceAdapter.compareTo(TestSupport.PersistenceAdapterChoice.JDBC) == 0) {
            for (int i = 0; i < 10; ++i) {
                ((JDBCPersistenceAdapter)this.broker.getPersistenceAdapter()).cleanup();
            }
        }
        data = sub.browse();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)7L, (long)data.length);
        for (CompositeData c : data) {
            String id = (String)c.get("JMSMessageID");
            for (String removedId : idToRemove) {
                Assert.assertNotEquals((Object)id, (Object)removedId);
            }
        }
        LOG.info("Repeat remove: " + (String)idToRemove.getFirst());
        sub.removeMessage((String)idToRemove.getFirst());
    }
}

