/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker;

import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.apollo.broker.AcceptingConnector$;
import org.apache.activemq.apollo.broker.AcceptingConnector$BrokerAcceptListener$;
import org.apache.activemq.apollo.broker.Broker;
import org.apache.activemq.apollo.broker.Broker$;
import org.apache.activemq.apollo.broker.BrokerAware;
import org.apache.activemq.apollo.broker.BrokerConnection;
import org.apache.activemq.apollo.broker.Connector;
import org.apache.activemq.apollo.broker.Connector$;
import org.apache.activemq.apollo.broker.Connector$class;
import org.apache.activemq.apollo.broker.protocol.Protocol;
import org.apache.activemq.apollo.broker.protocol.ProtocolFactory$;
import org.apache.activemq.apollo.broker.security.SecuredResource;
import org.apache.activemq.apollo.broker.security.SecuredResource$ConnectorKind$;
import org.apache.activemq.apollo.broker.security.SecuredResource$class;
import org.apache.activemq.apollo.broker.transport.TransportFactory;
import org.apache.activemq.apollo.dto.AcceptingConnectorDTO;
import org.apache.activemq.apollo.dto.ConnectionStatusDTO;
import org.apache.activemq.apollo.dto.ConnectorStatusDTO;
import org.apache.activemq.apollo.dto.ConnectorTypeDTO;
import org.apache.activemq.apollo.dto.LongIdLabeledDTO;
import org.apache.activemq.apollo.dto.ProtocolDTO;
import org.apache.activemq.apollo.util.BaseService;
import org.apache.activemq.apollo.util.Dispatched;
import org.apache.activemq.apollo.util.LongCounter;
import org.apache.activemq.apollo.util.LongCounter$;
import org.apache.activemq.apollo.util.MemoryPropertyEditor;
import org.apache.activemq.apollo.util.OptionSupport$;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.package$;
import org.fusesource.hawtdispatch.transport.SslTransportServer;
import org.fusesource.hawtdispatch.transport.TcpTransportServer;
import org.fusesource.hawtdispatch.transport.TransportServer;
import org.fusesource.hawtdispatch.transport.TransportServerListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u0001\u0003\u00015\u0011!#Q2dKB$\u0018N\\4D_:tWm\u0019;pe*\u00111\u0001B\u0001\u0007EJ|7.\u001a:\u000b\u0005\u00151\u0011AB1q_2dwN\u0003\u0002\b\u0011\u0005A\u0011m\u0019;jm\u0016l\u0017O\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u000191\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!!C\"p]:,7\r^8s\u0011!\u0019\u0001A!b\u0001\n\u0003YR#\u0001\u000f\u0011\u0005]i\u0012B\u0001\u0010\u0003\u0005\u0019\u0011%o\\6fe\"A\u0001\u0005\u0001B\u0001B\u0003%A$A\u0004ce>\\WM\u001d\u0011\t\u0011\t\u0002!Q1A\u0005\u0002\r\n!!\u001b3\u0016\u0003\u0011\u0002\"!J\u0016\u000f\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003U\u001dB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0004S\u0012\u0004\u0003\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\bF\u00024iU\u0002\"a\u0006\u0001\t\u000b\r\u0001\u0004\u0019\u0001\u000f\t\u000b\t\u0002\u0004\u0019\u0001\u0013\t\u000f]\u0002!\u0019!C!q\u0005qA-[:qCR\u001c\u0007nX9vKV,W#A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u00045boR$\u0017n\u001d9bi\u000eD'B\u0001 \u000b\u0003)1Wo]3t_V\u00148-Z\u0005\u0003\u0001n\u0012Q\u0002R5ta\u0006$8\r[)vKV,\u0007B\u0002\"\u0001A\u0003%\u0011(A\beSN\u0004\u0018\r^2i?F,X-^3!\u0011\u001d!\u0005\u00011A\u0005\u0002\u0015\u000baaY8oM&<W#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%#\u0011a\u00013u_&\u00111\n\u0013\u0002\u0016\u0003\u000e\u001cW\r\u001d;j]\u001e\u001cuN\u001c8fGR|'\u000f\u0012+P\u0011\u001di\u0005\u00011A\u0005\u00029\u000b!bY8oM&<w\fJ3r)\ty%\u000b\u0005\u0002'!&\u0011\u0011k\n\u0002\u0005+:LG\u000fC\u0004T\u0019\u0006\u0005\t\u0019\u0001$\u0002\u0007a$\u0013\u0007\u0003\u0004V\u0001\u0001\u0006KAR\u0001\bG>tg-[4!\u0011%9\u0006\u00011AA\u0002\u0013\u0005\u0001,\u0001\tue\u0006t7\u000f]8si~\u001bXM\u001d<feV\t\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]w\u0005IAO]1ogB|'\u000f^\u0005\u0003=n\u0013q\u0002\u0016:b]N\u0004xN\u001d;TKJ4XM\u001d\u0005\nA\u0002\u0001\r\u00111A\u0005\u0002\u0005\fA\u0003\u001e:b]N\u0004xN\u001d;`g\u0016\u0014h/\u001a:`I\u0015\fHCA(c\u0011\u001d\u0019v,!AA\u0002eCa\u0001\u001a\u0001!B\u0013I\u0016!\u0005;sC:\u001c\bo\u001c:u?N,'O^3sA!Ia\r\u0001a\u0001\u0002\u0004%\taZ\u0001\taJ|Go\\2pYV\t\u0001\u000e\u0005\u0002jW6\t!N\u0003\u0002g\u0005%\u0011AN\u001b\u0002\t!J|Go\\2pY\"Ia\u000e\u0001a\u0001\u0002\u0004%\ta\\\u0001\raJ|Go\\2pY~#S-\u001d\u000b\u0003\u001fBDqaU7\u0002\u0002\u0003\u0007\u0001\u000e\u0003\u0004s\u0001\u0001\u0006K\u0001[\u0001\naJ|Go\\2pY\u0002Bq\u0001\u001e\u0001C\u0002\u0013\u0005Q/\u0001\u0005bG\u000e,\u0007\u000f^3e+\u00051\bCA<{\u001b\u0005A(BA=\u0005\u0003\u0011)H/\u001b7\n\u0005mD(a\u0003'p]\u001e\u001cu.\u001e8uKJDa! \u0001!\u0002\u00131\u0018!C1dG\u0016\u0004H/\u001a3!\u0011\u001dy\bA1A\u0005\u0002U\f\u0011bY8o]\u0016\u001cG/\u001a3\t\u000f\u0005\r\u0001\u0001)A\u0005m\u0006Q1m\u001c8oK\u000e$X\r\u001a\u0011\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\fA\u0019q\"!\u0004\n\u00051\u0002\u0002bBA\t\u0001\u0011\u0005\u00111C\u0001\u000fg>\u001c7.\u001a;`C\u0012$'/Z:t+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYBE\u0001\u0004]\u0016$\u0018\u0002BA\u0010\u00033\u0011QbU8dW\u0016$\u0018\t\u001a3sKN\u001c\b\"CA\u0012\u0001\u0001\u0007I\u0011AA\u0013\u0003I!W-\u00193`[\u0016\u001c8/Y4fg~\u001bXM\u001c;\u0016\u0005\u0005\u001d\u0002c\u0001\u0014\u0002*%\u0019\u00111F\u0014\u0003\t1{gn\u001a\u0005\n\u0003_\u0001\u0001\u0019!C\u0001\u0003c\ta\u0003Z3bI~kWm]:bO\u0016\u001cxl]3oi~#S-\u001d\u000b\u0004\u001f\u0006M\u0002\"C*\u0002.\u0005\u0005\t\u0019AA\u0014\u0011!\t9\u0004\u0001Q!\n\u0005\u001d\u0012a\u00053fC\u0012|V.Z:tC\u001e,7oX:f]R\u0004\u0003\"CA\u001e\u0001\u0001\u0007I\u0011AA\u0013\u0003Y!W-\u00193`[\u0016\u001c8/Y4fg~\u0013XmY3jm\u0016$\u0007\"CA \u0001\u0001\u0007I\u0011AA!\u0003i!W-\u00193`[\u0016\u001c8/Y4fg~\u0013XmY3jm\u0016$w\fJ3r)\ry\u00151\t\u0005\n'\u0006u\u0012\u0011!a\u0001\u0003OA\u0001\"a\u0012\u0001A\u0003&\u0011qE\u0001\u0018I\u0016\fGmX7fgN\fw-Z:`e\u0016\u001cW-\u001b<fI\u0002B\u0011\"a\u0013\u0001\u0001\u0004%\t!!\n\u0002#\u0011,\u0017\rZ0sK\u0006$wlY8v]R,'\u000fC\u0005\u0002P\u0001\u0001\r\u0011\"\u0001\u0002R\u0005)B-Z1e?J,\u0017\rZ0d_VtG/\u001a:`I\u0015\fHcA(\u0002T!I1+!\u0014\u0002\u0002\u0003\u0007\u0011q\u0005\u0005\t\u0003/\u0002\u0001\u0015)\u0003\u0002(\u0005\u0011B-Z1e?J,\u0017\rZ0d_VtG/\u001a:!\u0011%\tY\u0006\u0001a\u0001\n\u0003\t)#\u0001\neK\u0006$wl\u001e:ji\u0016|6m\\;oi\u0016\u0014\b\"CA0\u0001\u0001\u0007I\u0011AA1\u0003Y!W-\u00193`oJLG/Z0d_VtG/\u001a:`I\u0015\fHcA(\u0002d!I1+!\u0018\u0002\u0002\u0003\u0007\u0011q\u0005\u0005\t\u0003O\u0002\u0001\u0015)\u0003\u0002(\u0005\u0019B-Z1e?^\u0014\u0018\u000e^3`G>,h\u000e^3sA!I\u00111\u000e\u0001A\u0002\u0013\u0005\u0011QN\u0001\u0019e\u0016\u001cW-\u001b<f?\n,hMZ3s?\u0006,Ho\\0uk:,WCAA8!\r1\u0013\u0011O\u0005\u0004\u0003g:#a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003o\u0002\u0001\u0019!C\u0001\u0003s\nAD]3dK&4Xm\u00182vM\u001a,'oX1vi>|F/\u001e8f?\u0012*\u0017\u000fF\u0002P\u0003wB\u0011bUA;\u0003\u0003\u0005\r!a\u001c\t\u0011\u0005}\u0004\u0001)Q\u0005\u0003_\n\u0011D]3dK&4Xm\u00182vM\u001a,'oX1vi>|F/\u001e8fA!I\u00111\u0011\u0001A\u0002\u0013\u0005\u0011QN\u0001\u0016g\u0016tGm\u00182vM\u001a,'oX1vi>|F/\u001e8f\u0011%\t9\t\u0001a\u0001\n\u0003\tI)A\rtK:$wLY;gM\u0016\u0014x,Y;u_~#XO\\3`I\u0015\fHcA(\u0002\f\"I1+!\"\u0002\u0002\u0003\u0007\u0011q\u000e\u0005\t\u0003\u001f\u0003\u0001\u0015)\u0003\u0002p\u000512/\u001a8e?\n,hMZ3s?\u0006,Ho\\0uk:,\u0007\u0005C\u0004\u0002\u0014\u0002!\t!!&\u0002\rM$\u0018\r^;t+\t\t9\nE\u0002H\u00033K1!a'I\u0005I\u0019uN\u001c8fGR|'o\u0015;biV\u001cH\tV(\b\u000f\u0005}\u0005\u0001#\u0001\u0002\"\u0006!\"I]8lKJ\f5mY3qi2K7\u000f^3oKJ\u0004B!a)\u0002&6\t\u0001AB\u0004\u0002(\u0002A\t!!+\u0003)\t\u0013xn[3s\u0003\u000e\u001cW\r\u001d;MSN$XM\\3s'\u0015\t)KDAV!\rQ\u0016QV\u0005\u0004\u0003_[&a\u0006+sC:\u001c\bo\u001c:u'\u0016\u0014h/\u001a:MSN$XM\\3s\u0011\u001d\t\u0014Q\u0015C\u0001\u0003g#\"!!)\t\u0011\u0005]\u0016Q\u0015C\u0001\u0003s\u000bQb\u001c8BG\u000e,\u0007\u000f^#se>\u0014HcA(\u0002<\"A\u0011QXA[\u0001\u0004\ty,A\u0001f!\u0011\t\t-!5\u000f\t\u0005\r\u0017Q\u001a\b\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0013bAAhO\u00059\u0001/Y2lC\u001e,\u0017\u0002BAj\u0003+\u0014\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005=w\u0005\u0003\u0005\u0002Z\u0006\u0015F\u0011AAn\u0003!yg.Q2dKB$HcA(\u0002^\"9A,a6A\u0002\u0005}\u0007c\u0001.\u0002b&\u0019\u00111].\u0003\u0013Q\u0013\u0018M\\:q_J$\bbBAt\u0001\u0011\u0005\u0011QN\u0001\u0014CR|6m\u001c8oK\u000e$\u0018n\u001c8`Y&l\u0017\u000e\u001e\u0005\b\u0003W\u0004A\u0011AAw\u0003\u0019)\b\u000fZ1uKR)q*a<\u0002x\"9A)!;A\u0002\u0005E\bcA$\u0002t&\u0019\u0011Q\u001f%\u0003!\r{gN\\3di>\u0014H+\u001f9f\tR{\u0005\u0002CA}\u0003S\u0004\r!a?\u0002\u0019=twlY8na2,G/\u001a3\u0011\u0007i\ni0C\u0002\u0002\u0000n\u0012A\u0001V1tW\"I!1\u0001\u0001A\u0002\u0013\u0005!QA\u0001\u0011g\u0016tGm\u00182vM\u001a,'oX:ju\u0016,\"Aa\u0002\u0011\u000b\u0019\u0012IA!\u0004\n\u0007\t-qE\u0001\u0004PaRLwN\u001c\t\u0004M\t=\u0011b\u0001B\tO\t\u0019\u0011J\u001c;\t\u0013\tU\u0001\u00011A\u0005\u0002\t]\u0011\u0001F:f]\u0012|&-\u001e4gKJ|6/\u001b>f?\u0012*\u0017\u000fF\u0002P\u00053A\u0011b\u0015B\n\u0003\u0003\u0005\rAa\u0002\t\u0011\tu\u0001\u0001)Q\u0005\u0005\u000f\t\u0011c]3oI~\u0013WO\u001a4fe~\u001b\u0018N_3!\u0011%\u0011\t\u0003\u0001a\u0001\n\u0003\u0011)!A\nsK\u000e,\u0017N^3`EV4g-\u001a:`g&TX\rC\u0005\u0003&\u0001\u0001\r\u0011\"\u0001\u0003(\u00059\"/Z2fSZ,wLY;gM\u0016\u0014xl]5{K~#S-\u001d\u000b\u0004\u001f\n%\u0002\"C*\u0003$\u0005\u0005\t\u0019\u0001B\u0004\u0011!\u0011i\u0003\u0001Q!\n\t\u001d\u0011\u0001\u0006:fG\u0016Lg/Z0ck\u001a4WM]0tSj,\u0007\u0005C\u0004\u00032\u0001!\tEa\r\u0002\r}\u001bH/\u0019:u)\ry%Q\u0007\u0005\t\u0003s\u0014y\u00031\u0001\u0002|\"I!\u0011\b\u0001A\u0002\u0013\u0005!1H\u0001\u0019Y\u0006\u001cHo\u0018:fG\u0016Lg/Z0ck\u001a4WM]0tSj,WC\u0001B\u0007\u0011%\u0011y\u0004\u0001a\u0001\n\u0003\u0011\t%\u0001\u000fmCN$xL]3dK&4Xm\u00182vM\u001a,'oX:ju\u0016|F%Z9\u0015\u0007=\u0013\u0019\u0005C\u0005T\u0005{\t\t\u00111\u0001\u0003\u000e!A!q\t\u0001!B\u0013\u0011i!A\rmCN$xL]3dK&4Xm\u00182vM\u001a,'oX:ju\u0016\u0004\u0003\"\u0003B&\u0001\u0001\u0007I\u0011\u0001B\u001e\u0003Ua\u0017m\u001d;`g\u0016tGm\u00182vM\u001a,'oX:ju\u0016D\u0011Ba\u0014\u0001\u0001\u0004%\tA!\u0015\u000231\f7\u000f^0tK:$wLY;gM\u0016\u0014xl]5{K~#S-\u001d\u000b\u0004\u001f\nM\u0003\"C*\u0003N\u0005\u0005\t\u0019\u0001B\u0007\u0011!\u00119\u0006\u0001Q!\n\t5\u0011A\u00067bgR|6/\u001a8e?\n,hMZ3s?NL'0\u001a\u0011\t\u000f\tm\u0003\u0001\"\u0011\u0003^\u00051R\u000f\u001d3bi\u0016|&-\u001e4gKJ|6/\u001a;uS:<7/F\u0001P\u0011\u001d\u0011\t\u0007\u0001C!\u0005G\nQaX:u_B$2a\u0014B3\u0011!\tIPa\u0018A\u0002\u0005m\bb\u0002B5\u0001\u0011\u0005!1N\u0001\bgR|\u0007\u000f]3e)\ry%Q\u000e\u0005\t\u0005_\u00129\u00071\u0001\u0003r\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\u0011\u0007]\u0011\u0019(C\u0002\u0003v\t\u0011\u0001C\u0011:pW\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8\b\u0013\te$!!A\t\u0002\tm\u0014AE!dG\u0016\u0004H/\u001b8h\u0007>tg.Z2u_J\u00042a\u0006B?\r!\t!!!A\t\u0002\t}4c\u0001B?\u001d!9\u0011G! \u0005\u0002\t\rEC\u0001B>\u0011)\u00119I! D\u0002\u0013\u0015\u0011QN\u0001\u0013I\u0015t\u0017M\u00197f?\u0006\u001c8/\u001a:uS>t7\u000fC\u0005\u0003\f\nu\u0004\u0015!\u0004\u0002p\u0005\u0019B%\u001a8bE2,w,Y:tKJ$\u0018n\u001c8tA\u0001")
public class AcceptingConnector
implements Connector {
    private final Broker broker;
    private final String id;
    private final DispatchQueue dispatch_queue;
    private AcceptingConnectorDTO config;
    private TransportServer transport_server;
    private Protocol protocol;
    private final LongCounter accepted;
    private final LongCounter connected;
    private long dead_messages_sent;
    private long dead_messages_received;
    private long dead_read_counter;
    private long dead_write_counter;
    private boolean receive_buffer_auto_tune;
    private boolean send_buffer_auto_tune;
    private Option<Object> send_buffer_size;
    private Option<Object> receive_buffer_size;
    private int last_receive_buffer_size;
    private int last_send_buffer_size;
    private volatile AcceptingConnector$BrokerAcceptListener$ BrokerAcceptListener$module;
    private volatile SecuredResource.SecurityRules rules_cache;
    private volatile BaseService.State _service_state;
    private volatile Throwable _service_failure;
    private final ListBuffer<Task> org$apache$activemq$apollo$util$BaseService$$pending_actions;
    private int _start_transition_counter;

    public static boolean $enable_assertions() {
        return AcceptingConnector$.MODULE$.$enable_assertions();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AcceptingConnector$BrokerAcceptListener$ BrokerAcceptListener$lzycompute() {
        AcceptingConnector acceptingConnector = this;
        synchronized (acceptingConnector) {
            if (this.BrokerAcceptListener$module != null) return this.BrokerAcceptListener$module;
            this.BrokerAcceptListener$module = new AcceptingConnector$BrokerAcceptListener$(this);
            return this.BrokerAcceptListener$module;
        }
    }

    @Override
    public SecuredResource$ConnectorKind$ resource_kind() {
        return Connector$class.resource_kind(this);
    }

    @Override
    public <T extends ProtocolDTO> Option<T> protocol_codec_config(Class<T> clazz) {
        return Connector$class.protocol_codec_config(this, clazz);
    }

    @Override
    public SecuredResource.SecurityRules rules_cache() {
        return this.rules_cache;
    }

    @Override
    public void rules_cache_$eq(SecuredResource.SecurityRules x$1) {
        this.rules_cache = x$1;
    }

    public BaseService.State _service_state() {
        return this._service_state;
    }

    public void _service_state_$eq(BaseService.State x$1) {
        this._service_state = x$1;
    }

    public Throwable _service_failure() {
        return this._service_failure;
    }

    public void _service_failure_$eq(Throwable x$1) {
        this._service_failure = x$1;
    }

    public ListBuffer<Task> org$apache$activemq$apollo$util$BaseService$$pending_actions() {
        return this.org$apache$activemq$apollo$util$BaseService$$pending_actions;
    }

    public int _start_transition_counter() {
        return this._start_transition_counter;
    }

    public void _start_transition_counter_$eq(int x$1) {
        this._start_transition_counter = x$1;
    }

    public void org$apache$activemq$apollo$util$BaseService$_setter_$org$apache$activemq$apollo$util$BaseService$$pending_actions_$eq(ListBuffer x$1) {
        this.org$apache$activemq$apollo$util$BaseService$$pending_actions = x$1;
    }

    public BaseService.State service_state() {
        return BaseService.class.service_state((BaseService)this);
    }

    public Throwable service_failure() {
        return BaseService.class.service_failure((BaseService)this);
    }

    public void start(Task on_completed2) {
        BaseService.class.start((BaseService)this, (Task)on_completed2);
    }

    public void stop(Task on_completed2) {
        BaseService.class.stop((BaseService)this, (Task)on_completed2);
    }

    public void schedule_reoccurring(long time, TimeUnit unit, Function0<BoxedUnit> func) {
        BaseService.class.schedule_reoccurring((BaseService)this, (long)time, (TimeUnit)unit, func);
    }

    public void assert_executing() {
        Dispatched.class.assert_executing((Dispatched)this);
    }

    @Override
    public Broker broker() {
        return this.broker;
    }

    @Override
    public String id() {
        return this.id;
    }

    public DispatchQueue dispatch_queue() {
        return this.dispatch_queue;
    }

    public AcceptingConnectorDTO config() {
        return this.config;
    }

    public void config_$eq(AcceptingConnectorDTO x$1) {
        this.config = x$1;
    }

    public TransportServer transport_server() {
        return this.transport_server;
    }

    public void transport_server_$eq(TransportServer x$1) {
        this.transport_server = x$1;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public void protocol_$eq(Protocol x$1) {
        this.protocol = x$1;
    }

    @Override
    public LongCounter accepted() {
        return this.accepted;
    }

    @Override
    public LongCounter connected() {
        return this.connected;
    }

    public String toString() {
        return new StringBuilder().append((Object)"connector: ").append((Object)this.config().id).toString();
    }

    @Override
    public SocketAddress socket_address() {
        return (SocketAddress)Option$.MODULE$.apply((Object)this.transport_server()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SocketAddress apply(TransportServer x$1) {
                return x$1.getSocketAddress();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public long dead_messages_sent() {
        return this.dead_messages_sent;
    }

    public void dead_messages_sent_$eq(long x$1) {
        this.dead_messages_sent = x$1;
    }

    public long dead_messages_received() {
        return this.dead_messages_received;
    }

    public void dead_messages_received_$eq(long x$1) {
        this.dead_messages_received = x$1;
    }

    public long dead_read_counter() {
        return this.dead_read_counter;
    }

    public void dead_read_counter_$eq(long x$1) {
        this.dead_read_counter = x$1;
    }

    public long dead_write_counter() {
        return this.dead_write_counter;
    }

    public void dead_write_counter_$eq(long x$1) {
        this.dead_write_counter = x$1;
    }

    public boolean receive_buffer_auto_tune() {
        return this.receive_buffer_auto_tune;
    }

    public void receive_buffer_auto_tune_$eq(boolean x$1) {
        this.receive_buffer_auto_tune = x$1;
    }

    public boolean send_buffer_auto_tune() {
        return this.send_buffer_auto_tune;
    }

    public void send_buffer_auto_tune_$eq(boolean x$1) {
        this.send_buffer_auto_tune = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectorStatusDTO status() {
        void var1_1;
        ConnectorStatusDTO result = new ConnectorStatusDTO();
        result.id = this.id().toString();
        result.state = this.service_state().toString();
        result.state_since = this.service_state().since();
        result.connection_counter = this.accepted().get();
        result.connected = this.connected().get();
        result.protocol = (String)Option$.MODULE$.apply((Object)this.config().protocol).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "any";
            }
        });
        result.local_address = (String)Option$.MODULE$.apply((Object)this.socket_address()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SocketAddress x$2) {
                return x$2.toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "any";
            }
        });
        result.messages_sent = this.dead_messages_sent();
        result.messages_received = this.dead_messages_received();
        result.read_counter = this.dead_read_counter();
        result.write_counter = this.dead_write_counter();
        this.broker().connections().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AcceptingConnector $outer;

            public final boolean apply(Tuple2<Object, BrokerConnection> x$3) {
                Tuple2<Object, BrokerConnection> tuple2 = x$3;
                if (tuple2 != null) {
                    long id = tuple2._1$mcJ$sp();
                    BrokerConnection connection = (BrokerConnection)tuple2._2();
                    boolean bl = connection.connector() == this.$outer;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).foreach((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final ConnectorStatusDTO result$1;

            public final void apply(Tuple2<Object, BrokerConnection> x$4) {
                Tuple2<Object, BrokerConnection> tuple2 = x$4;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    long id = tuple2._1$mcJ$sp();
                    BrokerConnection connection = (BrokerConnection)tuple2._2();
                    this.result$1.connections.add(new LongIdLabeledDTO(id, connection.transport().getRemoteAddress().toString()));
                    ConnectionStatusDTO status2 = connection.get_connection_status(false);
                    if (status2 == null) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.result$1.messages_sent += status2.messages_sent;
                        this.result$1.messages_received += status2.messages_received;
                        this.result$1.read_counter += status2.read_counter;
                        this.result$1.write_counter += status2.write_counter;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.result$1 = result$1;
            }
        });
        return var1_1;
    }

    public AcceptingConnector$BrokerAcceptListener$ BrokerAcceptListener() {
        return this.BrokerAcceptListener$module == null ? this.BrokerAcceptListener$lzycompute() : this.BrokerAcceptListener$module;
    }

    public boolean at_connection_limit() {
        return this.connected().get() >= (long)BoxesRunTime.unboxToInt((Object)OptionSupport$.MODULE$.IntegerToOption(this.config().connection_limit).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return Integer.MAX_VALUE;
            }
        }));
    }

    @Override
    public void update(ConnectorTypeDTO config, Task on_completed2) {
        package$.MODULE$.DispatchQueueWrapper(this.dispatch_queue()).apply((Function0)new Serializable(this, config, on_completed2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AcceptingConnector $outer;
            public final ConnectorTypeDTO config$1;
            public final Task on_completed$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             */
            public void apply$mcV$sp() {
                if (this.$outer.service_state().is_started()) {
                    AcceptingConnectorDTO acceptingConnectorDTO = this.$outer.config();
                    ConnectorTypeDTO connectorTypeDTO = this.config$1;
                    if (acceptingConnectorDTO == null ? connectorTypeDTO != null : !acceptingConnectorDTO.equals(connectorTypeDTO)) {
                        this.$outer.stop(package$.MODULE$.$up((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$update$1 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.$outer.org$apache$activemq$apollo$broker$AcceptingConnector$$anonfun$$$outer().config_$eq((AcceptingConnectorDTO)this.$outer.config$1);
                                this.$outer.org$apache$activemq$apollo$broker$AcceptingConnector$$anonfun$$$outer().start(this.$outer.on_completed$1);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }));
                        return;
                    }
                }
                this.$outer.config_$eq((AcceptingConnectorDTO)this.config$1);
                this.on_completed$1.run();
            }

            public /* synthetic */ AcceptingConnector org$apache$activemq$apollo$broker$AcceptingConnector$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.on_completed$1 = on_completed$1;
            }
        });
    }

    public Option<Object> send_buffer_size() {
        return this.send_buffer_size;
    }

    public void send_buffer_size_$eq(Option<Object> x$1) {
        this.send_buffer_size = x$1;
    }

    public Option<Object> receive_buffer_size() {
        return this.receive_buffer_size;
    }

    public void receive_buffer_size_$eq(Option<Object> x$1) {
        this.receive_buffer_size = x$1;
    }

    public void _start(Task on_completed2) {
        if (AcceptingConnector$.MODULE$.$enable_assertions()) {
            Predef$.MODULE$.assert(this.config() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Connector must be configured before it is started.";
                }
            });
        }
        this.receive_buffer_auto_tune_$eq(BoxesRunTime.unboxToBoolean((Object)OptionSupport$.MODULE$.BooleanToOption(this.config().receive_buffer_auto_tune).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        })));
        this.send_buffer_auto_tune_$eq(BoxesRunTime.unboxToBoolean((Object)OptionSupport$.MODULE$.BooleanToOption(this.config().send_buffer_auto_tune).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        })));
        this.accepted().set(0L);
        this.connected().set(0L);
        ObjectRef protocol_name = new ObjectRef((Object)((String)OptionSupport$.MODULE$.AnyToOption((Object)this.config().protocol).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "any";
            }
        })));
        this.protocol_$eq((Protocol)ProtocolFactory$.MODULE$.get((String)protocol_name.elem).getOrElse((Function0)new Serializable(this, protocol_name){
            public static final long serialVersionUID = 0L;
            private final ObjectRef protocol_name$1;

            public final Nothing$ apply() {
                throw new Exception(new StringBuilder().append((Object)"protocol named '").append((Object)((String)this.protocol_name$1.elem)).append((Object)"' does not exist").toString());
            }
            {
                this.protocol_name$1 = protocol_name$1;
            }
        }));
        this.transport_server_$eq(TransportFactory.bind(this.config().bind));
        this.transport_server().setDispatchQueue(this.dispatch_queue());
        this.transport_server().setBlockingExecutor((Executor)Broker$.MODULE$.BLOCKABLE_THREAD_POOL());
        this.transport_server().setTransportServerListener((TransportServerListener)this.BrokerAcceptListener());
        TransportServer transportServer = this.transport_server();
        if (transportServer instanceof BrokerAware) {
            TransportServer x2 = transportServer;
            ((BrokerAware)x2).set_broker(this.broker());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TransportServer transportServer2 = this.transport_server();
        if (transportServer2 instanceof SslTransportServer) {
            BoxedUnit boxedUnit;
            SslTransportServer x2 = (SslTransportServer)transportServer2;
            if (this.broker().key_storage() == null) {
                Connector$.MODULE$.warn((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "You are using a transport that expects the broker's key storage to be configured.";
                    }
                }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                x2.setTrustManagers(this.broker().key_storage().create_trust_managers());
                x2.setKeyManagers(this.broker().key_storage().create_key_managers());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.update_buffer_settings();
        this.transport_server().start(package$.MODULE$.$up((Function0)new Serializable(this, on_completed2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AcceptingConnector $outer;
            private final Task on_completed$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.broker().console_log().info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$_start$3 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Accepting connections at: ").append((Object)this.$outer.org$apache$activemq$apollo$broker$AcceptingConnector$$anonfun$$$outer().transport_server().getBoundAddress()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                this.on_completed$2.run();
            }

            public /* synthetic */ AcceptingConnector org$apache$activemq$apollo$broker$AcceptingConnector$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.on_completed$2 = on_completed$2;
            }
        }));
    }

    public int last_receive_buffer_size() {
        return this.last_receive_buffer_size;
    }

    public void last_receive_buffer_size_$eq(int x$1) {
        this.last_receive_buffer_size = x$1;
    }

    public int last_send_buffer_size() {
        return this.last_send_buffer_size;
    }

    public void last_send_buffer_size_$eq(int x$1) {
        this.last_send_buffer_size = x$1;
    }

    @Override
    public void update_buffer_settings() {
        TransportServer transportServer = this.transport_server();
        if (transportServer instanceof TcpTransportServer) {
            BoxedUnit boxedUnit;
            int next_receive_buffer_size;
            TcpTransportServer x2 = (TcpTransportServer)transportServer;
            if (this.receive_buffer_auto_tune() && (next_receive_buffer_size = this.broker().auto_tuned_send_receiver_buffer_size()) != this.last_receive_buffer_size()) {
                Connector$.MODULE$.debug((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "%s connector receive_buffer_size set to: %d";
                    }
                }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id(), BoxesRunTime.boxToInteger((int)next_receive_buffer_size)}));
                x2.setReceiveBufferSize(next_receive_buffer_size);
                this.last_receive_buffer_size_$eq(next_receive_buffer_size);
            }
            if (this.send_buffer_auto_tune()) {
                int next_send_buffer_size = this.broker().auto_tuned_send_receiver_buffer_size();
                if (next_send_buffer_size != this.last_send_buffer_size()) {
                    Connector$.MODULE$.debug((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "%s connector send_buffer_size set to: %d";
                        }
                    }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id(), BoxesRunTime.boxToInteger((int)next_send_buffer_size)}));
                    x2.setSendBufferSize(next_send_buffer_size);
                    this.last_send_buffer_size_$eq(next_send_buffer_size);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void _stop(Task on_completed2) {
        this.transport_server().stop(package$.MODULE$.$up((Function0)new Serializable(this, on_completed2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AcceptingConnector $outer;
            private final Task on_completed$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.broker().console_log().info((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$_stop$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Stopped connector at: ").append((Object)this.$outer.org$apache$activemq$apollo$broker$AcceptingConnector$$anonfun$$$outer().config().bind).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                this.$outer.transport_server_$eq(null);
                this.$outer.protocol_$eq(null);
                this.on_completed$3.run();
            }

            public /* synthetic */ AcceptingConnector org$apache$activemq$apollo$broker$AcceptingConnector$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.on_completed$3 = on_completed$3;
            }
        }));
    }

    @Override
    public void stopped(BrokerConnection connection) {
        package$.MODULE$.DispatchQueueWrapper(this.dispatch_queue()).apply((Function0)new Serializable(this, connection){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AcceptingConnector $outer;
            private final BrokerConnection connection$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                boolean at_limit = this.$outer.at_connection_limit();
                if (this.$outer.broker().connections().remove((Object)BoxesRunTime.boxToLong((long)this.connection$1.id())).isDefined()) {
                    this.$outer.connected().decrementAndGet();
                    ConnectionStatusDTO status2 = this.connection$1.get_connection_status(false);
                    if (status2 != null) {
                        this.$outer.dead_messages_sent_$eq(this.$outer.dead_messages_sent() + status2.messages_sent);
                        this.$outer.dead_messages_received_$eq(this.$outer.dead_messages_received() + status2.messages_received);
                        this.$outer.dead_read_counter_$eq(this.$outer.dead_read_counter() + status2.read_counter);
                        this.$outer.dead_write_counter_$eq(this.$outer.dead_write_counter() + status2.write_counter);
                    }
                    if (at_limit) {
                        this.$outer.transport_server().resume();
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.connection$1 = connection$1;
            }
        });
    }

    private final Option mem_size$1(String value) {
        return Option$.MODULE$.apply((Object)value).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$5) {
                return (int)MemoryPropertyEditor.parse((String)x$5);
            }
        });
    }

    public AcceptingConnector(Broker broker, String id) {
        this.broker = broker;
        this.id = id;
        Dispatched.class.$init$((Dispatched)this);
        BaseService.class.$init$((BaseService)this);
        SecuredResource$class.$init$(this);
        Connector$class.$init$(this);
        this.dispatch_queue = broker.dispatch_queue();
        this.config = new AcceptingConnectorDTO();
        this.config().id = id;
        this.config().bind = "tcp://0.0.0.:0";
        this.accepted = new LongCounter(LongCounter$.MODULE$.$lessinit$greater$default$1());
        this.connected = new LongCounter(LongCounter$.MODULE$.$lessinit$greater$default$1());
        this.dead_messages_sent = 0L;
        this.dead_messages_received = 0L;
        this.dead_read_counter = 0L;
        this.dead_write_counter = 0L;
        this.receive_buffer_auto_tune = true;
        this.send_buffer_auto_tune = true;
        this.send_buffer_size = None$.MODULE$;
        this.receive_buffer_size = None$.MODULE$;
        this.last_receive_buffer_size = 0;
        this.last_send_buffer_size = 0;
    }
}

