/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.cert.X509Certificate;
import org.apache.activemq.apollo.broker.Connection;
import org.apache.activemq.apollo.broker.Connector;
import org.apache.activemq.apollo.broker.protocol.ProtocolHandler;
import org.apache.activemq.apollo.dto.ConnectionStatusDTO;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.SecuredSession;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.WrappingProtocolCodec;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u00015\u0011\u0001C\u0011:pW\u0016\u00148i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011A\u00022s_.,'O\u0003\u0002\u0006\r\u00051\u0011\r]8mY>T!a\u0002\u0005\u0002\u0011\u0005\u001cG/\u001b<f[FT!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\u0006D_:tWm\u0019;j_:D\u0001b\u0005\u0001\u0003\u0002\u0004%\t\u0001F\u0001\nG>tg.Z2u_J,\u0012!\u0006\t\u0003\u001fYI!a\u0006\u0002\u0003\u0013\r{gN\\3di>\u0014\b\u0002C\r\u0001\u0005\u0003\u0007I\u0011\u0001\u000e\u0002\u001b\r|gN\\3di>\u0014x\fJ3r)\tY\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0003V]&$\bb\u0002\u0012\u0019\u0003\u0003\u0005\r!F\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0015B\u000b\u0002\u0015\r|gN\\3di>\u0014\b\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001(\u0003\tIG-F\u0001)!\ta\u0012&\u0003\u0002+;\t!Aj\u001c8h\u0011!a\u0003A!A!\u0002\u0013A\u0013aA5eA!)a\u0006\u0001C\u0001_\u00051A(\u001b8jiz\"2\u0001M\u00193!\ty\u0001\u0001C\u0003\u0014[\u0001\u0007Q\u0003C\u0003'[\u0001\u0007\u0001\u0006C\u00045\u0001\u0001\u0007I\u0011A\u001b\u0002!A\u0014x\u000e^8d_2|\u0006.\u00198eY\u0016\u0014X#\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\u0012\u0011\u0001\u00039s_R|7m\u001c7\n\u0005mB$a\u0004)s_R|7m\u001c7IC:$G.\u001a:\t\u000fu\u0002\u0001\u0019!C\u0001}\u0005!\u0002O]8u_\u000e|Gn\u00185b]\u0012dWM]0%KF$\"aG \t\u000f\tb\u0014\u0011!a\u0001m!1\u0011\t\u0001Q!\nY\n\u0011\u0003\u001d:pi>\u001cw\u000e\\0iC:$G.\u001a:!\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0003)\u0019Xm]:j_:|\u0016\u000eZ\u000b\u0002\u000bB\u0019AD\u0012%\n\u0005\u001dk\"AB(qi&|g\u000e\u0005\u0002J\u0019:\u0011ADS\u0005\u0003\u0017v\ta\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111*\b\u0005\u0006!\u0002!\t%U\u0001\ti>\u001cFO]5oOR\t!\u000b\u0005\u0002T16\tAK\u0003\u0002V-\u0006!A.\u00198h\u0015\u00059\u0016\u0001\u00026bm\u0006L!!\u0014+\t\u000bi\u0003A\u0011K.\u0002\r}\u001bH/\u0019:u)\tYB\fC\u0003^3\u0002\u0007a,\u0001\u0007p]~\u001bw.\u001c9mKR,G\r\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006a\u0001.Y<uI&\u001c\b/\u0019;dQ*\u00111MC\u0001\u000bMV\u001cXm]8ve\u000e,\u0017BA3a\u0005\u0011!\u0016m]6\t\u000b\u001d\u0004A\u0011\u000b5\u0002\u000b}\u001bHo\u001c9\u0015\u0005mI\u0007\"B/g\u0001\u0004q\u0006\"B6\u0001\t#b\u0017AF8o?R\u0014\u0018M\\:q_J$xlY8o]\u0016\u001cG/\u001a3\u0015\u0003mAQA\u001c\u0001\u0005R1\f\u0011d\u001c8`iJ\fgn\u001d9peR|F-[:d_:tWm\u0019;fI\")\u0001\u000f\u0001C)c\u0006!rN\\0ue\u0006t7\u000f]8si~\u001bw.\\7b]\u0012$\"a\u0007:\t\u000bM|\u0007\u0019\u0001;\u0002\u000f\r|W.\\1oIB\u00111+^\u0005\u0003mR\u0013aa\u00142kK\u000e$\b\"\u0002=\u0001\t#J\u0018\u0001F8o?R\u0014\u0018M\\:q_J$xLZ1jYV\u0014X\r\u0006\u0002\u001cu\")1p\u001ea\u0001y\u0006)QM\u001d:peB\u0019Q0!\u0001\u000e\u0003yT!a ,\u0002\u0005%|\u0017bAA\u0002}\nY\u0011jT#yG\u0016\u0004H/[8o\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\tQcZ3u?\u000e|gN\\3di&|gnX:uCR,8\u000f\u0006\u0003\u0002\f\u0005]\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005EA!A\u0002ei>LA!!\u0006\u0002\u0010\t\u00192i\u001c8oK\u000e$\u0018n\u001c8Ti\u0006$Xo\u001d#U\u001f\"Q\u0011\u0011DA\u0003!\u0003\u0005\r!a\u0007\u0002\u000b\u0011,'-^4\u0011\u0007q\ti\"C\u0002\u0002 u\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002$\u0001!\t!!\n\u0002\u001dA\u0014x\u000e^8d_2|6m\u001c3fGV!\u0011qEA\u0017)\u0011\tI#a\u0010\u0011\t\u0005-\u0012Q\u0006\u0007\u0001\t!\ty#!\tC\u0002\u0005E\"!\u0001+\u0012\t\u0005M\u0012\u0011\b\t\u00049\u0005U\u0012bAA\u001c;\t9aj\u001c;iS:<\u0007c\u0001\u000f\u0002<%\u0019\u0011QH\u000f\u0003\r\u0005s\u0017PU3g\u0011!\t\t%!\tA\u0002\u0005\r\u0013!B2mCjT\b#B%\u0002F\u0005%\u0012bAA$\u001d\n)1\t\\1tg\"9\u00111\n\u0001\u0005\u0002\u00055\u0013\u0001D2feRLg-[2bi\u0016\u001cXCAA(!\u0015a\u0012\u0011KA+\u0013\r\t\u0019&\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0011\u0019WM\u001d;\u000b\u0007\u0005}c+\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\u0019'!\u0017\u0003\u001fa+\u0004'O\"feRLg-[2bi\u0016D\u0011\"a\u001a\u0001#\u0003%\t!!\u001b\u0002?\u001d,GoX2p]:,7\r^5p]~\u001bH/\u0019;vg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002l)\"\u00111DA7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class BrokerConnection
extends Connection {
    private Connector connector;
    private final long id;
    private ProtocolHandler protocol_handler;

    public Connector connector() {
        return this.connector;
    }

    public void connector_$eq(Connector x$1) {
        this.connector = x$1;
    }

    public long id() {
        return this.id;
    }

    public ProtocolHandler protocol_handler() {
        return this.protocol_handler;
    }

    public void protocol_handler_$eq(ProtocolHandler x$1) {
        this.protocol_handler = x$1;
    }

    public Option<String> session_id() {
        return Option$.MODULE$.apply((Object)this.protocol_handler()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(ProtocolHandler x) {
                return Option$.MODULE$.apply((Object)x.session_id());
            }
        });
    }

    public String toString() {
        return new StringBuilder().append((Object)"id: ").append((Object)((Object)BoxesRunTime.boxToLong((long)this.id())).toString()).toString();
    }

    @Override
    public void _start(Task on_completed2) {
        this.protocol_handler().set_connection(this);
        super._start(on_completed2);
    }

    @Override
    public void _stop(Task on_completed2) {
        this.connector().stopped(this);
        super._stop(on_completed2);
    }

    @Override
    public void on_transport_connected() {
        this.connector().broker().connection_log().info((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "connected: local:%s, remote:%s";
            }
        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transport().getLocalAddress(), this.transport().getRemoteAddress()}));
        this.protocol_handler().on_transport_connected();
    }

    @Override
    public void on_transport_disconnected() {
        this.connector().broker().connection_log().info((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "disconnected: local:%s, remote:%s";
            }
        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transport().getLocalAddress(), this.transport().getRemoteAddress()}));
        this.protocol_handler().on_transport_disconnected();
    }

    @Override
    public void on_transport_command(Object command) {
        try {
            this.protocol_handler().on_transport_command(command);
        }
        catch (Exception exception) {
            this.on_failure(exception);
        }
    }

    @Override
    public void on_transport_failure(IOException error) {
        this.protocol_handler().on_transport_failure(error);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionStatusDTO get_connection_status(boolean debug) {
        void var2_2;
        ConnectionStatusDTO result = this.protocol_handler() == null ? new ConnectionStatusDTO() : this.protocol_handler().create_connection_status(debug);
        result.id = ((Object)BoxesRunTime.boxToLong((long)this.id())).toString();
        result.state = this.service_state().toString();
        result.state_since = this.service_state().since();
        result.protocol = this.protocol_handler().protocol();
        result.connector = this.connector().id();
        result.remote_address = (String)Option$.MODULE$.apply((Object)this.transport().getRemoteAddress()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SocketAddress x$1) {
                return x$1.toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        result.local_address = (String)Option$.MODULE$.apply((Object)this.transport().getLocalAddress()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SocketAddress x$2) {
                return x$2.toString();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        result.protocol_session_id = this.protocol_handler().session_id();
        ProtocolCodec wf = this.transport().getProtocolCodec();
        if (wf != null) {
            result.write_counter = wf.getWriteCounter();
            result.read_counter = wf.getReadCounter();
            result.last_read_size = wf.getLastReadSize();
            result.last_write_size = wf.getLastWriteSize();
        }
        return var2_2;
    }

    public boolean get_connection_status$default$1() {
        return false;
    }

    public <T> T protocol_codec(Class<T> clazz) {
        ProtocolCodec rc = this.transport().getProtocolCodec();
        while (true) {
            ProtocolCodec protocolCodec;
            if (rc == null) {
                return null;
            }
            if (clazz.isInstance(rc)) {
                return clazz.cast(rc);
            }
            ProtocolCodec protocolCodec2 = rc;
            if (protocolCodec2 instanceof WrappingProtocolCodec) {
                WrappingProtocolCodec x2 = (WrappingProtocolCodec)protocolCodec2;
                protocolCodec = x2.getNext();
            } else {
                protocolCodec = null;
            }
            rc = protocolCodec;
        }
    }

    public X509Certificate[] certificates() {
        Option option;
        Transport transport = this.transport();
        if (transport instanceof SecuredSession) {
            Transport x2 = transport;
            option = Option$.MODULE$.apply((Object)((SecuredSession)x2).getPeerX509Certificates());
        } else {
            None$ none$;
            SecuredSession securedSession = this.protocol_codec(SecuredSession.class);
            if (securedSession == null) {
                SecuredSession x2 = securedSession;
                none$ = None$.MODULE$;
            } else {
                none$ = Option$.MODULE$.apply((Object)securedSession.getPeerX509Certificates());
            }
            option = none$;
        }
        return (X509Certificate[])option.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final X509Certificate[] apply() {
                return (X509Certificate[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(X509Certificate.class));
            }
        });
    }

    public BrokerConnection(Connector connector, long id) {
        this.connector = connector;
        this.id = id;
        this.protocol_handler = null;
    }
}

