/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.apache.activemq.apollo.broker.security.EncryptionSupport$;
import org.apache.activemq.apollo.dto.BrokerDTO;
import org.apache.activemq.apollo.dto.VirtualHostDTO;
import org.apache.activemq.apollo.dto.XmlCodec;
import org.apache.activemq.apollo.util.FileSupport$;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConfigStore$ {
    public static final ConfigStore$ MODULE$;

    static {
        new ConfigStore$();
    }

    public BrokerDTO load(File file, Function1<String, BoxedUnit> func) {
        return this.load((Function0<InputStream>)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final FileInputStream apply() {
                return new FileInputStream(this.file$1);
            }
            {
                this.file$1 = file$1;
            }
        }, this.config_properties(file), func);
    }

    public BrokerDTO load_xml(byte[] in, Function1<String, BoxedUnit> func) {
        return this.load((Function0<InputStream>)new Serializable(in){
            public static final long serialVersionUID = 0L;
            private final byte[] in$1;

            public final ByteArrayInputStream apply() {
                return new ByteArrayInputStream(this.in$1);
            }
            {
                this.in$1 = in$1;
            }
        }, this.config_properties(null), func);
    }

    public BrokerDTO load(Function0<InputStream> is, Properties prop, Function1<String, BoxedUnit> func) {
        BrokerDTO rc = (BrokerDTO)XmlCodec.decode(BrokerDTO.class, (InputStream)((InputStream)is.apply()), (Properties)prop, (ValidationEventHandler)new ValidationEventHandler(func){
            private final Function1 func$1;

            public boolean handleEvent(ValidationEvent event) {
                String string;
                int n = event.getSeverity();
                switch (n) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                    case 2: {
                        string = "fatal error";
                        break;
                    }
                    case 1: {
                        string = "error";
                        break;
                    }
                    case 0: {
                        string = "warning";
                    }
                }
                String level = string;
                this.func$1.apply((Object)new StringOps(Predef$.MODULE$.augmentString("%s at (%d:%d): %s ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{level, BoxesRunTime.boxToInteger((int)event.getLocator().getLineNumber()), BoxesRunTime.boxToInteger((int)event.getLocator().getColumnNumber()), event.getMessage()})));
                return true;
            }
            {
                this.func$1 = func$1;
            }
        });
        JavaConversions$.MODULE$.asScalaBuffer(rc.virtual_hosts).foreach((Function1)new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;

            public final void apply(VirtualHostDTO host) {
                if (host.store == null) {
                    this.func$1.apply((Object)new StringOps(Predef$.MODULE$.augmentString("error: virtual host '%s' does not have valid store configured")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host.id})));
                }
            }
            {
                this.func$1 = func$1;
            }
        });
        return rc;
    }

    /*
     * WARNING - void declaration
     */
    public Properties config_properties(File file) {
        void var2_2;
        File prop_file;
        Properties props = new Properties();
        JavaConversions$.MODULE$.asScalaSet(System.getenv().entrySet()).foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Map.Entry<String, String> entry) {
                return ((Hashtable)this.props$1).put(new StringBuilder().append((Object)"env.").append((Object)entry.getKey()).toString(), entry.getValue());
            }
            {
                this.props$1 = props$1;
            }
        });
        ((Hashtable)props).putAll(System.getProperties());
        Object object = file == null ? BoxedUnit.UNIT : ((prop_file = FileSupport$.MODULE$.to_rich_file(file.getParentFile()).$div(new StringBuilder().append((Object)file.getName()).append((Object)".properties").toString())).exists() ? FileSupport$.MODULE$.using((Closeable)new FileInputStream(prop_file), (Function1)new Serializable(props, prop_file){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;
            private final File prop_file$1;

            public final void apply(FileInputStream is) {
                Properties p = new Properties();
                p.load(new FileInputStream(this.prop_file$1));
                ((Hashtable)this.props$1).putAll(EncryptionSupport$.MODULE$.decrypt(p));
            }
            {
                this.props$1 = props$1;
                this.prop_file$1 = prop_file$1;
            }
        }) : BoxedUnit.UNIT);
        return var2_2;
    }

    private ConfigStore$() {
        MODULE$ = this;
    }
}

