/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.apollo.broker.Acquirer;
import org.apache.activemq.apollo.broker.Broker$;
import org.apache.activemq.apollo.broker.BrokerConnection;
import org.apache.activemq.apollo.broker.Delivery;
import org.apache.activemq.apollo.broker.DeliveryConsumer;
import org.apache.activemq.apollo.broker.DeliveryProducer;
import org.apache.activemq.apollo.broker.DeliveryProducer$class;
import org.apache.activemq.apollo.broker.DeliverySession;
import org.apache.activemq.apollo.broker.GroupBucket;
import org.apache.activemq.apollo.broker.Queue;
import org.apache.activemq.apollo.broker.Queue$;
import org.apache.activemq.apollo.broker.QueueEntry;
import org.apache.activemq.apollo.broker.Sink;
import org.apache.activemq.apollo.broker.StallCheckSupport;
import org.apache.activemq.apollo.broker.StallCheckSupport$class;
import org.apache.activemq.apollo.broker.Subscription$;
import org.apache.activemq.apollo.broker.store.StoreUOW;
import org.apache.activemq.apollo.dto.QueueConsumerLinkDTO;
import org.apache.activemq.apollo.util.CircularBuffer;
import org.apache.activemq.apollo.util.Dispatched;
import org.apache.activemq.apollo.util.list.LinkedNode;
import org.apache.activemq.apollo.util.list.LinkedNodeList;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\req!B\u0001\u0003\u0011\u0003i\u0011\u0001D*vEN\u001c'/\u001b9uS>t'BA\u0002\u0005\u0003\u0019\u0011'o\\6fe*\u0011QAB\u0001\u0007CB|G\u000e\\8\u000b\u0005\u001dA\u0011\u0001C1di&4X-\\9\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u00051\u0019VOY:de&\u0004H/[8o'\ry!C\u0007\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tA\u0001\\1oO*\tq#\u0001\u0003kCZ\f\u0017BA\r\u0015\u0005\u0019y%M[3diB\u00111DH\u0007\u00029)\u0011Q\u0004B\u0001\u0005kRLG.\u0003\u0002 9\t\u0019Aj\\4\t\u000b\u0005zA\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u0013\u0010\u0007\u0004%)!J\u0001\u0013I\u0015t\u0017M\u00197f?\u0006\u001c8/\u001a:uS>t7/F\u0001'!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u001d\u0011un\u001c7fC:Da!L\b!\u0002\u001b1\u0013a\u0005\u0013f]\u0006\u0014G.Z0bgN,'\u000f^5p]N\u0004c\u0001\u0002\t\u0003\u0001=\u001abA\f\n1gYJ\u0004C\u0001\b2\u0013\t\u0011$A\u0001\u0005BGF,\u0018N]3s!\tqA'\u0003\u00026\u0005\t\u0001B)\u001a7jm\u0016\u0014\u0018\u0010\u0015:pIV\u001cWM\u001d\t\u00037]J!\u0001\u000f\u000f\u0003\u0015\u0011K7\u000f]1uG\",G\r\u0005\u0002\u000fu%\u00111H\u0001\u0002\u0012'R\fG\u000e\\\"iK\u000e\\7+\u001e9q_J$\b\u0002C\u001f/\u0005\u000b\u0007I\u0011\u0001 \u0002\u000bE,X-^3\u0016\u0003}\u0002\"A\u0004!\n\u0005\u0005\u0013!!B)vKV,\u0007\u0002C\"/\u0005\u0003\u0005\u000b\u0011B \u0002\rE,X-^3!\u0011!)eF!b\u0001\n\u00031\u0015\u0001C2p]N,X.\u001a:\u0016\u0003\u001d\u0003\"A\u0004%\n\u0005%\u0013!\u0001\u0005#fY&4XM]=D_:\u001cX/\\3s\u0011!YeF!A!\u0002\u00139\u0015!C2p]N,X.\u001a:!\u0011\u0015\tc\u0006\"\u0001N)\rqu\n\u0015\t\u0003\u001d9BQ!\u0010'A\u0002}BQ!\u0012'A\u0002\u001dCQA\u0015\u0018\u0005\u0002M\u000ba\u0002Z5ta\u0006$8\r[0rk\u0016,X-F\u0001U!\t)&,D\u0001W\u0015\t9\u0006,\u0001\u0007iC^$H-[:qCR\u001c\u0007N\u0003\u0002Z\u0015\u0005Qa-^:fg>,(oY3\n\u0005m3&!\u0004#jgB\fGo\u00195Rk\u0016,X\rC\u0004^]\t\u0007I\u0011\u00010\u0002\u0005%$W#A0\u0011\u0005\u001d\u0002\u0017BA1)\u0005\rIe\u000e\u001e\u0005\u0007G:\u0002\u000b\u0011B0\u0002\u0007%$\u0007\u0005C\u0004f]\u0001\u0007I\u0011\u00014\u0002\u0011\u0005\u001c\u0017/^5sK\u0012,\u0012a\u001a\t\u0004Q.lW\"A5\u000b\u0005)d\u0012\u0001\u00027jgRL!\u0001\\5\u0003\u001d1Kgn[3e\u001d>$W\rT5tiB\u0011an\\\u0007\u0002]\u0019!\u0001O\f\u0001r\u0005I\t5-];je\u0016$\u0017+^3vK\u0016sGO]=\u0014\u0005=\u0014\bc\u00015t[&\u0011A/\u001b\u0002\u000b\u0019&t7.\u001a3O_\u0012,\u0007\u0002\u0003<p\u0005\u000b\u0007I\u0011A<\u0002\u000b\u0015tGO]=\u0016\u0003a\u0004\"AD=\n\u0005i\u0014!AC)vKV,WI\u001c;ss\"AAp\u001cB\u0001B\u0003%\u00010\u0001\u0004f]R\u0014\u0018\u0010\t\u0005\u0006C=$\tA \u000b\u0003[~DQA^?A\u0002aDq!a\u0001p\t\u0003\t)!A\u0002bG.$B!a\u0002\u0002\u000eA\u0019q%!\u0003\n\u0007\u0005-\u0001F\u0001\u0003V]&$\b\u0002CA\b\u0003\u0003\u0001\r!!\u0005\u0002\u0007U|w\u000f\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9BA\u0001\u0006gR|'/Z\u0005\u0005\u00037\t)B\u0001\u0005Ti>\u0014X-V(X\u0011\u001d\tyb\u001cC\u0001\u0003C\taA]3n_Z,G\u0003BA\u0004\u0003GA\u0001\"a\u0004\u0002\u001e\u0001\u0007\u0011\u0011\u0003\u0005\b\u0003OyG\u0011AA\u0015\u00039Ign\u0019:f[\u0016tGo\u00188bG.,\"!a\u0002\t\u000f\u00055r\u000e\"\u0001\u0002*\u0005!a.Y2l\u0011%\t\tD\fa\u0001\n\u0003\t\u0019$\u0001\u0007bGF,\u0018N]3e?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0005U\u0002\"CA\u001c\u0003_\t\t\u00111\u0001h\u0003\rAH%\r\u0005\b\u0003wq\u0003\u0015)\u0003h\u0003%\t7-];je\u0016$\u0007\u0005C\u0005\u0002@9\u0002\r\u0011\"\u0001\u0002B\u000591/Z:tS>tWCAA\"!\rq\u0011QI\u0005\u0004\u0003\u000f\u0012!a\u0004#fY&4XM]=TKN\u001c\u0018n\u001c8\t\u0013\u0005-c\u00061A\u0005\u0002\u00055\u0013aC:fgNLwN\\0%KF$B!a\u0002\u0002P!Q\u0011qGA%\u0003\u0003\u0005\r!a\u0011\t\u0011\u0005Mc\u0006)Q\u0005\u0003\u0007\n\u0001b]3tg&|g\u000e\t\u0005\t\u0003/r\u0003\u0019!C\u0001o\u0006\u0019\u0001o\\:\t\u0013\u0005mc\u00061A\u0005\u0002\u0005u\u0013a\u00029pg~#S-\u001d\u000b\u0005\u0003\u000f\ty\u0006C\u0005\u00028\u0005e\u0013\u0011!a\u0001q\"9\u00111\r\u0018!B\u0013A\u0018\u0001\u00029pg\u0002B\u0011\"a\u001a/\u0001\u0004%\t!!\u001b\u0002\u001b\u0005\u001c\u0017/^5sK\u0012|6/\u001b>f+\t\tY\u0007E\u0002(\u0003[J1!a\u001c)\u0005\u0011auN\\4\t\u0013\u0005Md\u00061A\u0005\u0002\u0005U\u0014!E1dcVL'/\u001a3`g&TXm\u0018\u0013fcR!\u0011qAA<\u0011)\t9$!\u001d\u0002\u0002\u0003\u0007\u00111\u000e\u0005\t\u0003wr\u0003\u0015)\u0003\u0002l\u0005q\u0011mY9vSJ,GmX:ju\u0016\u0004\u0003BBA@]\u0011\u0005a,\u0001\bbGF,\u0018N]3e?\u000e|WO\u001c;\t\u0013\u0005\re\u00061A\u0005\u0002\u0005\u0015\u0015!G3ocV,W/Z0tSj,w\f]3s?&tG/\u001a:wC2,\"!a\"\u0011\tm\tIiX\u0005\u0004\u0003\u0017c\"AD\"je\u000e,H.\u0019:Ck\u001a4WM\u001d\u0005\n\u0003\u001fs\u0003\u0019!C\u0001\u0003#\u000bQ$\u001a8rk\u0016,XmX:ju\u0016|\u0006/\u001a:`S:$XM\u001d<bY~#S-\u001d\u000b\u0005\u0003\u000f\t\u0019\n\u0003\u0006\u00028\u00055\u0015\u0011!a\u0001\u0003\u000fC\u0001\"a&/A\u0003&\u0011qQ\u0001\u001bK:\fX/Z;f?NL'0Z0qKJ|\u0016N\u001c;feZ\fG\u000e\t\u0005\b\u00037sC\u0011AAO\u0003=\u0019'/Z1uK~c\u0017N\\6`IR|G\u0003BAP\u0003W\u0003B!!)\u0002(6\u0011\u00111\u0015\u0006\u0004\u0003K#\u0011a\u00013u_&!\u0011\u0011VAR\u0005Q\tV/Z;f\u0007>t7/^7fe2Kgn\u001b#U\u001f\"I\u0011QVAM!\u0003\u0005\rAJ\u0001\u0010S:\u001cG.\u001e3f?6,GO]5dg\"1\u0011\u0011\u0017\u0018\u0005\u0002y\u000bQ$\u0019<h?\u0016t\u0017/^3vK~\u001b\u0018N_3`a\u0016\u0014x,\u001b8uKJ4\u0018\r\u001c\u0005\n\u0003ks\u0003\u0019!C\u0001\u0003S\nQ$\u001a8rk\u0016,XmX:ju\u0016|\u0016\r^0mCN$x,\u001b8uKJ4\u0018\r\u001c\u0005\n\u0003ss\u0003\u0019!C\u0001\u0003w\u000b\u0011%\u001a8rk\u0016,XmX:ju\u0016|\u0016\r^0mCN$x,\u001b8uKJ4\u0018\r\\0%KF$B!a\u0002\u0002>\"Q\u0011qGA\\\u0003\u0003\u0005\r!a\u001b\t\u0011\u0005\u0005g\u0006)Q\u0005\u0003W\na$\u001a8rk\u0016,XmX:ju\u0016|\u0016\r^0mCN$x,\u001b8uKJ4\u0018\r\u001c\u0011\t\u0013\u0005\u0015g\u00061A\u0005\u0002\u0005%\u0014AC:uCJ$X\rZ0bi\"I\u0011\u0011\u001a\u0018A\u0002\u0013\u0005\u00111Z\u0001\u000fgR\f'\u000f^3e?\u0006$x\fJ3r)\u0011\t9!!4\t\u0015\u0005]\u0012qYA\u0001\u0002\u0004\tY\u0007\u0003\u0005\u0002R:\u0002\u000b\u0015BA6\u0003-\u0019H/\u0019:uK\u0012|\u0016\r\u001e\u0011\t\u0013\u0005Ug\u00061A\u0005\u0002\u0005%\u0014a\u0004;pi\u0006dw,Y2l?\u000e|WO\u001c;\t\u0013\u0005eg\u00061A\u0005\u0002\u0005m\u0017a\u0005;pi\u0006dw,Y2l?\u000e|WO\u001c;`I\u0015\fH\u0003BA\u0004\u0003;D!\"a\u000e\u0002X\u0006\u0005\t\u0019AA6\u0011!\t\tO\fQ!\n\u0005-\u0014\u0001\u0005;pi\u0006dw,Y2l?\u000e|WO\u001c;!\u0011%\t)O\fa\u0001\n\u0003\tI'\u0001\bu_R\fGnX1dW~\u001b\u0018N_3\t\u0013\u0005%h\u00061A\u0005\u0002\u0005-\u0018A\u0005;pi\u0006dw,Y2l?NL'0Z0%KF$B!a\u0002\u0002n\"Q\u0011qGAt\u0003\u0003\u0005\r!a\u001b\t\u0011\u0005Eh\u0006)Q\u0005\u0003W\nq\u0002^8uC2|\u0016mY6`g&TX\r\t\u0005\n\u0003kt\u0003\u0019!C\u0001\u0003S\n\u0001\u0003^8uC2|f.Y2l?\u000e|WO\u001c;\t\u0013\u0005eh\u00061A\u0005\u0002\u0005m\u0018\u0001\u0006;pi\u0006dwL\\1dW~\u001bw.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0005u\bBCA\u001c\u0003o\f\t\u00111\u0001\u0002l!A!\u0011\u0001\u0018!B\u0013\tY'A\tu_R\fGn\u00188bG.|6m\\;oi\u0002B\u0011B!\u0002/\u0001\u0004%\t!!\u001b\u0002\u0015%$G.Z0ti\u0006\u0014H\u000fC\u0005\u0003\n9\u0002\r\u0011\"\u0001\u0003\f\u0005q\u0011\u000e\u001a7f?N$\u0018M\u001d;`I\u0015\fH\u0003BA\u0004\u0005\u001bA!\"a\u000e\u0003\b\u0005\u0005\t\u0019AA6\u0011!\u0011\tB\fQ!\n\u0005-\u0014aC5eY\u0016|6\u000f^1si\u0002B\u0011B!\u0006/\u0001\u0004%\t!!\u001b\u0002\u0015%$G.Z0u_R\fG\u000eC\u0005\u0003\u001a9\u0002\r\u0011\"\u0001\u0003\u001c\u0005q\u0011\u000e\u001a7f?R|G/\u00197`I\u0015\fH\u0003BA\u0004\u0005;A!\"a\u000e\u0003\u0018\u0005\u0005\t\u0019AA6\u0011!\u0011\tC\fQ!\n\u0005-\u0014aC5eY\u0016|Fo\u001c;bY\u0002BqA!\n/\t\u0003\u00119#A\u0005bG.|&/\u0019;fgV\u0011!\u0011\u0006\t\u0006O\t-\"qF\u0005\u0004\u0005[A#AB(qi&|g\u000eE\u0004(\u0005c\u0011)D!\u000e\n\u0007\tM\u0002F\u0001\u0004UkBdWM\r\t\u0004O\t]\u0012b\u0001B\u001dQ\t1Ai\\;cY\u0016DqA!\u0010/\t\u0003\u0012y$\u0001\u0005u_N#(/\u001b8h)\t\u0011\t\u0005E\u0002\u0014\u0005\u0007J1A!\u0012\u0015\u0005\u0019\u0019FO]5oO\"1!\u0011\n\u0018\u0005\u0002\u0015\nqA\u0019:poN,'\u000f\u0003\u0004\u0003N9\"\t!J\u0001\nKb\u001cG.^:jm\u0016D\u0001B!\u0015/\u0005\u0004%\tAX\u0001\u0010G>t7/^7fe~\u0013WO\u001a4fe\"9!Q\u000b\u0018!\u0002\u0013y\u0016\u0001E2p]N,X.\u001a:`EV4g-\u001a:!\u0011\u001d\u0011IF\fC\u0001\u00057\nAa\u001c9f]R\u0011\u0011q\u0001\u0005\t\u0005?r\u0003\u0019!C\u0001=\u0006i1/^:qK:$wlY8v]RD\u0011Ba\u0019/\u0001\u0004%\tA!\u001a\u0002#M,8\u000f]3oI~\u001bw.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002\b\t\u001d\u0004\"CA\u001c\u0005C\n\t\u00111\u0001`\u0011\u001d\u0011YG\fQ!\n}\u000bab];ta\u0016tGmX2pk:$\b\u0005C\u0004\u0003p9\"\t!!\u000b\u0002\u000fM,8\u000f]3oI\"9!1\u000f\u0018\u0005\u0002\u0005%\u0012A\u0002:fgVlW\rC\u0004\u0003x9\"\tA!\u001f\u0002\u0011=tw\f\u001a:bS:$B!a\u0002\u0003|!I!Q\u0010B;\t\u0003\u0007!qP\u0001\u0005MVt7\rE\u0003(\u0005\u0003\u000b9!C\u0002\u0003\u0004\"\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\n\u0005\u000fs\u0003\u0019!C\u0001\u0005\u0013\u000ba\u0002\u001a:bS:|v/\u0019;dQ\u0016\u00148/\u0006\u0002\u0003\fB1!Q\u0012BO\u0005GsAAa$\u0003\u001a:!!\u0011\u0013BL\u001b\t\u0011\u0019JC\u0002\u0003\u00162\ta\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0007\tm\u0005&A\u0004qC\u000e\\\u0017mZ3\n\t\t}%\u0011\u0015\u0002\u0005\u0019&\u001cHOC\u0002\u0003\u001c\"\u0002Ra\nBS\u0003\u000fI1Aa*)\u0005%1UO\\2uS>t\u0007\u0007C\u0005\u0003,:\u0002\r\u0011\"\u0001\u0003.\u0006\u0011BM]1j]~;\u0018\r^2iKJ\u001cx\fJ3r)\u0011\t9Aa,\t\u0015\u0005]\"\u0011VA\u0001\u0002\u0004\u0011Y\t\u0003\u0005\u00034:\u0002\u000b\u0015\u0002BF\u0003=!'/Y5o?^\fGo\u00195feN\u0004\u0003b\u0002B\\]\u0011\u0005\u0011\u0011F\u0001\u000eG\",7m[0ee\u0006Lg.\u001a3\t\u000f\tmf\u0006\"\u0001\u0003\\\u0005)1\r\\8tK\"9!q\u0018\u0018\u0005\u0002\t\u0005\u0017aB1em\u0006t7-\u001a\u000b\u0005\u0003\u000f\u0011\u0019\rC\u0004\u0003F\nu\u0006\u0019\u0001=\u0002\u000bY\fG.^3\t\u000f\t%g\u0006\"\u0001\u0003L\u00061!/Z<j]\u0012$B!a\u0002\u0003N\"9!Q\u0019Bd\u0001\u0004A\bB\u0002Bi]\u0011\u0005Q%A\u0006uC&dw\f]1sW\u0016$\u0007b\u0002Bk]\u0011\u0005!q[\u0001\b[\u0006$8\r[3t)\r1#\u0011\u001c\u0005\bm\nM\u0007\u0019\u0001Bn!\rq!Q\\\u0005\u0004\u0005?\u0014!\u0001\u0003#fY&4XM]=\t\r\t\rh\u0006\"\u0001&\u0003\u00111W\u000f\u001c7\t\u000f\t\u001dh\u0006\"\u0001\u0003j\u0006)qN\u001a4feR\u0019aEa;\t\u0011\t5(Q\u001da\u0001\u00057\f\u0001\u0002Z3mSZ,'/\u001f\u0005\b\u0005ctC\u0011\u0001Bz\u0003\u001d\t7-];je\u0016$2!\u001cB{\u0011\u00191(q\u001ea\u0001q\"9!\u0011 \u0018\u0005\u0002\u0005%\u0012\u0001F1eUV\u001cHo\u00189sK\u001a,Go\u00195`g&TX\rC\u0004\u0003~:\"\t!!\u000b\u0002\u001fI,g-\u001b7m?B\u0014XMZ3uG\"D\u0011b!\u0001/#\u0003%\taa\u0001\u00023\r\u0014X-\u0019;f?2Lgn[0ei>$C-\u001a4bk2$H%M\u000b\u0003\u0007\u000bQ3AJB\u0004W\t\u0019I\u0001\u0005\u0003\u0004\f\rUQBAB\u0007\u0015\u0011\u0019ya!\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAB\nQ\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r]1Q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class Subscription
implements Acquirer,
DeliveryProducer,
Dispatched,
StallCheckSupport {
    private final Queue queue;
    private final DeliveryConsumer consumer;
    private final int id;
    private LinkedNodeList<AcquiredQueueEntry> acquired;
    private DeliverySession session;
    private QueueEntry pos;
    private long acquired_size;
    private CircularBuffer<Object> enqueue_size_per_interval;
    private long enqueue_size_at_last_interval;
    private long started_at;
    private long total_ack_count;
    private long total_ack_size;
    private long total_nack_count;
    private long idle_start;
    private long idle_total;
    private final int consumer_buffer;
    private int suspend_count;
    private List<Function0<BoxedUnit>> drain_watchers;
    private long stall_start;
    private long stall_ms;

    public static void trace(Throwable throwable) {
        Subscription$.MODULE$.trace(throwable);
    }

    public static void trace(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.trace(throwable, function0, seq);
    }

    public static void trace(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.trace(function0, seq);
    }

    public static void debug(Throwable throwable) {
        Subscription$.MODULE$.debug(throwable);
    }

    public static void debug(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.debug(throwable, function0, seq);
    }

    public static void debug(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.debug(function0, seq);
    }

    public static void info(Throwable throwable) {
        Subscription$.MODULE$.info(throwable);
    }

    public static void info(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.info(throwable, function0, seq);
    }

    public static void info(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.info(function0, seq);
    }

    public static void warn(Throwable throwable) {
        Subscription$.MODULE$.warn(throwable);
    }

    public static void warn(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.warn(throwable, function0, seq);
    }

    public static void warn(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.warn(function0, seq);
    }

    public static void error(Throwable throwable) {
        Subscription$.MODULE$.error(throwable);
    }

    public static void error(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.error(throwable, function0, seq);
    }

    public static void error(Function0<String> function0, Seq<Object> seq) {
        Subscription$.MODULE$.error(function0, seq);
    }

    public static void org$apache$activemq$apollo$util$Log$_setter_$log_$eq(Logger logger) {
        Subscription$.MODULE$.org$apache$activemq$apollo$util$Log$_setter_$log_$eq(logger);
    }

    public static Logger log() {
        return Subscription$.MODULE$.log();
    }

    public static boolean $enable_assertions() {
        return Subscription$.MODULE$.$enable_assertions();
    }

    @Override
    public long stall_start() {
        return this.stall_start;
    }

    @Override
    public void stall_start_$eq(long x$1) {
        this.stall_start = x$1;
    }

    @Override
    public long stall_ms() {
        return this.stall_ms;
    }

    @Override
    public void stall_ms_$eq(long x$1) {
        this.stall_ms = x$1;
    }

    @Override
    public long reset_stall_timer() {
        return StallCheckSupport$class.reset_stall_timer(this);
    }

    @Override
    public void stall_check() {
        StallCheckSupport$class.stall_check(this);
    }

    public void assert_executing() {
        Dispatched.class.assert_executing((Dispatched)this);
    }

    @Override
    public Option<BrokerConnection> connection() {
        return DeliveryProducer$class.connection(this);
    }

    @Override
    public int send_buffer_size() {
        return DeliveryProducer$class.send_buffer_size(this);
    }

    @Override
    public void collocate(DispatchQueue value) {
        DeliveryProducer$class.collocate(this, value);
    }

    public Queue queue() {
        return this.queue;
    }

    public DeliveryConsumer consumer() {
        return this.consumer;
    }

    @Override
    public DispatchQueue dispatch_queue() {
        return this.queue().dispatch_queue();
    }

    public int id() {
        return this.id;
    }

    public LinkedNodeList<AcquiredQueueEntry> acquired() {
        return this.acquired;
    }

    public void acquired_$eq(LinkedNodeList<AcquiredQueueEntry> x$1) {
        this.acquired = x$1;
    }

    public DeliverySession session() {
        return this.session;
    }

    public void session_$eq(DeliverySession x$1) {
        this.session = x$1;
    }

    public QueueEntry pos() {
        return this.pos;
    }

    public void pos_$eq(QueueEntry x$1) {
        this.pos = x$1;
    }

    public long acquired_size() {
        return this.acquired_size;
    }

    public void acquired_size_$eq(long x$1) {
        this.acquired_size = x$1;
    }

    public int acquired_count() {
        return this.acquired().size();
    }

    public CircularBuffer<Object> enqueue_size_per_interval() {
        return this.enqueue_size_per_interval;
    }

    public void enqueue_size_per_interval_$eq(CircularBuffer<Object> x$1) {
        this.enqueue_size_per_interval = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public QueueConsumerLinkDTO create_link_dto(boolean include_metrics) {
        void var2_2;
        Some x2;
        QueueConsumerLinkDTO link = new QueueConsumerLinkDTO();
        Option<BrokerConnection> option = this.consumer().connection();
        if (option instanceof Some && (x2 = (Some)option) != null) {
            BrokerConnection connection = (BrokerConnection)x2.x();
            link.kind = "connection";
            link.id = ((Object)BoxesRunTime.boxToLong((long)connection.id())).toString();
            link.label = connection.transport().getRemoteAddress().toString();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            link.kind = "unknown";
            link.label = "unknown";
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (include_metrics) {
            Tuple2 p2;
            Some x3;
            link.position = Predef$.MODULE$.long2Long(this.pos().seq());
            link.enqueue_item_counter = this.session().enqueue_item_counter();
            link.enqueue_size_counter = this.session().enqueue_size_counter();
            link.enqueue_ts = this.session().enqueue_ts();
            link.total_ack_count = Predef$.MODULE$.long2Long(this.total_ack_count());
            link.total_nack_count = Predef$.MODULE$.long2Long(this.total_nack_count());
            link.acquired_size = Predef$.MODULE$.long2Long(this.acquired_size());
            link.acquired_count = Predef$.MODULE$.int2Integer(this.acquired_count());
            Option<Tuple2<Object, Object>> option2 = this.ack_rates();
            if (option2 instanceof Some && (x3 = (Some)option2) != null && (p2 = (Tuple2)x3.x()) != null) {
                double items_per_sec = p2._1$mcD$sp();
                double size_per_sec = p2._2$mcD$sp();
                link.ack_item_rate = Predef$.MODULE$.double2Double(items_per_sec);
                link.ack_size_rate = Predef$.MODULE$.double2Double(size_per_sec);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            link.waiting_on = this.full() ? "consumer" : (this.pos().is_tail() ? "producer" : (this.pos().is_loaded() ? "dispatch" : "load"));
        }
        return var2_2;
    }

    public boolean create_link_dto$default$1() {
        return true;
    }

    public int avg_enqueue_size_per_interval() {
        IntRef rc = new IntRef(0);
        if (this.enqueue_size_per_interval().size() > 0) {
            this.enqueue_size_per_interval().foreach((Function1)new Serializable(this, rc){
                public static final long serialVersionUID = 0L;
                private final IntRef rc$1;

                public final void apply(int x) {
                    this.apply$mcVI$sp(x);
                }

                public void apply$mcVI$sp(int v1) {
                    this.rc$1.elem += v1;
                }
                {
                    this.rc$1 = rc$1;
                }
            });
            rc.elem /= this.enqueue_size_per_interval().size();
        }
        return rc.elem;
    }

    public long enqueue_size_at_last_interval() {
        return this.enqueue_size_at_last_interval;
    }

    public void enqueue_size_at_last_interval_$eq(long x$1) {
        this.enqueue_size_at_last_interval = x$1;
    }

    public long started_at() {
        return this.started_at;
    }

    public void started_at_$eq(long x$1) {
        this.started_at = x$1;
    }

    public long total_ack_count() {
        return this.total_ack_count;
    }

    public void total_ack_count_$eq(long x$1) {
        this.total_ack_count = x$1;
    }

    public long total_ack_size() {
        return this.total_ack_size;
    }

    public void total_ack_size_$eq(long x$1) {
        this.total_ack_size = x$1;
    }

    public long total_nack_count() {
        return this.total_nack_count;
    }

    public void total_nack_count_$eq(long x$1) {
        this.total_nack_count = x$1;
    }

    public long idle_start() {
        return this.idle_start;
    }

    public void idle_start_$eq(long x$1) {
        this.idle_start = x$1;
    }

    public long idle_total() {
        return this.idle_total;
    }

    public void idle_total_$eq(long x$1) {
        this.idle_total = x$1;
    }

    public Option<Tuple2<Object, Object>> ack_rates() {
        None$ none$;
        long duration = (Broker$.MODULE$.now() - this.started_at()) * 1000000L;
        duration -= this.idle_total();
        if (this.idle_start() != 0L) {
            duration -= System.nanoTime() - this.idle_start();
        }
        if (duration != 0L && this.total_ack_count() > 0L) {
            double ack_rate = 1.0E9 * (double)this.total_ack_count() / (double)duration;
            double ack_size_rate = 1.0E9 * (double)this.total_ack_size() / (double)duration;
            none$ = new Some((Object)new Tuple2.mcDD.sp(ack_rate, ack_size_rate));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String toString() {
        return new StringBuilder().append((Object)"{ id: ").append((Object)BoxesRunTime.boxToInteger((int)this.id())).append((Object)", acquired_size: ").append((Object)BoxesRunTime.boxToLong((long)this.acquired_size())).append((Object)", pos: ").append(this.seq$1(this.pos())).append((Object)"}").toString();
    }

    public boolean browser() {
        return this.consumer().browser();
    }

    public boolean exclusive() {
        return this.consumer().exclusive();
    }

    public int consumer_buffer() {
        return this.consumer_buffer;
    }

    public void open() {
        this.consumer().retain();
        if (this.consumer().start_from_tail()) {
            this.pos_$eq(this.queue().tail_entry());
        } else {
            this.pos_$eq(this.queue().head_entry());
        }
        if (Subscription$.MODULE$.$enable_assertions()) {
            Predef$.MODULE$.assert(this.pos() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Subscription $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("pos.$bang$eq(null) with pos=>%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.pos()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        this.consumer().set_starting_seq(this.pos().seq());
        this.session_$eq(this.consumer().connect(this));
        ((Sink)((Object)this.session())).refiller_$eq(package$.MODULE$.DispatchQueueWrapper(this.dispatch_queue()).runnable((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Subscription $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.session() != null) {
                    this.$outer.stall_check();
                }
                if (this.$outer.pos() != null) {
                    this.$outer.pos().task().run();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.pos().$colon$colon$eq(this);
        this.queue().all_subscriptions_$eq((Map<DeliveryConsumer, Subscription>)this.queue().all_subscriptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.consumer()), (Object)this)));
        if (!this.consumer().browser() && this.queue()._message_group_buckets() != null) {
            ArrayList iterators = this.queue()._message_group_buckets().add((Object)new GroupBucket(this), 10);
            if (this.queue().message_group_graceful_handoff()) {
                JavaConversions$.MODULE$.asScalaBuffer((java.util.List)iterators).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Subscription $outer;

                    public final void apply(Iterator<GroupBucket> iterator) {
                        ObjectRef taking_over = new ObjectRef(null);
                        while (iterator.hasNext() && (Subscription)taking_over.elem == null) {
                            GroupBucket next = iterator.next();
                            Subscription subscription = next.sub();
                            Subscription subscription2 = this.$outer;
                            if (!(subscription == null ? subscription2 != null : !subscription.equals(subscription2))) continue;
                            taking_over.elem = next.sub();
                        }
                        if ((Subscription)taking_over.elem != null) {
                            this.$outer.suspend();
                            ((Subscription)taking_over.elem).suspend();
                            ((Subscription)taking_over.elem).on_drain((Function0<BoxedUnit>)new Serializable(this, taking_over){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$open$3 $outer;
                                private final ObjectRef taking_over$1;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    this.$outer.org$apache$activemq$apollo$broker$Subscription$$anonfun$$$outer().resume();
                                    ((Subscription)this.taking_over$1.elem).resume();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.taking_over$1 = taking_over$1;
                                }
                            });
                        }
                    }

                    public /* synthetic */ Subscription org$apache$activemq$apollo$broker$Subscription$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
        this.queue().consumer_counter_$eq(this.queue().consumer_counter() + 1L);
        this.queue().change_consumer_capacity(this.consumer_buffer());
        if (this.exclusive()) {
            this.queue().exclusive_subscriptions().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Subscription[]{this}));
        }
        if (this.queue().service_state().is_started()) {
            this.refill_prefetch();
            package$.MODULE$.DispatchQueueWrapper(this.queue().dispatch_queue()).$less$less(this.pos().task());
        }
        this.queue().check_idle();
    }

    public int suspend_count() {
        return this.suspend_count;
    }

    public void suspend_count_$eq(int x$1) {
        this.suspend_count = x$1;
    }

    public void suspend() {
        this.suspend_count_$eq(this.suspend_count() + 1);
    }

    public void resume() {
        this.suspend_count_$eq(this.suspend_count() - 1);
        if (this.suspend_count() <= 0) {
            package$.MODULE$.DispatchQueueWrapper(this.queue().dispatch_queue()).$less$less(this.pos().task());
        }
    }

    public void on_drain(Function0<BoxedUnit> func) {
        this.drain_watchers_$eq((List<Function0<BoxedUnit>>)this.drain_watchers().$colon$colon(func));
        this.check_drained();
    }

    public List<Function0<BoxedUnit>> drain_watchers() {
        return this.drain_watchers;
    }

    public void drain_watchers_$eq(List<Function0<BoxedUnit>> x$1) {
        this.drain_watchers = x$1;
    }

    public void check_drained() {
        if (this.acquired().isEmpty()) {
            List<Function0<BoxedUnit>> list = this.drain_watchers();
            Nil$ nil$ = Nil$.MODULE$;
            if (list == null ? nil$ != null : !list.equals((Object)nil$)) {
                List<Function0<BoxedUnit>> t = this.drain_watchers();
                this.drain_watchers_$eq((List<Function0<BoxedUnit>>)Nil$.MODULE$);
                t.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Function0<BoxedUnit> action) {
                        action.apply$mcV$sp();
                    }
                });
            }
        }
    }

    public void close() {
        if (this.pos() != null) {
            this.pos().$minus$eq(this);
            this.pos_$eq(null);
            this.queue().exclusive_subscriptions_$eq((ListBuffer<Subscription>)((ListBuffer)this.queue().exclusive_subscriptions().filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Subscription $outer;

                public final boolean apply(Subscription x$1) {
                    Subscription subscription = x$1;
                    Subscription subscription2 = this.$outer;
                    return !(subscription != null ? !subscription.equals(subscription2) : subscription2 != null);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            })));
            this.queue().all_subscriptions_$eq((Map<DeliveryConsumer, Subscription>)((Map)this.queue().all_subscriptions().$minus((Object)this.consumer())));
            if (!this.consumer().browser() && this.queue()._message_group_buckets() != null) {
                this.queue()._message_group_buckets().remove((Object)new GroupBucket(this));
                if (this.queue()._message_group_buckets().getNodes().isEmpty()) {
                    this.queue()._message_group_buckets_$eq(null);
                }
            }
            ((Sink)((Object)this.session())).refiller_$eq(package$.MODULE$.NOOP());
            this.session().close();
            this.session_$eq(null);
            this.consumer().release();
            this.on_drain((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Subscription $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.queue().change_consumer_capacity(-this.$outer.consumer_buffer());
                    if (this.$outer.exclusive()) {
                        this.$outer.queue().all_subscriptions().values().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$close$1 $outer;

                            public final void apply(Subscription x$2) {
                                x$2.rewind(this.$outer.org$apache$activemq$apollo$broker$Subscription$$anonfun$$$outer().queue().head_entry());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    this.$outer.queue().check_idle();
                    this.$outer.queue().trigger_swap();
                }

                public /* synthetic */ Subscription org$apache$activemq$apollo$broker$Subscription$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public void advance(QueueEntry value) {
        if (Subscription$.MODULE$.$enable_assertions()) {
            Predef$.MODULE$.assert(value != null, (Function0)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final QueueEntry value$2;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("value.$bang$eq(null) with value=>%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2}));
                }
                {
                    this.value$2 = value$2;
                }
            });
        }
        this.pos_$eq(value);
        if (this.tail_parked() && this.consumer().close_on_drain()) {
            this.close();
        }
    }

    public void rewind(QueueEntry value) {
        if (Subscription$.MODULE$.$enable_assertions()) {
            Predef$.MODULE$.assert(value != null, (Function0)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final QueueEntry value$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("value.$bang$eq(null) with value=>%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1}));
                }
                {
                    this.value$1 = value$1;
                }
            });
        }
        this.pos().$minus$eq(this);
        value.$colon$colon$eq(this);
        this.pos_$eq(value);
        package$.MODULE$.DispatchQueueWrapper(this.queue().dispatch_queue()).$less$less(value.task());
    }

    public boolean tail_parked() {
        return this.pos() == this.queue().tail_entry();
    }

    public boolean matches(Delivery entry) {
        return this.consumer().matches(entry);
    }

    @Override
    public boolean full() {
        return this.suspend_count() > 0 || ((Sink)((Object)this.session())).full();
    }

    public boolean offer(Delivery delivery) {
        try {
            boolean bl;
            if (Subscription$.MODULE$.$enable_assertions()) {
                Predef$.MODULE$.assert(delivery.seq() > 0L, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "delivery.seq.>(0)";
                    }
                });
            }
            if (this.full()) {
                bl = false;
            } else {
                boolean accepted = ((Sink)((Object)this.session())).offer(delivery);
                if (Subscription$.MODULE$.$enable_assertions()) {
                    Predef$.MODULE$.assert(accepted, (Function0)new Serializable(this, accepted){
                        public static final long serialVersionUID = 0L;
                        private final boolean accepted$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("accepted with accepted=>%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.accepted$1)}));
                        }
                        {
                            this.accepted$1 = accepted$1;
                        }
                    });
                }
                bl = true;
            }
            return bl;
        }
        finally {
            this.stall_check();
        }
    }

    public AcquiredQueueEntry acquire(QueueEntry entry) {
        return new AcquiredQueueEntry(this, entry);
    }

    public void adjust_prefetch_size() {
        this.enqueue_size_per_interval().$plus$eq((Object)BoxesRunTime.boxToInteger((int)((int)(this.session().enqueue_size_counter() - this.enqueue_size_at_last_interval()))));
        this.enqueue_size_at_last_interval_$eq(this.session().enqueue_size_counter());
    }

    public void refill_prefetch() {
        QueueEntry cursor = this.pos().is_tail() ? null : (this.pos().is_head() ? (QueueEntry)this.pos().getNext() : this.pos());
        int remaining = this.consumer_buffer();
        while (remaining > 0 && cursor != null) {
            QueueEntry next = (QueueEntry)cursor.getNext();
            if (!(cursor.prefetched() || !this.browser() && cursor.is_acquired())) {
                remaining -= cursor.size();
                cursor.prefetched_$eq(true);
                cursor.load(this.queue().consumer_swapped_in());
            }
            cursor = next;
        }
    }

    private final Object seq$1(QueueEntry entry) {
        return entry == null ? null : BoxesRunTime.boxToLong((long)entry.seq());
    }

    public Subscription(Queue queue, DeliveryConsumer consumer) {
        this.queue = queue;
        this.consumer = consumer;
        DeliveryProducer$class.$init$(this);
        Dispatched.class.$init$((Dispatched)this);
        StallCheckSupport$class.$init$(this);
        this.id = Queue$.MODULE$.subscription_counter().incrementAndGet();
        this.acquired = new LinkedNodeList();
        this.session = null;
        this.pos = null;
        this.acquired_size = 0L;
        this.enqueue_size_per_interval = new CircularBuffer(15);
        this.enqueue_size_at_last_interval = 0L;
        this.started_at = Broker$.MODULE$.now();
        this.total_ack_count = 0L;
        this.total_ack_size = 0L;
        this.total_nack_count = 0L;
        this.idle_start = System.nanoTime();
        this.idle_total = 0L;
        this.consumer_buffer = consumer.receive_buffer_size();
        this.suspend_count = 0;
        this.drain_watchers = Nil$.MODULE$;
    }

    public class AcquiredQueueEntry
    extends LinkedNode<AcquiredQueueEntry> {
        private final QueueEntry entry;
        public final /* synthetic */ Subscription $outer;

        public QueueEntry entry() {
            return this.entry;
        }

        public void ack(StoreUOW uow) {
            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().assert_executing();
            if (this.isLinked()) {
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_ack_count_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_ack_count() + 1L);
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_ack_size_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_ack_size() + (long)this.entry().size());
                this.remove(uow);
                return;
            }
            Subscription$.MODULE$.debug((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AcquiredQueueEntry $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Unexpected ack: message seq already acked: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.entry().seq())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }

        public void remove(StoreUOW uow) {
            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().assert_executing();
            QueueEntry next = (QueueEntry)this.entry().getNext();
            this.entry().dequeue(uow);
            this.unlink();
            if (this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired().isEmpty()) {
                this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().idle_start_$eq(System.nanoTime());
            }
            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired_size_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired_size() - (long)this.entry().size());
            this.entry().remove();
            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().trigger_swap();
            if (next != null) {
                next.task().run();
            }
            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().check_drained();
        }

        public void increment_nack() {
            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_nack_count_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().total_nack_count() + 1L);
        }

        public void nack() {
            block5: {
                QueueEntry.EntryState entryState;
                block8: {
                    block7: {
                        block6: {
                            this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().assert_executing();
                            if (!this.isLinked()) break block5;
                            entryState = this.entry().state();
                            if (!(entryState instanceof QueueEntry.Loaded)) break block6;
                            QueueEntry.Loaded x2 = (QueueEntry.Loaded)entryState;
                            x2.acquirer_$eq(null);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (!(entryState instanceof QueueEntry.Swapped)) break block8;
                        QueueEntry.Swapped x3 = (QueueEntry.Swapped)entryState;
                        x3.acquirer_$eq(null);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired_size_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired_size() - (long)this.entry().size());
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_item_counter_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_item_counter() + 1L);
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_size_counter_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_size_counter() + (long)this.entry().size());
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().nack_ts_$eq(this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().now());
                    if (!this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().exclusive()) {
                        QueueEntry.Loaded loaded = this.entry().as_loaded();
                        this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().queue().all_subscriptions().valuesIterator().foreach((Function1)new Serializable(this, loaded){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ AcquiredQueueEntry $outer;
                            private final QueueEntry.Loaded loaded$1;

                            public final void apply(Subscription sub) {
                                boolean matches;
                                boolean bl = matches = this.loaded$1 == null ? true : sub.matches(this.loaded$1.delivery());
                                if (!sub.browser() && this.$outer.entry().seq() < sub.pos().seq() && matches) {
                                    sub.rewind(this.$outer.entry());
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.loaded$1 = loaded$1;
                            }
                        });
                    }
                    this.unlink();
                    if (this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().acquired().isEmpty()) {
                        this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().idle_start_$eq(System.nanoTime());
                    }
                    this.org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer().check_drained();
                    return;
                }
                throw new MatchError((Object)entryState);
            }
            Subscription$.MODULE$.debug((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AcquiredQueueEntry $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Unexpected nack: message seq allready acked: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.entry().seq())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }

        public /* synthetic */ Subscription org$apache$activemq$apollo$broker$Subscription$AcquiredQueueEntry$$$outer() {
            return this.$outer;
        }

        public AcquiredQueueEntry(Subscription $outer, QueueEntry entry) {
            this.entry = entry;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            if ($outer.acquired().isEmpty()) {
                $outer.idle_total_$eq(System.nanoTime() - $outer.idle_start());
                $outer.idle_start_$eq(0L);
            }
            $outer.acquired().addLast((LinkedNode)this);
            $outer.acquired_size_$eq($outer.acquired_size() + (long)entry.size());
        }
    }
}

