/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import javax.transaction.xa.Xid;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public class XidImpl
implements Xid,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5363901495878210611L;
    private static final Buffer EMPTY_BUFFER = new Buffer(new byte[0]);
    private int formatId = -1;
    Buffer globalTransactionId = EMPTY_BUFFER;
    Buffer branchQualifier = EMPTY_BUFFER;

    public XidImpl() {
    }

    public XidImpl(int formatID, byte[] globalTxnID, byte[] branchID) {
        this.formatId = formatID;
        this.setGlobalTransactionId(globalTxnID);
        this.setBranchQualifier(branchID);
    }

    public XidImpl(int formatID, Buffer globalTransactionId, Buffer branchQualifier) {
        this.formatId = formatID;
        this.globalTransactionId = globalTransactionId;
        this.branchQualifier = branchQualifier;
    }

    public XidImpl(Xid from) {
        if (from == null || from.getFormatId() == -1) {
            this.formatId = -1;
            this.setGlobalTransactionId(null);
            this.setBranchQualifier(null);
        } else {
            this.formatId = from.getFormatId();
            this.setGlobalTransactionId(from.getGlobalTransactionId());
            this.setBranchQualifier(from.getBranchQualifier());
        }
    }

    public XidImpl(String globalTxnId, String branchId) {
        this(99, globalTxnId.getBytes(), branchId.getBytes());
    }

    public boolean equals(Object o) {
        if (o.getClass() != XidImpl.class) {
            return false;
        }
        XidImpl other = (XidImpl)o;
        if (this.formatId == -1 && other.formatId == -1) {
            return true;
        }
        return this.formatId == other.formatId && this.globalTransactionId.equals(other.globalTransactionId) && this.branchQualifier.equals(other.branchQualifier);
    }

    public int hashCode() {
        if (this.formatId == -1) {
            return -1;
        }
        return this.formatId ^ this.globalTransactionId.hashCode() ^ this.branchQualifier.hashCode();
    }

    public String toString() {
        String gtString = new String(this.getGlobalTransactionId());
        String brString = new String(this.getBranchQualifier());
        return new String("{Xid: formatID=" + this.formatId + ", " + "gtrid[" + this.globalTransactionId.length + "]=" + gtString + ", " + "brid[" + this.branchQualifier.length + "]=" + brString + "}");
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId.toByteArray();
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier.toByteArray();
    }

    private void setBranchQualifier(byte[] branchID) {
        if (branchID == null) {
            this.branchQualifier = EMPTY_BUFFER;
        } else {
            int length = branchID.length > 64 ? 64 : branchID.length;
            this.branchQualifier = new Buffer(new byte[length]);
            System.arraycopy(branchID, 0, this.branchQualifier.data, 0, length);
        }
    }

    private void setGlobalTransactionId(byte[] globalTxnID) {
        if (globalTxnID == null) {
            this.globalTransactionId = EMPTY_BUFFER;
        } else {
            int length = globalTxnID.length > 64 ? 64 : globalTxnID.length;
            this.globalTransactionId = new Buffer(new byte[length]);
            System.arraycopy(globalTxnID, 0, this.globalTransactionId.data, 0, length);
        }
    }

    public int getMemorySize() {
        return 8 + this.globalTransactionId.length + 4 + this.branchQualifier.length;
    }

    public void writebody(DataOutput out) throws IOException {
        out.writeInt(this.formatId);
        out.writeInt(this.globalTransactionId.length);
        out.write(this.globalTransactionId.data, this.globalTransactionId.offset, this.globalTransactionId.length);
        out.writeInt(this.branchQualifier.length);
        out.write(this.branchQualifier.data, this.branchQualifier.offset, this.branchQualifier.length);
    }

    public void readbody(DataInput in) throws IOException {
        this.formatId = in.readInt();
        int length = in.readInt();
        byte[] data = new byte[length];
        in.readFully(data);
        this.setGlobalTransactionId(data);
        length = in.readInt();
        data = new byte[length];
        in.readFully(data);
        this.setBranchQualifier(data);
    }

    public static Buffer toBuffer(Xid xid) {
        XidImpl x = new XidImpl(xid);
        DataByteArrayOutputStream baos = new DataByteArrayOutputStream(x.getMemorySize());
        try {
            x.writebody((DataOutput)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toBuffer();
    }
}

