/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.jaxb;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesReader
extends StreamReaderDelegate {
    Logger LOG = LoggerFactory.getLogger(PropertiesReader.class);
    Pattern pattern = Pattern.compile("\\$\\{([a-zA-Z0-9\\.]*)\\}");

    public PropertiesReader(XMLStreamReader parent) {
        super(parent);
    }

    @Override
    public String getAttributeValue(int index) {
        String value = super.getAttributeValue(index);
        String replaced = this.replaceSystemProperties(value);
        return replaced;
    }

    public String replaceSystemProperties(String str) {
        Matcher matcher;
        int start = 0;
        while ((matcher = this.pattern.matcher(str)).find(start)) {
            String property = System.getProperty(matcher.group(1));
            if (property != null) {
                str = matcher.replaceFirst(property);
                continue;
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("System property " + matcher.group(1) + " not found");
            }
            start = matcher.end();
        }
        return str;
    }
}

