/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.jaxb;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.apache.activemq.apollo.broker.Broker;
import org.apache.activemq.apollo.broker.BrokerFactoryTrait;
import org.apache.activemq.apollo.dto.BrokerDTO;
import org.apache.activemq.apollo.dto.XmlCodec;
import org.apache.activemq.apollo.util.URISupport;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q2A!\u0001\u0002\u0001\u001f\t\u0001\u0002,\u001c7Ce>\\WM\u001d$bGR|'/\u001f\u0006\u0003\u0007\u0011\tAA[1yE*\u0011QAB\u0001\u0007EJ|7.\u001a:\u000b\u0005\u001dA\u0011AB1q_2dwN\u0003\u0002\n\u0015\u0005A\u0011m\u0019;jm\u0016l\u0017O\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eQR\"\u0001\u0003\n\u0005m!!A\u0005\"s_.,'OR1di>\u0014\u0018\u0010\u0016:bSRDQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000b\t\u0002A\u0011A\u0012\u0002\u0019\r\u0014X-\u0019;f\u0005J|7.\u001a:\u0015\u0007\u0011:C\u0006\u0005\u0002\u001aK%\u0011a\u0005\u0002\u0002\u0007\u0005J|7.\u001a:\t\u000b!\n\u0003\u0019A\u0015\u0002\u000bY\fG.^3\u0011\u0005EQ\u0013BA\u0016\u0013\u0005\u0019\u0019FO]5oO\")Q&\ta\u0001]\u0005)\u0001O]8qgB\u0011qFM\u0007\u0002a)\u0011\u0011\u0007F\u0001\u0005kRLG.\u0003\u00024a\tQ\u0001K]8qKJ$\u0018.Z:")
public class XmlBrokerFactory
implements BrokerFactoryTrait {
    @Override
    public Broker createBroker(String value, Properties props) {
        try {
            URI brokerURI = new URI(value);
            URL configURL = null;
            brokerURI = URISupport.stripScheme((URI)brokerURI);
            String scheme = brokerURI.getScheme();
            configURL = scheme == null || "file".equals(scheme) ? URISupport.changeScheme((URI)URISupport.stripScheme((URI)brokerURI), (String)"file").toURL() : ("classpath".equals(scheme) ? Thread.currentThread().getContextClassLoader().getResource(brokerURI.getSchemeSpecificPart()) : URISupport.changeScheme((URI)brokerURI, (String)scheme).toURL());
            if (configURL == null) {
                throw new IOException(new StringBuilder().append((Object)"Cannot create broker from non-existent URI: ").append((Object)brokerURI).toString());
            }
            Broker broker = new Broker();
            broker.config_$eq((BrokerDTO)XmlCodec.decode(BrokerDTO.class, (URL)configURL, (Properties)props));
            return broker;
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringBuilder().append((Object)"Cannot create broker from URI: ").append((Object)value).toString(), exception);
        }
    }
}

