/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.protocol;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.apollo.broker.BrokerConnection;
import org.apache.activemq.apollo.broker.ProtocolException;
import org.apache.activemq.apollo.broker.ProtocolException$;
import org.apache.activemq.apollo.broker.protocol.AnyProtocol$;
import org.apache.activemq.apollo.broker.protocol.AnyProtocolCodec;
import org.apache.activemq.apollo.broker.protocol.Protocol;
import org.apache.activemq.apollo.broker.protocol.ProtocolDetected;
import org.apache.activemq.apollo.broker.protocol.ProtocolFactory$;
import org.apache.activemq.apollo.broker.protocol.ProtocolHandler;
import org.apache.activemq.apollo.broker.protocol.ProtocolHandler$class;
import org.apache.activemq.apollo.dto.AcceptingConnectorDTO;
import org.apache.activemq.apollo.dto.ConnectionStatusDTO;
import org.apache.activemq.apollo.dto.DetectDTO;
import org.apache.activemq.apollo.dto.ProtocolDTO;
import org.apache.activemq.apollo.util.OptionSupport$;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdispatch.package$;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u001f\t\u0011\u0012I\\=Qe>$xnY8m\u0011\u0006tG\r\\3s\u0015\t\u0019A!\u0001\u0005qe>$xnY8m\u0015\t)a!\u0001\u0004ce>\\WM\u001d\u0006\u0003\u000f!\ta!\u00199pY2|'BA\u0005\u000b\u0003!\t7\r^5wK6\f(BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!a\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033ii\u0011AA\u0005\u00037\t\u0011q\u0002\u0015:pi>\u001cw\u000e\u001c%b]\u0012dWM\u001d\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"!\u0007\u0001\t\u000b\r\u0001A\u0011A\u0011\u0016\u0003\t\u0002\"!E\u0012\n\u0005\u0011\u0012\"AB*ue&tw\rC\u0004'\u0001\u0001\u0007I\u0011A\u0014\u0002\u001b\u0011L7o\u0019:j[&t\u0017\r^3e+\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#a\u0002\"p_2,\u0017M\u001c\u0005\b_\u0001\u0001\r\u0011\"\u00011\u0003E!\u0017n]2sS6Lg.\u0019;fI~#S-\u001d\u000b\u0003cQ\u0002\"!\u000b\u001a\n\u0005MR#\u0001B+oSRDq!\u000e\u0018\u0002\u0002\u0003\u0007\u0001&A\u0002yIEBaa\u000e\u0001!B\u0013A\u0013A\u00043jg\u000e\u0014\u0018.\\5oCR,G\r\t\u0005\u0006s\u0001!\tAO\u0001\u000bg\u0016\u001c8/[8o?&$W#A\u001e\u0011\u0005%b\u0014BA\u001f+\u0005\u0011qU\u000f\u001c7\t\u0013}\u0002\u0001\u0019!a\u0001\n\u0003\u0001\u0015AB2p]\u001aLw-F\u0001B!\t\u0011U)D\u0001D\u0015\t!e!A\u0002ei>L!AR\"\u0003\u0013\u0011+G/Z2u\tR{\u0005\"\u0003%\u0001\u0001\u0004\u0005\r\u0011\"\u0001J\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0003c)Cq!N$\u0002\u0002\u0003\u0007\u0011\t\u0003\u0004M\u0001\u0001\u0006K!Q\u0001\bG>tg-[4!\u0011\u0015q\u0005\u0001\"\u0001P\u0003%\t7/\u001f8d?\u0012LW\r\u0006\u00022!\")\u0011+\u0014a\u0001E\u0005q1\r\\5f]R|V.Z:tC\u001e,\u0007\"B*\u0001\t\u0003\"\u0016\u0001F8o?R\u0014\u0018M\\:q_J$xlY8n[\u0006tG\r\u0006\u00022+\")aK\u0015a\u0001/\u000691m\\7nC:$\u0007CA\u0015Y\u0013\tI&F\u0001\u0004B]f\u0014VM\u001a\u0005\u00067\u0002!\t\u0005X\u0001\u0017_:|FO]1ogB|'\u000f^0d_:tWm\u0019;fIV\t\u0011\u0007C\u0003_\u0001\u0011\u0005A,\u0001\u000bbgN,'\u000f^0eSN\u001c'/[7j]\u0006$X\r\u001a")
public class AnyProtocolHandler
implements ProtocolHandler {
    private boolean discriminated;
    private DetectDTO config;
    private BrokerConnection connection;

    @Override
    public BrokerConnection connection() {
        return this.connection;
    }

    @Override
    public void connection_$eq(BrokerConnection x$1) {
        this.connection = x$1;
    }

    @Override
    public void defer(Function0<BoxedUnit> func) {
        ProtocolHandler$class.defer(this, func);
    }

    @Override
    public void set_connection(BrokerConnection brokerConnection) {
        ProtocolHandler$class.set_connection(this, brokerConnection);
    }

    @Override
    public ConnectionStatusDTO create_connection_status(boolean debug) {
        return ProtocolHandler$class.create_connection_status(this, debug);
    }

    @Override
    public void on_transport_failure(IOException error) {
        ProtocolHandler$class.on_transport_failure(this, error);
    }

    @Override
    public void on_transport_disconnected() {
        ProtocolHandler$class.on_transport_disconnected(this);
    }

    @Override
    public String protocol() {
        return "any";
    }

    public boolean discriminated() {
        return this.discriminated;
    }

    public void discriminated_$eq(boolean x$1) {
        this.discriminated = x$1;
    }

    public Null$ session_id() {
        return null;
    }

    public DetectDTO config() {
        return this.config;
    }

    public void config_$eq(DetectDTO x$1) {
        this.config = x$1;
    }

    @Override
    public void async_die(String client_message) {
        this.connection().stop(package$.MODULE$.NOOP());
    }

    @Override
    public void on_transport_command(Object command) {
        if (this.discriminated()) {
            throw new ProtocolException("Protocol already discriminated", ProtocolException$.MODULE$.$lessinit$greater$default$2());
        }
        Object object = command;
        if (object instanceof ProtocolDetected) {
            ProtocolDetected x2 = (ProtocolDetected)object;
            this.discriminated_$eq(true);
            Protocol protocol = (Protocol)ProtocolFactory$.MODULE$.get(x2.id()).getOrElse((Function0)new Serializable(this, x2){
                public static final long serialVersionUID = 0L;
                private final ProtocolDetected x2$1;

                public final Nothing$ apply() {
                    throw new ProtocolException(new StringBuilder().append((Object)"No protocol handler available for protocol: ").append((Object)this.x2$1.id()).toString(), ProtocolException$.MODULE$.$lessinit$greater$default$2());
                }
                {
                    this.x2$1 = x2$1;
                }
            });
            ProtocolHandler protocol_handler = protocol.createProtocolHandler(this.connection().connector());
            AnyProtocolCodec any_codec = this.connection().protocol_codec(AnyProtocolCodec.class);
            ProtocolCodec next = protocol.createProtocolCodec(this.connection().connector());
            AnyProtocol$.MODULE$.change_protocol_codec(this.connection().transport(), next);
            Buffer buff = new Buffer(any_codec.buffer().array(), 0, any_codec.buffer().position());
            next.unread(buff.toByteArray());
            this.connection().protocol_handler_$eq(protocol_handler);
            this.connection().transport().suspendRead();
            protocol_handler.set_connection(this.connection());
            this.connection().transport().getTransportListener().onTransportConnected();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new ProtocolException("Expected a ProtocolDetected object", ProtocolException$.MODULE$.$lessinit$greater$default$2());
    }

    @Override
    public void on_transport_connected() {
        this.connection().transport().resumeRead();
        AnyProtocolCodec codec = this.connection().protocol_codec(AnyProtocolCodec.class);
        AcceptingConnectorDTO connector_config = (AcceptingConnectorDTO)this.connection().connector().config();
        this.config_$eq((DetectDTO)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(connector_config.protocols).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<DetectDTO> apply(ProtocolDTO x$2) {
                Iterable iterable;
                ProtocolDTO protocolDTO = x$2;
                if (protocolDTO instanceof DetectDTO) {
                    DetectDTO x2 = (DetectDTO)protocolDTO;
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)x2));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }
        }, Buffer$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DetectDTO apply() {
                return new DetectDTO();
            }
        }));
        if (this.config().protocols != null) {
            Set protocols = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])this.config().protocols.split("\\s+")).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$3) {
                    return x$3.length() != 0;
                }
            })));
            codec.protocols_$eq((Protocol[])Predef$.MODULE$.refArrayOps((Object[])codec.protocols()).filter((Function1)new Serializable(this, protocols){
                public static final long serialVersionUID = 0L;
                private final Set protocols$1;

                public final boolean apply(Protocol x) {
                    return this.protocols$1.contains((Object)x.id());
                }
                {
                    this.protocols$1 = protocols$1;
                }
            }));
        }
        long timeout = BoxesRunTime.unboxToLong((Object)OptionSupport$.MODULE$.LongToOption(this.config().timeout).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 5000L;
            }
        }));
        package$.MODULE$.DispatchQueueWrapper(this.connection().dispatch_queue()).after(timeout, TimeUnit.MILLISECONDS, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AnyProtocolHandler $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert_discriminated();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void assert_discriminated() {
        if (this.connection().service_state().is_started() && !this.discriminated()) {
            this.connection().stop(package$.MODULE$.NOOP());
        }
    }

    public AnyProtocolHandler() {
        ProtocolHandler$class.$init$(this);
        this.discriminated = false;
    }
}

