/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.protocol;

import org.apache.activemq.apollo.broker.Connector;
import org.apache.activemq.apollo.broker.protocol.AnyProtocolCodec;
import org.apache.activemq.apollo.broker.protocol.AnyProtocolHandler;
import org.apache.activemq.apollo.broker.protocol.Protocol;
import org.apache.activemq.apollo.dto.SslDTO;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.SslProtocolCodec;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u001f\tY1k\u001d7Qe>$xnY8m\u0015\t\u0019A!\u0001\u0005qe>$xnY8m\u0015\t)a!\u0001\u0004ce>\\WM\u001d\u0006\u0003\u000f!\ta!\u00199pY2|'BA\u0005\u000b\u0003!\t7\r^5wK6\f(BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!a\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033ii\u0011AA\u0005\u00037\t\u0011\u0001\u0002\u0015:pi>\u001cw\u000e\u001c\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"!\u0007\u0001\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\u0005%$G#A\u0012\u0011\u0005\u0011RcBA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2\u0013A\u0002)sK\u0012,g-\u0003\u0002,Y\t11\u000b\u001e:j]\u001eT!!\u000b\u0014\t\u000b9\u0002A\u0011I\u0018\u0002\u001d%\u001c\u0018\nZ3oi&4\u0017.\u00192mKV\t\u0001\u0007\u0005\u0002&c%\u0011!G\n\u0002\b\u0005>|G.Z1o\u0011\u0015!\u0004\u0001\"\u00116\u0003Yi\u0017\r_%eK:$\u0018NZ5dC&|g\u000eT3oORDW#\u0001\u001c\u0011\u0005\u0015:\u0014B\u0001\u001d'\u0005\rIe\u000e\u001e\u0005\u0006u\u0001!\teO\u0001\u0016[\u0006$8\r[3t\u0013\u0012,g\u000e^5gS\u000e\fG/[8o)\t\u0001D\bC\u0003>s\u0001\u0007a(\u0001\u0004ck\u001a4WM\u001d\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bq\u0001[1xi\n,hM\u0003\u0002D\u0019\u0005Qa-^:fg>,(oY3\n\u0005\u0015\u0003%A\u0002\"vM\u001a,'\u000fC\u0003H\u0001\u0011\u0005\u0001*A\nde\u0016\fG/\u001a)s_R|7m\u001c7D_\u0012,7\r\u0006\u0002J#B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\niJ\fgn\u001d9peRT!A\u0014\"\u0002\u0019!\fw\u000f\u001e3jgB\fGo\u00195\n\u0005A[%\u0001E*tYB\u0013x\u000e^8d_2\u001cu\u000eZ3d\u0011\u0015\u0011f\t1\u0001T\u0003%\u0019wN\u001c8fGR|'\u000f\u0005\u0002U+6\tA!\u0003\u0002W\t\tI1i\u001c8oK\u000e$xN\u001d\u0005\u00061\u0002!\t!W\u0001\u0016GJ,\u0017\r^3Qe>$xnY8m\u0011\u0006tG\r\\3s)\tQV\f\u0005\u0002\u001a7&\u0011AL\u0001\u0002\u0013\u0003:L\bK]8u_\u000e|G\u000eS1oI2,'\u000fC\u0003S/\u0002\u00071\u000b")
public class SslProtocol
implements Protocol {
    @Override
    public String id() {
        return "ssl";
    }

    @Override
    public boolean isIdentifiable() {
        return true;
    }

    @Override
    public int maxIdentificaionLength() {
        return 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matchesIdentification(Buffer buffer) {
        if (buffer.length < 6) return false;
        if (buffer.get(0) == 22) {
            if (buffer.get(5) != 1) return false;
            if (buffer.get(1) == 2) return true;
            if (buffer.get(1) != 3) return false;
            byte by = buffer.get(2);
            switch (by) {
                default: {
                    return false;
                }
                case 3: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 0: {
                    return true;
                }
            }
        }
        if ((buffer.get(0) & 0xC0) != 128) return false;
        if (buffer.get(2) != 1) return false;
        if (buffer.get(3) == 2) return true;
        if (buffer.get(3) != 3) return false;
        byte by = buffer.get(4);
        switch (by) {
            default: {
                return false;
            }
            case 3: {
                return true;
            }
            case 2: {
                return true;
            }
            case 1: {
                return true;
            }
            case 0: {
                return true;
            }
        }
    }

    public SslProtocolCodec createProtocolCodec(Connector connector) {
        SslDTO config = (SslDTO)connector.protocol_codec_config(SslDTO.class).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SslDTO apply() {
                return new SslDTO();
            }
        });
        SslProtocolCodec.ClientAuth client_auth = config.client_auth == null ? SslProtocolCodec.ClientAuth.WANT : SslProtocolCodec.ClientAuth.valueOf((String)config.client_auth.toUpperCase());
        String version = config.version == null ? "SSL" : config.version;
        SslProtocolCodec rc = new SslProtocolCodec();
        rc.setSSLContext(connector.broker().ssl_context(version));
        rc.server(client_auth);
        rc.setNext((ProtocolCodec)new AnyProtocolCodec(connector));
        return rc;
    }

    @Override
    public AnyProtocolHandler createProtocolHandler(Connector connector) {
        return new AnyProtocolHandler();
    }
}

