/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.store;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.apollo.broker.store.DirectBuffer;
import org.apache.activemq.apollo.broker.store.DirectBufferAllocator;
import org.apache.activemq.apollo.broker.store.FileDirectBufferAllocator;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001f\t\u00193i\u001c8dkJ\u0014XM\u001c;GS2,G)\u001b:fGR\u0014UO\u001a4fe\u0006cGn\\2bi>\u0014(BA\u0002\u0005\u0003\u0015\u0019Ho\u001c:f\u0015\t)a!\u0001\u0004ce>\\WM\u001d\u0006\u0003\u000f!\ta!\u00199pY2|'BA\u0005\u000b\u0003!\t7\r^5wK6\f(BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!a\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033ii\u0011AA\u0005\u00037\t\u0011Q\u0003R5sK\u000e$()\u001e4gKJ\fE\u000e\\8dCR|'\u000f\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003%!\u0017N]3di>\u0014\u00180F\u0001 !\t\u00013%D\u0001\"\u0015\t\u0011C#\u0001\u0002j_&\u0011A%\t\u0002\u0005\r&dW\r\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003 \u0003)!\u0017N]3di>\u0014\u0018\u0010\t\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)Z\u0003CA\r\u0001\u0011\u0015ir\u00051\u0001 \u0011\u001di\u0003A1A\u0005\u00069\nqbY8oi\u0016DHoX2pk:$XM]\u000b\u0002_A\u0011\u0001gN\u0007\u0002c)\u0011!gM\u0001\u0007CR|W.[2\u000b\u0005Q*\u0014AC2p]\u000e,(O]3oi*\u0011a\u0007F\u0001\u0005kRLG.\u0003\u00029c\ti\u0011\t^8nS\u000eLe\u000e^3hKJDaA\u000f\u0001!\u0002\u001by\u0013\u0001E2p]R,\u0007\u0010^0d_VtG/\u001a:!\u0011\u001da\u0004A1A\u0005\u0006u\n\u0001bY8oi\u0016DHo]\u000b\u0002}A!q\b\u0011\"F\u001b\u0005\u0019\u0014BA!4\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003#\rK!\u0001\u0012\n\u0003\rQC'/Z1e!\tIb)\u0003\u0002H\u0005\tIb)\u001b7f\t&\u0014Xm\u0019;Ck\u001a4WM]!mY>\u001c\u0017\r^8s\u0011\u0019I\u0005\u0001)A\u0007}\u0005I1m\u001c8uKb$8\u000f\t\u0005\b\u0017\u0002\u0001\r\u0011\"\u0001M\u0003\u0019\u0019Gn\\:fIV\tQ\n\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJA\u0004C_>dW-\u00198\t\u000fQ\u0003\u0001\u0019!C\u0001+\u0006Q1\r\\8tK\u0012|F%Z9\u0015\u0005YK\u0006C\u0001(X\u0013\tAvJ\u0001\u0003V]&$\bb\u0002.T\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\n\u0004B\u0002/\u0001A\u0003&Q*A\u0004dY>\u001cX\r\u001a\u0011)\u0005ms\u0006C\u0001(`\u0013\t\u0001wJ\u0001\u0005w_2\fG/\u001b7f\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u0015\u0019Gn\\:f)\u00051\u0006\"B3\u0001\t\u00031\u0017!B1mY>\u001cGCA4k!\tI\u0002.\u0003\u0002j\u0005\taA)\u001b:fGR\u0014UO\u001a4fe\")1\u000e\u001aa\u0001Y\u0006!1/\u001b>f!\tqU.\u0003\u0002o\u001f\n\u0019\u0011J\u001c;")
public class ConcurrentFileDirectBufferAllocator
implements DirectBufferAllocator {
    private final File directory;
    private final AtomicInteger context_counter;
    private final ConcurrentHashMap<Thread, FileDirectBufferAllocator> contexts;
    private volatile boolean closed;

    public File directory() {
        return this.directory;
    }

    public final AtomicInteger context_counter() {
        return this.context_counter;
    }

    public final ConcurrentHashMap<Thread, FileDirectBufferAllocator> contexts() {
        return this.contexts;
    }

    public boolean closed() {
        return this.closed;
    }

    public void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    @Override
    public void close() {
        this.closed_$eq(true);
        JavaConversions$.MODULE$.collectionAsScalaIterable(this.contexts().values()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileDirectBufferAllocator x$8) {
                x$8.close();
            }
        });
        this.contexts().clear();
    }

    @Override
    public DirectBuffer alloc(int size) {
        Object object;
        Thread thread = Thread.currentThread();
        FileDirectBufferAllocator ctx = this.contexts().get(thread);
        if (ctx == null) {
            if (this.closed()) {
                throw new IllegalStateException("Stopped");
            }
            int id = this.context_counter().incrementAndGet();
            ctx = new FileDirectBufferAllocator(new File(this.directory(), new StringBuilder().append((Object)"zerocp-").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)".data").toString()));
            object = this.contexts().put(thread, ctx);
        } else {
            object = BoxedUnit.UNIT;
        }
        return ctx.alloc(size);
    }

    public ConcurrentFileDirectBufferAllocator(File directory) {
        this.directory = directory;
        this.context_counter = new AtomicInteger();
        this.contexts = new ConcurrentHashMap();
        this.closed = false;
        directory.mkdirs();
        this.closed_$eq(false);
    }
}

