/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.transport;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.activemq.apollo.broker.transport.TcpTransportFactory;
import org.apache.activemq.apollo.util.IntrospectionSupport;
import org.fusesource.hawtdispatch.transport.SslTransport;
import org.fusesource.hawtdispatch.transport.SslTransportServer;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.hawtdispatch.transport.TcpTransportServer;

public class SslTransportFactory
extends TcpTransportFactory {
    @Override
    protected TcpTransportServer createTcpTransportServer(URI uri, final Map<String, String> options) throws Exception {
        String protocol = this.protocol(uri.getScheme());
        if (protocol != null) {
            return new SslTransportServer(uri){

                protected TcpTransport createTransport() {
                    TcpTransport transport = super.createTransport();
                    IntrospectionSupport.setProperties((Object)transport, new HashMap(options));
                    return transport;
                }
            }.protocol(protocol);
        }
        return null;
    }

    @Override
    protected TcpTransport createTransport(URI uri) throws Exception {
        String protocol = this.protocol(uri.getScheme());
        if (protocol != null) {
            SslTransport rc = new SslTransport();
            rc.setSSLContext(SSLContext.getInstance(protocol));
            return rc;
        }
        return null;
    }

    protected String protocol(String scheme) {
        if (scheme.equals("tls")) {
            return "TLS";
        }
        if (scheme.startsWith("tlsv")) {
            return "TLSv" + scheme.substring(4);
        }
        if (scheme.equals("ssl")) {
            return "SSL";
        }
        if (scheme.startsWith("sslv")) {
            return "SSLv" + scheme.substring(4);
        }
        return null;
    }
}

