/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.transport;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.apollo.broker.transport.TransportFactory;
import org.apache.activemq.apollo.broker.transport.TransportFactorySupport;
import org.apache.activemq.apollo.util.IntrospectionSupport;
import org.apache.activemq.apollo.util.URISupport;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.hawtdispatch.transport.TcpTransportServer;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransportFactory
implements TransportFactory.Provider {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransportFactory.class);

    @Override
    public TransportServer bind(String location) throws Exception {
        URI uri = new URI(location);
        HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParamters((URI)uri));
        TcpTransportServer server = this.createTcpTransportServer(uri, options);
        if (server == null) {
            return null;
        }
        HashMap<String, String> copy = new HashMap<String, String>(options);
        IntrospectionSupport.setProperties((Object)server, new HashMap<String, String>(options));
        return server;
    }

    @Override
    public Transport connect(String location) throws Exception {
        URI uri = new URI(location);
        TcpTransport transport = this.createTransport(uri);
        if (transport == null) {
            return null;
        }
        HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParamters((URI)uri));
        URI localLocation = this.getLocalLocation(uri);
        TransportFactorySupport.configure((Transport)transport, options);
        TransportFactorySupport.verify((Transport)transport, options);
        transport.connecting(uri, localLocation);
        return transport;
    }

    protected TcpTransportServer createTcpTransportServer(URI location, final Map<String, String> options) throws IOException, URISyntaxException, Exception {
        if (!location.getScheme().equals("tcp")) {
            return null;
        }
        return new TcpTransportServer(location){

            protected TcpTransport createTransport() {
                TcpTransport transport = super.createTransport();
                IntrospectionSupport.setProperties((Object)transport, new HashMap(options));
                return transport;
            }
        };
    }

    protected TcpTransport createTransport(URI uri) throws NoSuchAlgorithmException, Exception {
        if (!uri.getScheme().equals("tcp")) {
            return null;
        }
        TcpTransport transport = new TcpTransport();
        return transport;
    }

    protected URI getLocalLocation(URI location) {
        URI localLocation = null;
        String path = location.getPath();
        if (path != null && path.length() > 0) {
            int localPortIndex = path.indexOf(58);
            try {
                Integer.parseInt(path.substring(localPortIndex + 1, path.length()));
                String localString = location.getScheme() + ":/" + path;
                localLocation = new URI(localString);
            }
            catch (Exception e) {
                LOG.warn("path isn't a valid local location for TcpTransport to use", (Throwable)e);
            }
        }
        return localLocation;
    }

    protected String getOption(Map options, String key, String def) {
        String rc = (String)options.remove(key);
        if (rc == null) {
            rc = def;
        }
        return rc;
    }
}

