/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.activemq.apollo.util.DtoModule$;

public class ApolloTypeIdResolver
implements TypeIdResolver {
    protected final HashMap<Class<?>, String> typeToId = new HashMap();
    protected final HashMap<String, JavaType> idToType = new HashMap();
    private JavaType baseType;

    public void init(JavaType baseType) {
        this.baseType = baseType;
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(baseType.getRawClass());
        classes.addAll(Arrays.asList(DtoModule$.MODULE$.extension_classes()));
        for (Class c : classes) {
            if (!baseType.getRawClass().isAssignableFrom(c)) continue;
            JsonTypeName jsonAnnoation = c.getAnnotation(JsonTypeName.class);
            if (jsonAnnoation != null && jsonAnnoation.value() != null) {
                this.typeToId.put(c, jsonAnnoation.value());
                this.idToType.put(jsonAnnoation.value(), TypeFactory.defaultInstance().constructSpecializedType(baseType, c));
                this.idToType.put(c.getName(), TypeFactory.defaultInstance().constructSpecializedType(baseType, c));
                continue;
            }
            XmlRootElement xmlAnnoation = c.getAnnotation(XmlRootElement.class);
            if (xmlAnnoation == null || xmlAnnoation.name() == null) continue;
            this.typeToId.put(c, xmlAnnoation.name());
            this.idToType.put(xmlAnnoation.name(), TypeFactory.defaultInstance().constructSpecializedType(baseType, c));
            this.idToType.put(c.getName(), TypeFactory.defaultInstance().constructSpecializedType(baseType, c));
        }
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromValue(Object value) {
        return this.idFromValueAndType(value, value.getClass());
    }

    public String idFromValueAndType(Object value, Class<?> aClass) {
        String rc = this.typeToId.get(aClass);
        if (rc == null) {
            throw new IllegalArgumentException("Invalid sub type: " + aClass + ", of base type: " + this.baseType.getRawClass());
        }
        return rc;
    }

    public String idFromBaseType() {
        return this.idFromValueAndType(null, this.baseType.getRawClass());
    }

    public JavaType typeFromId(String id) {
        JavaType rc = this.idToType.get(id);
        if (rc == null) {
            throw new IllegalArgumentException("Invalid type id '" + id);
        }
        return rc;
    }
}

