/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayOutputStream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonCodec {
    public static final ObjectMapper mapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T decode(Buffer buffer, Class<T> type) throws IOException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JsonCodec.class.getClassLoader());
        try {
            Object object = mapper.readValue((InputStream)buffer.in(), type);
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static Buffer encode(Object value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)baos, value);
        return baos.toBuffer();
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

