/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.activemq.artemis.protocol.amqp.broker.KMPNeedle;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeConstructor;

final class AMQPMessageSymbolSearch {
    private static final IdentityHashMap<Class<?>, Boolean> MSG_ANNOTATIONS_STOPSET;
    private static final IdentityHashMap<Class<?>, Boolean> APPLICATION_PROPERTIES_STOPSET;

    AMQPMessageSymbolSearch() {
    }

    public static KMPNeedle kmpNeedleOf(Symbol symbol) {
        return KMPNeedle.of(symbol.toString().getBytes(StandardCharsets.US_ASCII));
    }

    public static KMPNeedle kmpNeedleOf(String symbol) {
        return KMPNeedle.of(symbol.getBytes(StandardCharsets.US_ASCII));
    }

    public static boolean anyMessageAnnotations(ReadableBuffer data, KMPNeedle[] needles) {
        return AMQPMessageSymbolSearch.lookupOnSection(MSG_ANNOTATIONS_STOPSET, MessageAnnotations.class, data, needles, 0);
    }

    public static boolean anyApplicationProperties(ReadableBuffer data, KMPNeedle[] needles, int startAt) {
        return AMQPMessageSymbolSearch.lookupOnSection(APPLICATION_PROPERTIES_STOPSET, ApplicationProperties.class, data, needles, startAt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean lookupOnSection(IdentityHashMap<Class<?>, Boolean> stopSet, Class section, ReadableBuffer data, KMPNeedle[] needles, int startAt) {
        DecoderImpl decoder = TLSEncode.getDecoder();
        int position = data.position();
        decoder.setBuffer(data.position(startAt));
        try {
            while (data.hasRemaining()) {
                TypeConstructor constructor = decoder.readConstructor();
                Class typeClass = constructor.getTypeClass();
                if (MSG_ANNOTATIONS_STOPSET.containsKey(typeClass)) {
                    if (section.equals(typeClass)) {
                        int start = data.position();
                        constructor.skipValue();
                        int end = data.position();
                        int count = needles.length;
                        for (int i = 0; i < count; ++i) {
                            int foundIndex = needles[i].searchInto(data, start, end);
                            if (foundIndex == -1) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
                constructor.skipValue();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            decoder.setBuffer(null);
            data.position(position);
        }
    }

    static {
        List<Class> classList = Arrays.asList(MessageAnnotations.class, Properties.class, ApplicationProperties.class, Data.class, AmqpSequence.class, AmqpValue.class, Footer.class);
        MSG_ANNOTATIONS_STOPSET = new IdentityHashMap(classList.size());
        classList.forEach(clazz -> MSG_ANNOTATIONS_STOPSET.put((Class<?>)clazz, Boolean.TRUE));
        classList = Arrays.asList(ApplicationProperties.class, Data.class, AmqpSequence.class, AmqpValue.class, Footer.class);
        APPLICATION_PROPERTIES_STOPSET = new IdentityHashMap(classList.size());
        classList.forEach(clazz -> APPLICATION_PROPERTIES_STOPSET.put((Class<?>)clazz, Boolean.TRUE));
    }
}

