/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;

public class ProcessBuilder {
    static ConcurrentHashSet<Process> processes = new ConcurrentHashSet();

    public static void cleanupProcess() {
        for (Process p : processes) {
            processes.remove((Object)p);
        }
    }

    public static Process build(String logname, File location, boolean hook, String ... args) throws Exception {
        boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().trim().startsWith("win");
        String[] newArgs = IS_WINDOWS ? ProcessBuilder.rebuildArgs(args, "cmd", "/c", "artemis.cmd") : ProcessBuilder.rebuildArgs(args, "./artemis");
        java.lang.ProcessBuilder builder = new java.lang.ProcessBuilder(newArgs);
        builder.directory(new File(location, "bin"));
        Process process = builder.start();
        ProcessLogger outputLogger = new ProcessLogger(true, process.getInputStream(), logname, false);
        outputLogger.start();
        ProcessLogger errorLogger = new ProcessLogger(true, process.getErrorStream(), logname, true);
        errorLogger.start();
        processes.add((Object)process);
        ProcessBuilder.cleanupProcess();
        return process;
    }

    public static String[] rebuildArgs(String[] args, String ... prefixArgs) {
        String[] resultArgs = new String[args.length + prefixArgs.length];
        int i = 0;
        for (String arg : prefixArgs) {
            resultArgs[i++] = arg;
        }
        for (String arg : args) {
            resultArgs[i++] = arg;
        }
        return resultArgs;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (Process p : processes) {
                    p.destroy();
                }
            }
        });
    }

    static class ProcessLogger
    extends Thread {
        private final InputStream is;
        private final String logName;
        private final boolean print;
        private final boolean sendToErr;
        boolean failed = false;

        ProcessLogger(boolean print, InputStream is, String logName, boolean sendToErr) throws ClassNotFoundException {
            this.is = is;
            this.print = print;
            this.logName = logName;
            this.sendToErr = sendToErr;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if (!this.print) continue;
                    if (this.sendToErr) {
                        System.err.println(this.logName + "-err:" + line);
                        continue;
                    }
                    System.out.println(this.logName + "-out:" + line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

