/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.apache.johnzon.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.json.JsonNumber;
import javax.json.JsonValue;

final class JsonDoubleImpl
implements JsonNumber {
    private final double value;

    JsonDoubleImpl(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("double value must not be NaN or Infinite");
        }
        this.value = value;
    }

    @Override
    public boolean isIntegral() {
        return false;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public int intValueExact() {
        return this.intValue();
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public long longValueExact() {
        return (long)this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return new BigDecimal(this.toString()).toBigInteger();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return new BigDecimal(this.toString()).toBigIntegerExact();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.toString());
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return JsonNumber.class.isInstance(obj) && ((JsonNumber)JsonNumber.class.cast(obj)).doubleValue() == this.value;
    }
}

