/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.View;
import org.apache.activemq.artemis.shaded.org.jgroups.ViewId;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class MergeView
extends View {
    protected View[] subgroups;

    public MergeView() {
    }

    public MergeView(ViewId view_id, List<Address> members, List<View> subgroups) {
        super(view_id, members);
        this.subgroups = MergeView.listToArray(subgroups);
    }

    public MergeView(ViewId view_id, Address[] members, List<View> subgroups) {
        super(view_id, members);
        this.subgroups = MergeView.listToArray(subgroups);
    }

    public MergeView(Address creator, long id, List<Address> members, List<View> subgroups) {
        super(creator, id, members);
        this.subgroups = MergeView.listToArray(subgroups);
    }

    public List<View> getSubgroups() {
        return Collections.unmodifiableList(Arrays.asList(this.subgroups));
    }

    @Override
    public MergeView copy() {
        return this;
    }

    @Override
    public boolean deepEquals(View other) {
        if (!super.deepEquals(other)) {
            return false;
        }
        if (!(other instanceof MergeView)) {
            return true;
        }
        MergeView other_view = (MergeView)other;
        if (this.subgroups == null && other_view.subgroups == null) {
            return true;
        }
        if (this.subgroups.length != other_view.subgroups.length) {
            return false;
        }
        for (int i = 0; i < this.subgroups.length; ++i) {
            View my_view = this.subgroups[i];
            View oth_view = other_view.subgroups[i];
            if (my_view.deepEquals(oth_view)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MergeView::").append(super.toString());
        if (this.subgroups != null && this.subgroups.length > 0) {
            sb.append(", ").append(this.subgroups.length).append(" subgroups: ");
            sb.append(Util.printListWithDelimiter(this.subgroups, ", ", Util.MAX_LIST_PRINT_SIZE));
        }
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        int len = this.subgroups != null ? this.subgroups.length : 0;
        out.writeShort(len);
        if (len == 0) {
            return;
        }
        for (View v : this.subgroups) {
            int index = this.get(v.getCreator());
            out.writeShort(index);
            if (index < 0) {
                Util.writeAddress(v.getCreator(), out);
            }
            out.writeLong(v.getViewId().getId());
            int num_mbrs = v.size();
            out.writeShort(num_mbrs);
            for (Address mbr : v) {
                index = this.get(mbr);
                out.writeShort(index);
                if (index >= 0) continue;
                Util.writeAddress(mbr, out);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        int len = in.readShort();
        if (len > 0) {
            this.subgroups = new View[len];
            for (int i = 0; i < len; ++i) {
                short index = in.readShort();
                Address creator = index >= 0 ? this.get(index) : Util.readAddress(in);
                long id = in.readLong();
                Address[] mbrs = new Address[in.readShort()];
                for (int j = 0; j < mbrs.length; ++j) {
                    index = in.readShort();
                    mbrs[j] = index >= 0 ? this.get(index) : Util.readAddress(in);
                }
                try {
                    View view;
                    this.subgroups[i] = view = View.create(creator, id, mbrs);
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public int serializedSize() {
        int retval = super.serializedSize();
        retval += 2;
        if (this.subgroups == null) {
            return retval;
        }
        for (View v : this.subgroups) {
            retval += 12;
            Address creator = v.getCreator();
            if (this.get(creator) < 0) {
                retval += Util.size(creator);
            }
            retval += v.size() * 2;
            for (Address sub_mbr : v) {
                int index = this.get(sub_mbr);
                if (index >= 0) continue;
                retval += Util.size(sub_mbr);
            }
        }
        return retval;
    }

    protected static View[] listToArray(List<View> list) {
        if (list == null) {
            return null;
        }
        View[] retval = new View[list.size()];
        int index = 0;
        for (View view : list) {
            retval[index++] = view;
        }
        return retval;
    }

    protected int get(Address member) {
        if (member == null) {
            return -1;
        }
        for (int i = 0; i < this.members.length; ++i) {
            if (!member.equals(this.members[i])) continue;
            return i;
        }
        return -1;
    }
}

