/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextFactory;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public class DefaultSSLContextFactory
implements SSLContextFactory {
    @Override
    public SSLContext getSSLContext(Map<String, Object> configuration, String keystoreProvider, String keystorePath, String keystorePassword, String truststoreProvider, String truststorePath, String truststorePassword, String crlPath, String trustManagerFactoryPlugin, boolean trustAll) throws Exception {
        return this.createSSLContext(configuration, keystoreProvider, keystorePath, keystorePassword, truststoreProvider, truststorePath, truststorePassword, crlPath, trustManagerFactoryPlugin, trustAll);
    }

    protected SSLContext createSSLContext(Map<String, Object> configuration, String keystoreProvider, String keystorePath, String keystorePassword, String truststoreProvider, String truststorePath, String truststorePassword, String crlPath, String trustManagerFactoryPlugin, boolean trustAll) throws Exception {
        boolean useDefaultSslContext;
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            configuration.forEach((k, v) -> builder.append("\r\n").append((String)k).append("=").append(k.toLowerCase().contains("password") ? "****" : v));
            log.debugf("Creating SSL context with configuration %s", (Object)builder.toString());
        }
        if (useDefaultSslContext = ConfigurationHelper.getBooleanProperty("useDefaultSslContext", false, configuration)) {
            return SSLContext.getDefault();
        }
        return new SSLSupport().setKeystoreProvider(keystoreProvider).setKeystorePath(keystorePath).setKeystorePassword(keystorePassword).setTruststoreProvider(truststoreProvider).setTruststorePath(truststorePath).setTruststorePassword(truststorePassword).setTrustAll(trustAll).setCrlPath(crlPath).setTrustManagerFactoryPlugin(trustManagerFactoryPlugin).createContext();
    }

    @Override
    public int getPriority() {
        return 5;
    }
}

