/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.fork;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ProtocolConfiguration;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.XmlConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.XmlNode;

public final class ForkConfig {
    protected static final String FORK_STACKS = "fork-stacks";
    protected static final String FORK_STACK = "fork-stack";
    protected static final String ID = "id";

    private ForkConfig() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static Map<String, List<ProtocolConfiguration>> parse(InputStream input) throws Exception {
        XmlNode root = XmlConfigurator.parseXmlDocument(input);
        return ForkConfig.parse(root);
    }

    public static Map<String, List<ProtocolConfiguration>> parse(XmlNode root) throws Exception {
        ForkConfig.match(FORK_STACKS, root.getName());
        List<XmlNode> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        HashMap<String, List<ProtocolConfiguration>> map = new HashMap<String, List<ProtocolConfiguration>>();
        for (XmlNode node : children) {
            ForkConfig.match(FORK_STACK, node.getName());
            ForkConfig.parseForkStack(map, node);
        }
        return map;
    }

    protected static void parseForkStack(Map<String, List<ProtocolConfiguration>> map, XmlNode root) throws Exception {
        List<XmlNode> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        Map<String, String> attributes = root.getAttributes();
        String fork_stack_id = attributes.get(ID);
        if (map.containsKey(fork_stack_id)) {
            throw new IllegalStateException("duplicate fork-stack ID: \"" + fork_stack_id + "\"");
        }
        for (XmlNode node : children) {
            List<ProtocolConfiguration> protocols = XmlConfigurator.parseProtocols(node);
            map.put(fork_stack_id, protocols);
        }
    }

    protected static void match(String expected_name, String name) throws Exception {
        if (!expected_name.equals(name)) {
            throw new Exception("\"" + name + "\" didn't match \"" + expected_name + "\"");
        }
    }
}

