/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.Receiver;
import org.apache.activemq.artemis.shaded.org.jgroups.View;

public class MyReceiver<T>
implements Receiver,
Closeable {
    protected final List<T> list = new CopyOnWriteArrayList<T>();
    protected String name;
    protected boolean verbose;
    protected boolean raw_msgs;
    protected final Map<String, String> state = new HashMap<String, String>();

    @Override
    public void receive(Message msg) {
        Message obj = this.raw_msgs ? msg : msg.getObject();
        this.list.add(obj);
        if (this.verbose) {
            System.out.println((String)(this.name() != null ? this.name() + ":" : "") + " received message from " + msg.getSrc() + ": " + obj);
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        if (this.verbose) {
            System.out.printf("-- %s: view is %s\n", this.name, new_view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getState(OutputStream out) throws Exception {
        DataOutputStream o = new DataOutputStream(out);
        Map<String, String> map = this.state;
        synchronized (map) {
            o.writeInt(this.state.size());
            if (!this.state.isEmpty()) {
                for (Map.Entry<String, String> e : this.state.entrySet()) {
                    o.writeUTF(e.getKey());
                    o.writeUTF(e.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(InputStream input) throws Exception {
        DataInputStream in = new DataInputStream(input);
        HashMap<String, String> m = new HashMap<String, String>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            m.put(in.readUTF(), in.readUTF());
        }
        Map<String, String> map = this.state;
        synchronized (map) {
            this.state.clear();
            this.state.putAll(m);
        }
    }

    public MyReceiver<T> rawMsgs(boolean flag) {
        this.raw_msgs = flag;
        return this;
    }

    public List<T> list() {
        return this.list;
    }

    public List<String> list(Function<T, String> f) {
        return this.list.stream().map(f).collect(Collectors.toList());
    }

    public Map<String, String> state() {
        return this.state;
    }

    public MyReceiver<T> verbose(boolean flag) {
        this.verbose = flag;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MyReceiver<T> name(String name) {
        this.name = name;
        return this;
    }

    public MyReceiver<T> reset() {
        this.list.clear();
        return this;
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public void close() throws IOException {
        this.reset();
    }

    public String toString() {
        return String.format("%d elements", this.list.size());
    }
}

