/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.FailureDetection;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class FD_ALL2
extends FailureDetection {
    protected final Map<Address, AtomicBoolean> timestamps = Util.createConcurrentMap();

    @Override
    protected Map<Address, ?> getTimestamps() {
        return this.timestamps;
    }

    @Override
    protected long getTimeoutCheckInterval() {
        return this.timeout;
    }

    @ManagedOperation(description="Prints timestamps")
    public String printTimestamps() {
        return this._printTimestamps();
    }

    @Override
    protected void update(Address sender, boolean log_msg, boolean skip_if_exists) {
        if (sender != null && !sender.equals(this.local_addr)) {
            AtomicBoolean heartbeat_received = this.timestamps.get(sender);
            if (heartbeat_received != null) {
                if (!skip_if_exists) {
                    heartbeat_received.compareAndSet(false, true);
                }
            } else {
                this.timestamps.putIfAbsent(sender, new AtomicBoolean(true));
            }
        }
        if (log_msg && this.log.isTraceEnabled()) {
            this.log.trace("%s: received heartbeat from %s", this.local_addr, sender);
        }
    }

    @Override
    protected <T> boolean needsToBeSuspected(Address mbr, T value) {
        AtomicBoolean val = (AtomicBoolean)value;
        if (!val.compareAndSet(true, false)) {
            this.log.debug("%s: haven't received a heartbeat from %s in timeout period (%d ms), adding it to suspect list", this.local_addr, mbr, this.timeout);
            return true;
        }
        return false;
    }

    @Override
    protected String getTimeoutCheckerInfo() {
        return FD_ALL2.class.getSimpleName() + ": " + this.getClass().getSimpleName() + " (timeout=" + this.timeout + " ms)";
    }

    protected String _printTimestamps() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Address, AtomicBoolean> entry : this.timestamps.entrySet()) {
            sb.append(entry.getKey()).append(": received=").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

