/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.bind.DatatypeConverter;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Bits;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class Krb5TokenUtils {
    private static final Log log = LogFactory.getLog(Krb5TokenUtils.class);
    private static Oid krb5Oid;

    public Subject generateSecuritySubject(String jassLoginConfig, String username, String password) throws LoginException {
        LoginContext loginCtx = null;
        try {
            loginCtx = new LoginContext(jassLoginConfig, new LoginCallbackHandler(username, password));
            loginCtx.login();
            log.debug(" : Krb5Token Kerberos login succeeded against user: %s", username);
            return loginCtx.getSubject();
        }
        catch (LoginException e) {
            log.debug(" : Krb5Token Kerberos login failed against user: %s", username);
            throw e;
        }
    }

    public static byte[] initiateSecurityContext(Subject subject, String servicePrincipalName) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSName serverName = manager.createName(servicePrincipalName, GSSName.NT_HOSTBASED_SERVICE);
        final GSSContext context = manager.createContext(serverName, krb5Oid, null, 0);
        return Subject.doAs(subject, new PrivilegedAction<byte[]>(){

            @Override
            public byte[] run() {
                try {
                    byte[] token = new byte[]{};
                    context.requestMutualAuth(false);
                    context.requestCredDeleg(false);
                    return context.initSecContext(token, 0, token.length);
                }
                catch (GSSException e) {
                    log.error(Util.getMessage("Krb5TokenKerberosContextProcessingException"), e);
                    return null;
                }
            }
        });
    }

    public static String validateSecurityContext(Subject subject, final byte[] serviceTicket) throws GSSException {
        return Subject.doAs(subject, new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    GSSManager manager = GSSManager.getInstance();
                    GSSContext context = manager.createContext((GSSCredential)null);
                    context.acceptSecContext(serviceTicket, 0, serviceTicket.length);
                    return context.getSrcName().toString();
                }
                catch (Exception e) {
                    log.error(Util.getMessage("Krb5TokenKerberosContextProcessingException"), e);
                    return null;
                }
            }
        });
    }

    public static void encodeDataToStream(byte[] data, DataOutput out) throws Exception {
        String encodedToken = DatatypeConverter.printBase64Binary((byte[])data);
        log.debug(" : Written Encoded Data: \n%s", encodedToken);
        Bits.writeString(encodedToken, out);
    }

    public static byte[] decodeDataFromStream(DataInput in) throws Exception {
        String str = Bits.readString(in);
        log.debug(" : Read Encoded Data: \n%s", str);
        return DatatypeConverter.parseBase64Binary((String)str);
    }

    static {
        try {
            krb5Oid = new Oid("1.2.840.113554.1.2.2");
        }
        catch (Exception e) {
            log.error(Util.getMessage("ExceptionWasGeneratedWhileCreatingAnOidInstance"), e);
            krb5Oid = null;
        }
    }

    public static class LoginCallbackHandler
    implements CallbackHandler {
        private String password;
        private String username;

        public LoginCallbackHandler() {
        }

        public LoginCallbackHandler(String name, String password) {
            this.username = name;
            this.password = password;
        }

        public LoginCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback && this.username != null) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(this.username);
                    continue;
                }
                if (!(callback instanceof PasswordCallback)) continue;
                PasswordCallback pc = (PasswordCallback)callback;
                pc.setPassword(this.password.toCharArray());
            }
        }
    }
}

