/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQBytesMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQMapMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessageConsumer;
import org.apache.activemq.artemis.jms.client.ActiveMQMessageProducer;
import org.apache.activemq.artemis.jms.client.ActiveMQObjectMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQQueueBrowser;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.jms.client.SelectorTranslator;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;

public class ActiveMQSession
implements QueueSession,
TopicSession {
    public static final int TYPE_GENERIC_SESSION = 0;
    public static final int TYPE_QUEUE_SESSION = 1;
    public static final int TYPE_TOPIC_SESSION = 2;
    private static SimpleString REJECTING_FILTER = new SimpleString("_AMQX=-1");
    private final ActiveMQConnection connection;
    private final ClientSession session;
    private final int sessionType;
    private final int ackMode;
    private final boolean transacted;
    private final boolean xa;
    private boolean recoverCalled;
    private final Set<ActiveMQMessageConsumer> consumers = new HashSet<ActiveMQMessageConsumer>();

    protected ActiveMQSession(ActiveMQConnection connection, boolean transacted, boolean xa, int ackMode, ClientSession session, int sessionType) {
        this.connection = connection;
        this.ackMode = ackMode;
        this.session = session;
        this.sessionType = sessionType;
        this.transacted = transacted;
        this.xa = xa;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQBytesMessage(this.session);
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQMapMessage(this.session);
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQMessage(this.session);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQObjectMessage(this.session);
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage(this.session);
        msg.setObject(object);
        return msg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQStreamMessage(this.session);
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        ActiveMQTextMessage msg = new ActiveMQTextMessage(this.session);
        msg.setText(null);
        return msg;
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        ActiveMQTextMessage msg = new ActiveMQTextMessage(this.session);
        msg.setText(text);
        return msg;
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.ackMode;
    }

    public boolean isXA() {
        return this.xa;
    }

    public void commit() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot commit a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call commit on an XA session");
        }
        try {
            this.session.commit();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void rollback() throws JMSException {
        if (!this.transacted) {
            throw new IllegalStateException("Cannot rollback a non-transacted session");
        }
        if (this.xa) {
            throw new TransactionInProgressException("Cannot call rollback on an XA session");
        }
        try {
            this.session.rollback();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.connection.getThreadAwareContext().assertNotCompletionListenerThread();
        this.connection.getThreadAwareContext().assertNotMessageListenerThread();
        ActiveMQConnection activeMQConnection = this.connection;
        synchronized (activeMQConnection) {
            try {
                for (ActiveMQMessageConsumer cons : new HashSet<ActiveMQMessageConsumer>(this.consumers)) {
                    cons.close();
                }
                this.session.close();
                this.connection.removeSession(this);
            }
            catch (ActiveMQException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(e);
            }
        }
    }

    public void recover() throws JMSException {
        if (this.transacted) {
            throw new IllegalStateException("Cannot recover a transacted session");
        }
        try {
            this.session.rollback(true);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
        this.recoverCalled = true;
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return null;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
    }

    public void run() {
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination != null && !(destination instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Not an ActiveMQ Artemis Destination:" + destination);
        }
        try {
            ActiveMQDestination jbd = (ActiveMQDestination)destination;
            if (jbd != null) {
                ClientSession.AddressQuery response = this.session.addressQuery(jbd.getSimpleAddress());
                if (!response.isExists()) {
                    if (response.isAutoCreateJmsQueues()) {
                        this.session.createQueue(jbd.getSimpleAddress(), jbd.getSimpleAddress(), true);
                    } else {
                        throw new InvalidDestinationException("Destination " + jbd.getName() + " does not exist");
                    }
                }
                this.connection.addKnownDestination(jbd.getSimpleAddress());
            }
            ClientProducer producer = this.session.createProducer(jbd == null ? null : jbd.getSimpleAddress());
            return new ActiveMQMessageProducer(this.connection, producer, jbd, this.session);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (destination == null) {
            throw new InvalidDestinationException("Cannot create a consumer with a null destination");
        }
        if (!(destination instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Not an ActiveMQDestination:" + destination);
        }
        ActiveMQDestination jbdest = (ActiveMQDestination)destination;
        if (jbdest.isTemporary() && !this.connection.containsTemporaryQueue(jbdest.getSimpleAddress())) {
            throw new JMSException("Can not create consumer for temporary destination " + destination + " from another JMS connection");
        }
        return this.createConsumer(jbdest, null, messageSelector, noLocal, ConsumerDurability.NON_DURABLE);
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a queue using a TopicSession");
        }
        try {
            ActiveMQQueue queue = this.lookupQueue(queueName, false);
            if (queue == null) {
                queue = this.lookupQueue(queueName, true);
            }
            if (queue == null) {
                throw new JMSException("There is no queue with name " + queueName);
            }
            return queue;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a topic on a QueueSession");
        }
        try {
            ActiveMQTopic topic = this.lookupTopic(topicName, false);
            if (topic == null) {
                topic = this.lookupTopic(topicName, true);
            }
            if (topic == null) {
                throw new JMSException("There is no topic with name " + topicName);
            }
            return topic;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        ActiveMQDestination jbdest;
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable subscriber on a QueueSession");
        }
        this.checkTopic(topic);
        if (!(topic instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Not an ActiveMQTopic:" + topic);
        }
        if ("".equals(messageSelector)) {
            messageSelector = null;
        }
        if ((jbdest = (ActiveMQDestination)topic).isQueue()) {
            throw new InvalidDestinationException("Cannot create a subscriber on a queue");
        }
        return this.createConsumer(jbdest, name, messageSelector, noLocal, ConsumerDurability.DURABLE);
    }

    private void checkTopic(Topic topic) throws InvalidDestinationException {
        if (topic == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullTopic();
        }
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a shared consumer on a QueueSession");
        }
        this.checkTopic(topic);
        ActiveMQTopic localTopic = topic instanceof ActiveMQTopic ? (ActiveMQTopic)topic : new ActiveMQTopic(topic.getTopicName());
        return this.internalCreateSharedConsumer(localTopic, name, messageSelector, ConsumerDurability.NON_DURABLE, true);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableConsumer(topic, name, null, false);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable consumer on a QueueSession");
        }
        this.checkTopic(topic);
        ActiveMQTopic localTopic = topic instanceof ActiveMQTopic ? (ActiveMQTopic)topic : new ActiveMQTopic(topic.getTopicName());
        return this.createConsumer(localTopic, name, messageSelector, noLocal, ConsumerDurability.DURABLE);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createSharedDurableConsumer(topic, name, null);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a shared durable consumer on a QueueSession");
        }
        this.checkTopic(topic);
        ActiveMQTopic localTopic = topic instanceof ActiveMQTopic ? (ActiveMQTopic)topic : new ActiveMQTopic(topic.getTopicName());
        return this.internalCreateSharedConsumer(localTopic, name, messageSelector, ConsumerDurability.DURABLE, true);
    }

    private ActiveMQMessageConsumer internalCreateSharedConsumer(ActiveMQDestination dest, String subscriptionName, String selectorString, ConsumerDurability durability, boolean shared) throws JMSException {
        try {
            if (dest.isQueue()) {
                throw new RuntimeException("Internal error: createSharedConsumer is only meant for Topics");
            }
            if (subscriptionName == null) {
                throw ActiveMQJMSClientBundle.BUNDLE.invalidSubscriptionName();
            }
            selectorString = "".equals(selectorString) ? null : selectorString;
            SimpleString coreFilterString = null;
            if (selectorString != null) {
                coreFilterString = new SimpleString(SelectorTranslator.convertToActiveMQFilterString(selectorString));
            }
            SimpleString autoDeleteQueueName = null;
            ClientSession.AddressQuery response = this.session.addressQuery(dest.getSimpleAddress());
            if (!response.isExists()) {
                throw ActiveMQJMSClientBundle.BUNDLE.destinationDoesNotExist(dest.getSimpleAddress());
            }
            if (dest.isTemporary() && durability == ConsumerDurability.DURABLE) {
                throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
            }
            SimpleString queueName = new SimpleString(ActiveMQDestination.createQueueNameForDurableSubscription(durability == ConsumerDurability.DURABLE, this.connection.getClientID(), subscriptionName));
            if (durability == ConsumerDurability.DURABLE) {
                try {
                    this.session.createSharedQueue(dest.getSimpleAddress(), queueName, coreFilterString, true);
                }
                catch (ActiveMQQueueExistsException ignored) {}
            } else {
                this.session.createSharedQueue(dest.getSimpleAddress(), queueName, coreFilterString, false);
            }
            ClientConsumer consumer = this.session.createConsumer(queueName, null, false);
            ActiveMQMessageConsumer jbc = new ActiveMQMessageConsumer(this.connection, this, consumer, false, dest, selectorString, autoDeleteQueueName);
            this.consumers.add(jbc);
            return jbc;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    private ActiveMQMessageConsumer createConsumer(ActiveMQDestination dest, String subscriptionName, String selectorString, boolean noLocal, ConsumerDurability durability) throws JMSException {
        try {
            ClientConsumer consumer;
            ClientSession.AddressQuery response;
            String string = selectorString = "".equals(selectorString) ? null : selectorString;
            if (noLocal) {
                this.connection.setHasNoLocal();
                String filter = this.connection.getClientID() != null ? ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + this.connection.getClientID() + "'" : ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + this.connection.getUID() + "'";
                selectorString = selectorString != null ? selectorString + " AND " + filter : filter;
            }
            SimpleString coreFilterString = null;
            if (selectorString != null) {
                coreFilterString = new SimpleString(SelectorTranslator.convertToActiveMQFilterString(selectorString));
            }
            SimpleString autoDeleteQueueName = null;
            if (dest.isQueue()) {
                response = this.session.addressQuery(dest.getSimpleAddress());
                if (!response.isExists() || !response.getQueueNames().contains(dest.getSimpleAddress())) {
                    if (response.isAutoCreateJmsQueues()) {
                        this.session.createQueue(dest.getSimpleAddress(), dest.getSimpleAddress(), true);
                    } else {
                        throw new InvalidDestinationException("Destination " + dest.getName() + " does not exist");
                    }
                }
                this.connection.addKnownDestination(dest.getSimpleAddress());
                consumer = this.session.createConsumer(dest.getSimpleAddress(), coreFilterString, false);
            } else {
                response = this.session.addressQuery(dest.getSimpleAddress());
                if (!response.isExists()) {
                    throw new InvalidDestinationException("Topic " + dest.getName() + " does not exist");
                }
                this.connection.addKnownDestination(dest.getSimpleAddress());
                if (subscriptionName == null) {
                    if (durability != ConsumerDurability.NON_DURABLE) {
                        throw new RuntimeException("Subscription name cannot be null for durable topic consumer");
                    }
                    SimpleString queueName = new SimpleString(UUID.randomUUID().toString());
                    this.session.createTemporaryQueue(dest.getSimpleAddress(), queueName, coreFilterString);
                    consumer = this.session.createConsumer(queueName, null, false);
                    autoDeleteQueueName = queueName;
                } else {
                    if (durability != ConsumerDurability.DURABLE) {
                        throw new RuntimeException("Subscription name must be null for non-durable topic consumer");
                    }
                    if (this.connection.getClientID() == null) {
                        throw new IllegalStateException("Cannot create durable subscription - client ID has not been set");
                    }
                    if (dest.isTemporary()) {
                        throw new InvalidDestinationException("Cannot create a durable subscription on a temporary topic");
                    }
                    SimpleString queueName = new SimpleString(ActiveMQDestination.createQueueNameForDurableSubscription(true, this.connection.getClientID(), subscriptionName));
                    ClientSession.QueueQuery subResponse = this.session.queueQuery(queueName);
                    if (!subResponse.isExists()) {
                        this.session.createQueue(dest.getSimpleAddress(), queueName, coreFilterString, true);
                    } else {
                        boolean topicChanged;
                        if (subResponse.getConsumerCount() > 0) {
                            throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                        }
                        SimpleString oldFilterString = subResponse.getFilterString();
                        boolean selectorChanged = coreFilterString == null && oldFilterString != null || oldFilterString == null && coreFilterString != null || oldFilterString != null && coreFilterString != null && !oldFilterString.equals((Object)coreFilterString);
                        SimpleString oldTopicName = subResponse.getAddress();
                        boolean bl = topicChanged = !oldTopicName.equals((Object)dest.getSimpleAddress());
                        if (selectorChanged || topicChanged) {
                            this.session.deleteQueue(queueName);
                            this.session.createQueue(dest.getSimpleAddress(), queueName, coreFilterString, true);
                        }
                    }
                    consumer = this.session.createConsumer(queueName, null, false);
                }
            }
            ActiveMQMessageConsumer jbc = new ActiveMQMessageConsumer(this.connection, this, consumer, noLocal, dest, selectorString, autoDeleteQueueName);
            this.consumers.add(jbc);
            return jbc;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void ackAllConsumers() throws JMSException {
        this.checkClosed();
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String filterString) throws JMSException {
        ActiveMQDestination jbq;
        block11: {
            if (this.sessionType == 2) {
                throw new IllegalStateException("Cannot create a browser on a TopicSession");
            }
            if (queue == null) {
                throw new InvalidDestinationException("Cannot create a browser with a null queue");
            }
            if (!(queue instanceof ActiveMQDestination)) {
                throw new InvalidDestinationException("Not an ActiveMQQueue:" + queue);
            }
            if ("".equals(filterString)) {
                filterString = null;
            }
            try {
                if (filterString != null) {
                    SelectorParser.parse((String)filterString.trim());
                }
            }
            catch (FilterException e) {
                throw JMSExceptionHelper.convertFromActiveMQException((ActiveMQException)ActiveMQJMSClientBundle.BUNDLE.invalidFilter(e, new SimpleString(filterString)));
            }
            jbq = (ActiveMQDestination)queue;
            if (!jbq.isQueue()) {
                throw new InvalidDestinationException("Cannot create a browser on a topic");
            }
            try {
                ClientSession.AddressQuery response = this.session.addressQuery(new SimpleString(jbq.getAddress()));
                if (response.isExists()) break block11;
                if (response.isAutoCreateJmsQueues()) {
                    this.session.createQueue(jbq.getSimpleAddress(), jbq.getSimpleAddress(), true);
                    break block11;
                }
                throw new InvalidDestinationException("Destination " + jbq.getName() + " does not exist");
            }
            catch (ActiveMQException e) {
                throw JMSExceptionHelper.convertFromActiveMQException(e);
            }
        }
        return new ActiveMQQueueBrowser((ActiveMQQueue)jbq, filterString, this.session);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a temporary queue using a TopicSession");
        }
        try {
            ActiveMQTemporaryQueue queue = ActiveMQDestination.createTemporaryQueue(this);
            SimpleString simpleAddress = queue.getSimpleAddress();
            this.session.createTemporaryQueue(simpleAddress, simpleAddress);
            this.connection.addTemporaryQueue(simpleAddress);
            return queue;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a temporary topic on a QueueSession");
        }
        try {
            ActiveMQTemporaryTopic topic = ActiveMQDestination.createTemporaryTopic(this);
            SimpleString simpleAddress = topic.getSimpleAddress();
            this.session.createTemporaryQueue(simpleAddress, simpleAddress, REJECTING_FILTER);
            this.connection.addTemporaryQueue(simpleAddress);
            return topic;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void unsubscribe(String name) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot unsubscribe using a QueueSession");
        }
        SimpleString queueName = new SimpleString(ActiveMQDestination.createQueueNameForDurableSubscription(true, this.connection.getClientID(), name));
        try {
            ClientSession.QueueQuery response = this.session.queueQuery(queueName);
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot unsubscribe, subscription with name " + name + " does not exist");
            }
            if (response.getConsumerCount() != 0) {
                throw new IllegalStateException("Cannot unsubscribe durable subscription " + name + " since it has active subscribers");
            }
            this.session.deleteQueue(queueName);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public Session getSession() throws JMSException {
        if (!this.xa) {
            throw new IllegalStateException("Isn't an XASession");
        }
        return this;
    }

    public XAResource getXAResource() {
        return this.session.getXAResource();
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return (QueueReceiver)this.createConsumer((Destination)queue, messageSelector);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return (QueueReceiver)this.createConsumer((Destination)queue);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return (QueueSender)this.createProducer((Destination)queue);
    }

    public QueueSession getQueueSession() throws JMSException {
        return (QueueSession)this.getSession();
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return (TopicPublisher)this.createProducer((Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)this.createConsumer((Destination)topic, messageSelector, noLocal);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return (TopicSubscriber)this.createConsumer((Destination)topic);
    }

    public TopicSession getTopicSession() throws JMSException {
        return (TopicSession)this.getSession();
    }

    public String toString() {
        return "ActiveMQSession->" + this.session;
    }

    public ClientSession getCoreSession() {
        return this.session;
    }

    public boolean isRecoverCalled() {
        return this.recoverCalled;
    }

    public void setRecoverCalled(boolean recoverCalled) {
        this.recoverCalled = recoverCalled;
    }

    public void deleteTemporaryTopic(ActiveMQDestination tempTopic) throws JMSException {
        if (!tempTopic.isTemporary()) {
            throw new InvalidDestinationException("Not a temporary topic " + tempTopic);
        }
        try {
            ClientSession.AddressQuery response = this.session.addressQuery(tempTopic.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary topic " + tempTopic.getName() + " does not exist");
            }
            if (response.getQueueNames().size() > 1) {
                throw new IllegalStateException("Cannot delete temporary topic " + tempTopic.getName() + " since it has subscribers");
            }
            SimpleString address = tempTopic.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void deleteTemporaryQueue(ActiveMQDestination tempQueue) throws JMSException {
        if (!tempQueue.isTemporary()) {
            throw new InvalidDestinationException("Not a temporary queue " + tempQueue);
        }
        try {
            ClientSession.QueueQuery response = this.session.queueQuery(tempQueue.getSimpleAddress());
            if (!response.isExists()) {
                throw new InvalidDestinationException("Cannot delete temporary queue " + tempQueue.getName() + " does not exist");
            }
            if (response.getConsumerCount() > 0) {
                throw new IllegalStateException("Cannot delete temporary queue " + tempQueue.getName() + " since it has subscribers");
            }
            SimpleString address = tempQueue.getSimpleAddress();
            this.session.deleteQueue(address);
            this.connection.removeTemporaryQueue(address);
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void start() throws JMSException {
        try {
            this.session.start();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void stop() throws JMSException {
        try {
            this.session.stop();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public void removeConsumer(ActiveMQMessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    void deleteQueue(SimpleString queueName) throws JMSException {
        if (!this.session.isClosed()) {
            try {
                this.session.deleteQueue(queueName);
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
        }
    }

    private void checkClosed() throws JMSException {
        if (this.session.isClosed()) {
            throw new IllegalStateException("Session is closed");
        }
    }

    private ActiveMQQueue lookupQueue(String queueName, boolean isTemporary) throws ActiveMQException {
        ActiveMQQueue queue = isTemporary ? ActiveMQDestination.createTemporaryQueue(queueName) : ActiveMQDestination.createQueue(queueName);
        ClientSession.QueueQuery response = this.session.queueQuery(queue.getSimpleAddress());
        if (!response.isExists() && !response.isAutoCreateJmsQueues()) {
            return null;
        }
        return queue;
    }

    private ActiveMQTopic lookupTopic(String topicName, boolean isTemporary) throws ActiveMQException {
        ActiveMQTopic topic = isTemporary ? ActiveMQDestination.createTemporaryTopic(topicName) : ActiveMQDestination.createTopic(topicName);
        ClientSession.AddressQuery query = this.session.addressQuery(topic.getSimpleAddress());
        if (!query.isExists()) {
            return null;
        }
        return topic;
    }

    static enum ConsumerDurability {
        DURABLE,
        NON_DURABLE;

    }
}

