/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.core.io.DummyCallback;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.io.buffer.TimedBufferObserver;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;

public abstract class AbstractSequentialFile
implements SequentialFile {
    private File file;
    protected final File directory;
    protected final SequentialFileFactory factory;
    protected long fileSize = 0L;
    protected final AtomicLong position = new AtomicLong(0L);
    protected TimedBuffer timedBuffer;
    protected final TimedBufferObserver timedBufferObserver = new LocalBufferObserver();
    protected final Executor writerExecutor;

    public AbstractSequentialFile(File directory, String file, SequentialFileFactory factory, Executor writerExecutor) {
        this.file = new File(directory, file);
        this.directory = directory;
        this.factory = factory;
        this.writerExecutor = writerExecutor;
    }

    @Override
    public final boolean exists() {
        return this.file.exists();
    }

    @Override
    public final String getFileName() {
        return this.file.getName();
    }

    @Override
    public final void delete() throws IOException, InterruptedException, ActiveMQException {
        if (this.isOpen()) {
            this.close();
        }
        if (this.file.exists() && !this.file.delete()) {
            ActiveMQJournalLogger.LOGGER.errorDeletingFile(this);
        }
    }

    @Override
    public void copyTo(SequentialFile newFileName) throws Exception {
        try {
            int size;
            ActiveMQJournalLogger.LOGGER.debug("Copying " + this + " as " + newFileName);
            if (!newFileName.isOpen()) {
                newFileName.open();
            }
            if (!this.isOpen()) {
                this.open();
            }
            ByteBuffer buffer = ByteBuffer.allocate(10240);
            do {
                buffer.rewind();
                size = this.read(buffer);
                newFileName.writeDirect(buffer, false);
            } while (size >= 10240);
            newFileName.close();
            this.close();
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
    }

    @Override
    public void position(long pos) throws IOException {
        this.position.set(pos);
    }

    @Override
    public long position() {
        return this.position.get();
    }

    @Override
    public final void renameTo(String newFileName) throws IOException, InterruptedException, ActiveMQException {
        try {
            this.close();
        }
        catch (IOException e) {
            this.factory.onIOError((Exception)new ActiveMQIOErrorException(e.getMessage(), (Throwable)e), e.getMessage(), this);
            throw e;
        }
        File newFile = new File(this.directory + "/" + newFileName);
        if (!this.file.equals(newFile)) {
            if (!this.file.renameTo(newFile)) {
                throw ActiveMQJournalBundle.BUNDLE.ioRenameFileError(this.file.getName(), newFileName);
            }
            this.file = newFile;
        }
    }

    @Override
    public synchronized void close() throws IOException, InterruptedException, ActiveMQException {
        final CountDownLatch donelatch = new CountDownLatch(1);
        if (this.writerExecutor != null) {
            this.writerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    donelatch.countDown();
                }
            });
            while (!donelatch.await(60L, TimeUnit.SECONDS)) {
                ActiveMQJournalLogger.LOGGER.couldNotCompleteTask(new Exception("trace"), this.file.getName());
            }
        }
    }

    @Override
    public final boolean fits(int size) {
        if (this.timedBuffer == null) {
            return this.position.get() + (long)size <= this.fileSize;
        }
        return this.timedBuffer.checkSize(size);
    }

    @Override
    public void setTimedBuffer(TimedBuffer buffer) {
        if (this.timedBuffer != null) {
            this.timedBuffer.setObserver(null);
        }
        this.timedBuffer = buffer;
        if (buffer != null) {
            buffer.setObserver(this.timedBufferObserver);
        }
    }

    @Override
    public void write(ActiveMQBuffer bytes, boolean sync, IOCallback callback) throws IOException {
        if (this.timedBuffer != null) {
            bytes.setIndex(0, bytes.capacity());
            this.timedBuffer.addBytes(bytes, sync, callback);
        } else {
            ByteBuffer buffer = this.factory.newBuffer(bytes.capacity());
            buffer.put(bytes.toByteBuffer().array());
            buffer.rewind();
            this.writeDirect(buffer, sync, callback);
        }
    }

    @Override
    public void write(ActiveMQBuffer bytes, boolean sync) throws IOException, InterruptedException, ActiveMQException {
        if (sync) {
            SimpleWaitIOCallback completion = new SimpleWaitIOCallback();
            this.write(bytes, true, (IOCallback)completion);
            completion.waitCompletion();
        } else {
            this.write(bytes, false, (IOCallback)DummyCallback.getInstance());
        }
    }

    @Override
    public void write(EncodingSupport bytes, boolean sync, IOCallback callback) {
        if (this.timedBuffer != null) {
            this.timedBuffer.addBytes(bytes, sync, callback);
        } else {
            ByteBuffer buffer = this.factory.newBuffer(bytes.getEncodeSize());
            ActiveMQBuffer outBuffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)buffer);
            bytes.encode(outBuffer);
            buffer.rewind();
            this.writeDirect(buffer, sync, callback);
        }
    }

    @Override
    public void write(EncodingSupport bytes, boolean sync) throws InterruptedException, ActiveMQException {
        if (sync) {
            SimpleWaitIOCallback completion = new SimpleWaitIOCallback();
            this.write(bytes, true, (IOCallback)completion);
            completion.waitCompletion();
        } else {
            this.write(bytes, false, (IOCallback)DummyCallback.getInstance());
        }
    }

    protected File getFile() {
        return this.file;
    }

    protected ByteBuffer newBuffer(int size, int limit) {
        size = this.factory.calculateBlockSize(size);
        limit = this.factory.calculateBlockSize(limit);
        ByteBuffer buffer = this.factory.newBuffer(size);
        buffer.limit(limit);
        return buffer;
    }

    @Override
    public File getJavaFile() {
        return this.getFile().getAbsoluteFile();
    }

    protected class LocalBufferObserver
    implements TimedBufferObserver {
        protected LocalBufferObserver() {
        }

        @Override
        public void flushBuffer(ByteBuffer buffer, boolean requestedSync, List<IOCallback> callbacks) {
            buffer.flip();
            if (buffer.limit() == 0) {
                AbstractSequentialFile.this.factory.releaseBuffer(buffer);
            } else {
                AbstractSequentialFile.this.writeDirect(buffer, requestedSync, new DelegateCallback(callbacks));
            }
        }

        @Override
        public ByteBuffer newBuffer(int size, int limit) {
            return AbstractSequentialFile.this.newBuffer(size, limit);
        }

        @Override
        public int getRemainingBytes() {
            if (AbstractSequentialFile.this.fileSize - AbstractSequentialFile.this.position.get() > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)(AbstractSequentialFile.this.fileSize - AbstractSequentialFile.this.position.get());
        }

        public String toString() {
            return "TimedBufferObserver on file (" + AbstractSequentialFile.this.getFile().getName() + ")";
        }
    }

    private static final class DelegateCallback
    implements IOCallback {
        final List<IOCallback> delegates;

        private DelegateCallback(List<IOCallback> delegates) {
            this.delegates = delegates;
        }

        @Override
        public void done() {
            for (IOCallback callback : this.delegates) {
                try {
                    callback.done();
                }
                catch (Throwable e) {
                    ActiveMQJournalLogger.LOGGER.errorCompletingCallback(e);
                }
            }
        }

        @Override
        public void onError(int errorCode, String errorMessage) {
            for (IOCallback callback : this.delegates) {
                try {
                    callback.onError(errorCode, errorMessage);
                }
                catch (Throwable e) {
                    ActiveMQJournalLogger.LOGGER.errorCallingErrorCallback(e);
                }
            }
        }
    }
}

