/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra.inflow;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.ra.ActiveMQRABundle;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRaUtils;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.ra.inflow.ActiveMQMessageHandler;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;

public class ActiveMQActivation {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    public static final Method ONMESSAGE;
    private final ActiveMQResourceAdapter ra;
    private final ActiveMQActivationSpec spec;
    private final MessageEndpointFactory endpointFactory;
    private final AtomicBoolean deliveryActive = new AtomicBoolean(false);
    private boolean isTopic = false;
    private boolean isDeliveryTransacted;
    private ActiveMQDestination destination;
    private SimpleString topicTemporaryQueue;
    private final List<ActiveMQMessageHandler> handlers = new ArrayList<ActiveMQMessageHandler>();
    private ActiveMQConnectionFactory factory;
    private List<String> nodes = Collections.synchronizedList(new ArrayList());
    private Map<String, Long> removedNodes = new ConcurrentHashMap<String, Long>();
    private boolean lastReceived = false;
    private final AtomicBoolean inReconnect = new AtomicBoolean(false);
    private XARecoveryConfig resourceRecovery;

    public ActiveMQActivation(ActiveMQResourceAdapter ra, MessageEndpointFactory endpointFactory, ActiveMQActivationSpec spec) throws ResourceException {
        String pass;
        spec.validate();
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + ra + ", " + endpointFactory + ", " + spec + ")");
        }
        if (ra.isUseMaskedPassword().booleanValue() && (pass = spec.getOwnPassword()) != null) {
            SensitiveDataCodec<String> codec = ra.getCodecInstance();
            try {
                spec.setPassword((String)codec.decode((Object)pass));
            }
            catch (Exception e) {
                throw new ResourceException((Throwable)e);
            }
        }
        this.ra = ra;
        this.endpointFactory = endpointFactory;
        this.spec = spec;
        try {
            this.isDeliveryTransacted = endpointFactory.isDeliveryTransacted(ONMESSAGE);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public ActiveMQActivationSpec getActivationSpec() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getActivationSpec()");
        }
        return this.spec;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getMessageEndpointFactory()");
        }
        return this.endpointFactory;
    }

    public boolean isDeliveryTransacted() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isDeliveryTransacted()");
        }
        return this.isDeliveryTransacted;
    }

    public WorkManager getWorkManager() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getWorkManager()");
        }
        return this.ra.getWorkManager();
    }

    public boolean isTopic() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("isTopic()");
        }
        return this.isTopic;
    }

    public void start() throws ResourceException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("start()");
        }
        this.deliveryActive.set(true);
        this.ra.getWorkManager().scheduleWork((Work)new SetupActivation());
    }

    public SimpleString getTopicTemporaryQueue() {
        return this.topicTemporaryQueue;
    }

    public void setTopicTemporaryQueue(SimpleString topicTemporaryQueue) {
        this.topicTemporaryQueue = topicTemporaryQueue;
    }

    public List<XAResource> getXAResources() {
        ArrayList<XAResource> xaresources = new ArrayList<XAResource>();
        for (ActiveMQMessageHandler handler : this.handlers) {
            XAResource xares = handler.getXAResource();
            if (xares == null) continue;
            xaresources.add(xares);
        }
        return xaresources;
    }

    public void stop() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("stop()");
        }
        this.deliveryActive.set(false);
        this.teardown();
    }

    protected synchronized void setup() throws Exception {
        ActiveMQRALogger.LOGGER.debug("Setting up " + this.spec);
        this.setupCF();
        this.setupDestination();
        Exception firstException = null;
        for (int i = 0; i < this.spec.getMaxSession(); ++i) {
            ClientSessionFactory cf = null;
            ClientSession session = null;
            try {
                cf = this.factory.getServerLocator().createSessionFactory();
                session = this.setupSession(cf);
                ActiveMQMessageHandler handler = new ActiveMQMessageHandler(this, this.ra.getTM(), (ClientSessionInternal)session, cf, i);
                handler.setup();
                this.handlers.add(handler);
                continue;
            }
            catch (Exception e) {
                if (cf != null) {
                    cf.close();
                }
                if (session != null) {
                    session.close();
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            for (ActiveMQMessageHandler handler : this.handlers) {
                handler.teardown();
            }
            throw firstException;
        }
        for (ActiveMQMessageHandler handler : this.handlers) {
            handler.start();
        }
        HashMap<String, String> recoveryConfProps = new HashMap<String, String>();
        recoveryConfProps.put("JNDI_NAME", this.ra.getJndiName());
        this.resourceRecovery = this.ra.getRecoveryManager().register(this.factory, this.spec.getUser(), this.spec.getPassword(), recoveryConfProps);
        if (this.spec.isRebalanceConnections()) {
            this.factory.getServerLocator().addClusterTopologyListener((ClusterTopologyListener)new RebalancingListener());
        }
        ActiveMQRALogger.LOGGER.debug("Setup complete " + this);
    }

    protected synchronized void teardown() {
        boolean stuckThreads;
        ActiveMQRALogger.LOGGER.debug("Tearing down " + this.spec);
        if (this.resourceRecovery != null) {
            this.ra.getRecoveryManager().unRegister(this.resourceRecovery);
        }
        final ActiveMQMessageHandler[] handlersCopy = new ActiveMQMessageHandler[this.handlers.size()];
        for (int i = 0; i < this.handlers.size(); ++i) {
            handlersCopy[i] = this.handlers.get(this.handlers.size() - i - 1);
        }
        this.handlers.clear();
        FutureLatch future = new FutureLatch(handlersCopy.length);
        ArrayList<Thread> interruptThreads = new ArrayList<Thread>();
        for (ActiveMQMessageHandler handler : handlersCopy) {
            Thread thread = handler.interruptConsumer(future);
            if (thread == null) continue;
            interruptThreads.add(thread);
        }
        boolean bl = stuckThreads = !future.await(this.factory.getCallTimeout());
        if (stuckThreads) {
            for (Thread interruptThread : interruptThreads) {
                try {
                    interruptThread.interrupt();
                }
                catch (Exception e) {}
            }
        }
        Thread threadTearDown = new Thread("TearDown/ActiveMQActivation"){

            @Override
            public void run() {
                for (ActiveMQMessageHandler handler : handlersCopy) {
                    handler.teardown();
                }
            }
        };
        threadTearDown.start();
        try {
            threadTearDown.join(this.factory.getCallTimeout());
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (threadTearDown.isAlive()) {
            if (this.factory != null) {
                this.factory.close();
                this.factory = null;
            }
            threadTearDown.interrupt();
            try {
                threadTearDown.join(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (threadTearDown.isAlive()) {
                ActiveMQRALogger.LOGGER.threadCouldNotFinish(threadTearDown.toString());
            }
        }
        if (this.spec.isHasBeenUpdated() && this.factory != null) {
            this.ra.closeConnectionFactory(this.spec);
            this.factory = null;
        }
        this.nodes.clear();
        this.lastReceived = false;
        ActiveMQRALogger.LOGGER.debug("Tearing down complete " + this);
    }

    protected void setupCF() throws Exception {
        if (this.spec.getConnectionFactoryLookup() != null) {
            InitialContext ctx = this.spec.getParsedJndiParams() == null ? new InitialContext() : new InitialContext(this.spec.getParsedJndiParams());
            Object fac = ctx.lookup(this.spec.getConnectionFactoryLookup());
            if (fac instanceof ActiveMQConnectionFactory) {
                this.factory = (ActiveMQConnectionFactory)fac;
            } else {
                ActiveMQRAConnectionFactory raFact = (ActiveMQRAConnectionFactory)fac;
                if (this.spec.isHasBeenUpdated()) {
                    this.factory = raFact.getResourceAdapter().createActiveMQConnectionFactory(this.spec);
                } else {
                    this.factory = raFact.getDefaultFactory();
                    if (this.factory != this.ra.getDefaultActiveMQConnectionFactory()) {
                        ActiveMQRALogger.LOGGER.warnDifferentConnectionfactory();
                    }
                }
            }
        } else {
            this.factory = this.spec.isHasBeenUpdated() ? this.ra.createActiveMQConnectionFactory(this.spec) : this.ra.getDefaultActiveMQConnectionFactory();
        }
    }

    protected ClientSession setupSession(ClientSessionFactory cf) throws Exception {
        ClientSession result = null;
        try {
            String clientID;
            result = this.ra.createSession(cf, this.spec.getAcknowledgeModeInt(), this.spec.getUser(), this.spec.getPassword(), this.ra.getPreAcknowledge(), this.ra.getDupsOKBatchSize(), this.ra.getTransactionBatchSize(), this.isDeliveryTransacted, this.spec.isUseLocalTx(), this.spec.getTransactionTimeout());
            result.addMetaData("resource-adapter", "inbound");
            result.addMetaData("jms-session", "");
            String string = clientID = this.ra.getClientID() == null ? this.spec.getClientID() : this.ra.getClientID();
            if (clientID != null) {
                result.addMetaData("jms-client-id", clientID);
            }
            ActiveMQRALogger.LOGGER.debug("Using queue connection " + result);
            return result;
        }
        catch (Throwable t) {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                ActiveMQRALogger.LOGGER.trace("Ignored error closing connection", e);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeException("Error configuring connection", t);
        }
    }

    public SimpleString getAddress() {
        return this.destination.getSimpleAddress();
    }

    protected void setupDestination() throws Exception {
        block14: {
            String destinationName = this.spec.getDestination();
            if (this.spec.isUseJNDI()) {
                String destinationTypeString;
                InitialContext ctx = this.spec.getParsedJndiParams() == null ? new InitialContext() : new InitialContext(this.spec.getParsedJndiParams());
                ActiveMQRALogger.LOGGER.debug("Using context " + ctx.getEnvironment() + " for " + this.spec);
                if (trace) {
                    ActiveMQRALogger.LOGGER.trace("setupDestination(" + ctx + ")");
                }
                if ((destinationTypeString = this.spec.getDestinationType()) != null && !destinationTypeString.trim().equals("")) {
                    Class<Topic> destinationType;
                    ActiveMQRALogger.LOGGER.debug("Destination type defined as " + destinationTypeString);
                    if (Topic.class.getName().equals(destinationTypeString)) {
                        destinationType = Topic.class;
                        this.isTopic = true;
                    } else {
                        destinationType = Queue.class;
                    }
                    ActiveMQRALogger.LOGGER.debug("Retrieving " + destinationType.getName() + " \"" + destinationName + "\" from JNDI");
                    try {
                        this.destination = (ActiveMQDestination)ActiveMQRaUtils.lookup(ctx, destinationName, destinationType);
                    }
                    catch (Exception e) {
                        if (destinationName == null) {
                            throw ActiveMQRABundle.BUNDLE.noDestinationName();
                        }
                        String calculatedDestinationName = destinationName.substring(destinationName.lastIndexOf(47) + 1);
                        ActiveMQRALogger.LOGGER.debug("Unable to retrieve " + destinationName + " from JNDI. Creating a new " + destinationType.getName() + " named " + calculatedDestinationName + " to be used by the MDB.");
                        if (this.isTopic) {
                            this.destination = (ActiveMQDestination)ActiveMQJMSClient.createTopic((String)calculatedDestinationName);
                            break block14;
                        }
                        this.destination = (ActiveMQDestination)ActiveMQJMSClient.createQueue((String)calculatedDestinationName);
                    }
                } else {
                    ActiveMQRALogger.LOGGER.debug("Destination type not defined in MDB activation configuration.");
                    ActiveMQRALogger.LOGGER.debug("Retrieving " + Destination.class.getName() + " \"" + destinationName + "\" from JNDI");
                    this.destination = (ActiveMQDestination)ActiveMQRaUtils.lookup(ctx, destinationName, Destination.class);
                    if (this.destination instanceof Topic) {
                        this.isTopic = true;
                    }
                }
            } else {
                ActiveMQRALogger.LOGGER.instantiatingDestination(this.spec.getDestinationType(), this.spec.getDestination());
                if (Topic.class.getName().equals(this.spec.getDestinationType())) {
                    this.destination = (ActiveMQDestination)ActiveMQJMSClient.createTopic((String)this.spec.getDestination());
                    this.isTopic = true;
                } else {
                    this.destination = (ActiveMQDestination)ActiveMQJMSClient.createQueue((String)this.spec.getDestination());
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ActiveMQActivation.class.getName()).append('(');
        buffer.append("spec=").append(this.spec.getClass().getName());
        buffer.append(" mepf=").append(this.endpointFactory.getClass().getName());
        buffer.append(" active=").append(this.deliveryActive.get());
        if (this.spec.getDestination() != null) {
            buffer.append(" destination=").append(this.spec.getDestination());
        }
        buffer.append(" transacted=").append(this.isDeliveryTransacted);
        buffer.append(')');
        return buffer.toString();
    }

    public void rebalance() {
        ActiveMQRALogger.LOGGER.rebalancingConnections();
        this.reconnect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(Throwable failure) {
        if (failure != null) {
            if (failure instanceof ActiveMQException && ((ActiveMQException)failure).getType() == ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST) {
                ActiveMQRALogger.LOGGER.awaitingTopicQueueCreation(this.getActivationSpec().getDestination());
            } else if (failure instanceof ActiveMQException && ((ActiveMQException)failure).getType() == ActiveMQExceptionType.NOT_CONNECTED) {
                ActiveMQRALogger.LOGGER.awaitingJMSServerCreation();
            } else {
                ActiveMQRALogger.LOGGER.failureInActivation(failure, this.spec);
            }
        }
        int setupAttempts = this.spec.getSetupAttempts();
        long setupInterval = this.spec.getSetupInterval();
        if (this.inReconnect.getAndSet(true)) {
            return;
        }
        try {
            Throwable lastException = failure;
            for (int reconnectCount = 0; this.deliveryActive.get() && (setupAttempts == -1 || reconnectCount < setupAttempts); ++reconnectCount) {
                this.teardown();
                try {
                    Thread.sleep(setupInterval);
                }
                catch (InterruptedException e) {
                    ActiveMQRALogger.LOGGER.debug("Interrupted trying to reconnect " + this.spec, e);
                    break;
                }
                if (reconnectCount < 1) {
                    ActiveMQRALogger.LOGGER.attemptingReconnect(this.spec);
                }
                try {
                    this.setup();
                    ActiveMQRALogger.LOGGER.reconnected();
                    break;
                }
                catch (Throwable t) {
                    if (failure instanceof ActiveMQException && ((ActiveMQException)failure).getType() == ActiveMQExceptionType.QUEUE_DOES_NOT_EXIST) {
                        if (lastException != null && t instanceof ActiveMQNonExistentQueueException) continue;
                        lastException = t;
                        ActiveMQRALogger.LOGGER.awaitingTopicQueueCreation(this.getActivationSpec().getDestination());
                        continue;
                    }
                    if (failure instanceof ActiveMQException && ((ActiveMQException)failure).getType() == ActiveMQExceptionType.NOT_CONNECTED) {
                        if (lastException != null && t instanceof ActiveMQNotConnectedException) continue;
                        lastException = t;
                        ActiveMQRALogger.LOGGER.awaitingJMSServerCreation();
                        continue;
                    }
                    ActiveMQRALogger.LOGGER.errorReconnecting(t, this.spec);
                    continue;
                }
            }
        }
        finally {
            this.inReconnect.set(false);
        }
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    static {
        try {
            ONMESSAGE = MessageListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class RebalancingListener
    implements ClusterTopologyListener {
        private RebalancingListener() {
        }

        public void nodeUP(TopologyMember member, boolean last) {
            boolean newNode = false;
            String id = member.getNodeId();
            if (!ActiveMQActivation.this.nodes.contains(id) && (ActiveMQActivation.this.removedNodes.get(id) == null || ActiveMQActivation.this.removedNodes.get(id) != null && (Long)ActiveMQActivation.this.removedNodes.get(id) < member.getUniqueEventID())) {
                ActiveMQActivation.this.nodes.add(id);
                newNode = true;
            }
            if (ActiveMQActivation.this.lastReceived && newNode) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ActiveMQActivation.this.rebalance();
                    }
                };
                Thread t = new Thread(runnable, "NodeUP Connection Rebalancer");
                t.start();
            } else if (last) {
                ActiveMQActivation.this.lastReceived = true;
            }
        }

        public void nodeDown(long eventUID, String nodeID) {
            if (ActiveMQActivation.this.nodes.remove(nodeID)) {
                ActiveMQActivation.this.removedNodes.put(nodeID, eventUID);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ActiveMQActivation.this.rebalance();
                    }
                };
                Thread t = new Thread(runnable, "NodeDOWN Connection Rebalancer");
                t.start();
            }
        }
    }

    private class SetupActivation
    implements Work {
        private SetupActivation() {
        }

        public void run() {
            try {
                ActiveMQActivation.this.setup();
            }
            catch (Throwable t) {
                ActiveMQActivation.this.reconnect(t);
            }
        }

        public void release() {
        }
    }
}

