/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;

public class ReplicatedPolicy
implements HAPolicy<LiveActivation> {
    private boolean checkForLiveServer = ActiveMQDefaultConfiguration.isDefaultCheckForLiveServer();
    private String groupName = null;
    private String clusterName;
    private long initialReplicationSyncTimeout = ActiveMQDefaultConfiguration.getDefaultInitialReplicationSyncTimeout();
    private boolean allowAutoFailBack = ActiveMQDefaultConfiguration.isDefaultAllowAutoFailback();
    private ReplicaPolicy replicaPolicy;

    public ReplicatedPolicy() {
        this.replicaPolicy = new ReplicaPolicy(this.clusterName, -1, this.groupName, this);
    }

    public ReplicatedPolicy(boolean checkForLiveServer, String groupName, String clusterName, long initialReplicationSyncTimeout) {
        this.checkForLiveServer = checkForLiveServer;
        this.groupName = groupName;
        this.clusterName = clusterName;
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
    }

    public ReplicatedPolicy(boolean checkForLiveServer, boolean allowAutoFailBack, long initialReplicationSyncTimeout, String groupName, String clusterName, ReplicaPolicy replicaPolicy) {
        this.checkForLiveServer = checkForLiveServer;
        this.clusterName = clusterName;
        this.groupName = groupName;
        this.allowAutoFailBack = allowAutoFailBack;
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        this.replicaPolicy = replicaPolicy;
    }

    public boolean isCheckForLiveServer() {
        return this.checkForLiveServer;
    }

    public void setCheckForLiveServer(boolean checkForLiveServer) {
        this.checkForLiveServer = checkForLiveServer;
    }

    public boolean isAllowAutoFailBack() {
        return this.allowAutoFailBack;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    @Deprecated
    public void setFailbackDelay(long failbackDelay) {
    }

    public long getInitialReplicationSyncTimeout() {
        return this.initialReplicationSyncTimeout;
    }

    public void setInitialReplicationSyncTimeout(long initialReplicationSyncTimeout) {
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ReplicaPolicy getReplicaPolicy() {
        if (this.replicaPolicy == null) {
            this.replicaPolicy = new ReplicaPolicy(this.clusterName, -1, this.groupName, this);
        }
        return this.replicaPolicy;
    }

    public void setReplicaPolicy(ReplicaPolicy replicaPolicy) {
        this.replicaPolicy = replicaPolicy;
    }

    @Override
    public String getBackupGroupName() {
        return this.groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getScaleDownGroupName() {
        return null;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public boolean isSharedStore() {
        return false;
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }

    public void setAllowAutoFailBack(boolean allowAutoFailBack) {
        this.allowAutoFailBack = allowAutoFailBack;
    }

    @Override
    public LiveActivation createActivation(ActiveMQServerImpl server, boolean wasLive, Map<String, Object> activationParams, ActiveMQServerImpl.ShutdownOnCriticalErrorListener shutdownOnCriticalIO) {
        return new SharedNothingLiveActivation(server, this);
    }
}

