/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.jboss.logging.Logger;

public final class ReplicationSyncFileMessage
extends PacketImpl {
    private static final Logger logger = Logger.getLogger(ReplicationSyncFileMessage.class);
    private AbstractJournalStorageManager.JournalContent journalType;
    private long fileId;
    private int dataSize;
    private byte[] byteArray;
    private SimpleString pageStoreName;
    private FileType fileType;
    private RandomAccessFile raf;
    private FileChannel fileChannel;
    private long offset;

    public ReplicationSyncFileMessage() {
        super((byte)103);
    }

    public ReplicationSyncFileMessage(AbstractJournalStorageManager.JournalContent content, SimpleString storeName, long id, RandomAccessFile raf, FileChannel fileChannel, long offset, int size) {
        this();
        this.pageStoreName = storeName;
        this.dataSize = size;
        this.fileId = id;
        this.raf = raf;
        this.fileChannel = fileChannel;
        this.journalType = content;
        this.offset = offset;
        this.determineType();
    }

    private void determineType() {
        this.fileType = this.journalType != null ? FileType.JOURNAL : (this.pageStoreName != null ? FileType.PAGE : FileType.LARGE_MESSAGE);
    }

    public long getFileId() {
        return this.fileId;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public RandomAccessFile getRaf() {
        return this.raf;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public long getOffset() {
        return this.offset;
    }

    public int expectedEncodeSize() {
        int size = 21;
        if (this.fileId == -1L) {
            return size;
        }
        ++size;
        switch (this.fileType) {
            case JOURNAL: {
                ++size;
                break;
            }
            case PAGE: {
                size += SimpleString.sizeofString((SimpleString)this.pageStoreName);
                break;
            }
        }
        size += 4;
        if (this.dataSize > 0) {
            size += this.dataSize;
        }
        return size;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.fileId);
        if (this.fileId == -1L) {
            return;
        }
        buffer.writeByte(this.fileType.code);
        switch (this.fileType) {
            case JOURNAL: {
                buffer.writeByte(this.journalType.typeByte);
                break;
            }
            case PAGE: {
                buffer.writeSimpleString(this.pageStoreName);
                break;
            }
        }
        buffer.writeInt(this.dataSize);
    }

    public ActiveMQBuffer encode(CoreRemotingConnection connection) {
        if (this.fileId != -1L && this.dataSize > 0) {
            int bufferSize;
            int encodedSize = bufferSize = this.expectedEncodeSize();
            boolean isNetty = false;
            if (connection != null && connection.getTransportConnection() instanceof NettyConnection) {
                bufferSize -= this.dataSize;
                isNetty = true;
            }
            ActiveMQBuffer buffer = this.createPacket(connection, bufferSize);
            this.encodeHeader(buffer);
            this.encodeRest(buffer, connection);
            if (!isNetty) {
                ByteBuffer byteBuffer = buffer.byteBuf() != null && buffer.byteBuf().nioBufferCount() == 1 ? buffer.byteBuf().internalNioBuffer(buffer.writerIndex(), buffer.writableBytes()) : buffer.toByteBuffer(buffer.writerIndex(), buffer.writableBytes());
                this.readFile(byteBuffer);
                buffer.writerIndex(buffer.capacity());
            }
            this.encodeSize(buffer, encodedSize);
            return buffer;
        }
        return super.encode(connection);
    }

    public void release() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                logger.error((Object)("Close file " + (Object)((Object)this) + " failed"), (Throwable)e);
            }
        }
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.fileId = buffer.readLong();
        if (this.fileId == -1L) {
            return;
        }
        switch (FileType.getFileType(buffer.readByte())) {
            case JOURNAL: {
                this.journalType = AbstractJournalStorageManager.JournalContent.getType(buffer.readByte());
                this.fileType = FileType.JOURNAL;
                break;
            }
            case PAGE: {
                this.pageStoreName = buffer.readSimpleString();
                this.fileType = FileType.PAGE;
                break;
            }
            case LARGE_MESSAGE: {
                this.fileType = FileType.LARGE_MESSAGE;
            }
        }
        int size = buffer.readInt();
        if (size > 0) {
            this.byteArray = new byte[size];
            buffer.readBytes(this.byteArray);
        }
    }

    private void readFile(ByteBuffer buffer) {
        try {
            this.fileChannel.read(buffer, this.offset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getId() {
        return this.fileId;
    }

    public AbstractJournalStorageManager.JournalContent getJournalContent() {
        return this.journalType;
    }

    public byte[] getData() {
        return this.byteArray;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public SimpleString getPageStore() {
        return this.pageStoreName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationSyncFileMessage that = (ReplicationSyncFileMessage)((Object)o);
        return this.fileId == that.fileId && this.dataSize == that.dataSize && this.offset == that.offset && this.journalType == that.journalType && Arrays.equals(this.byteArray, that.byteArray) && Objects.equals(this.pageStoreName, that.pageStoreName) && this.fileType == that.fileType && Objects.equals(this.raf, that.raf) && Objects.equals(this.fileChannel, that.fileChannel);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.journalType, this.fileId, this.dataSize, this.pageStoreName, this.fileType, this.raf, this.fileChannel, this.offset});
        result = 31 * result + Arrays.hashCode(this.byteArray);
        return result;
    }

    public String toString() {
        return ReplicationSyncFileMessage.class.getSimpleName() + "(" + (Object)((Object)this.fileType) + (this.journalType != null ? ", " + (Object)((Object)this.journalType) : "") + ", id=" + this.fileId + ")";
    }

    public static enum FileType {
        JOURNAL(0),
        PAGE(1),
        LARGE_MESSAGE(2);

        private byte code;
        private static final Set<FileType> ALL_OF;

        private FileType(int code) {
            this.code = (byte)code;
        }

        public static FileType getFileType(byte readByte) {
            for (FileType type : ALL_OF) {
                if (type.code != readByte) continue;
                return type;
            }
            throw new InternalError("Unsupported byte value for " + FileType.class);
        }

        static {
            ALL_OF = EnumSet.allOf(FileType.class);
        }
    }
}

