/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.server;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.utils.ReusableLatch;

public interface RemotingService {
    public RemotingConnection removeConnection(Object var1);

    public Set<RemotingConnection> getConnections();

    default public int getConnectionCount() {
        Set<RemotingConnection> connections = this.getConnections();
        return connections == null ? 0 : this.getConnections().size();
    }

    public long getTotalConnectionCount();

    public ReusableLatch getConnectionCountLatch();

    public void addIncomingInterceptor(BaseInterceptor var1);

    public List<BaseInterceptor> getIncomingInterceptors();

    public void addOutgoingInterceptor(BaseInterceptor var1);

    public List<BaseInterceptor> getOutgoinInterceptors();

    public boolean removeIncomingInterceptor(BaseInterceptor var1);

    public boolean removeOutgoingInterceptor(BaseInterceptor var1);

    public void stop(boolean var1) throws Exception;

    public void start() throws Exception;

    public void startAcceptors() throws Exception;

    public boolean isStarted();

    public Map<String, ProtocolManagerFactory> getProtocolFactoryMap();

    public void allowInvmSecurityOverride(ActiveMQPrincipal var1);

    public void pauseAcceptors();

    public boolean isPaused();

    public void freeze(String var1, CoreRemotingConnection var2);

    public Acceptor getAcceptor(String var1);

    public Acceptor createAcceptor(String var1, String var2) throws Exception;

    public Acceptor createAcceptor(TransportConfiguration var1);

    public void destroyAcceptor(String var1) throws Exception;
}

