/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation.address;

import java.util.HashMap;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.commons.lang3.text.StrSubstitutor;

public class FederatedAddressConsumerKey
implements FederatedConsumerKey {
    private final SimpleString federation;
    private final SimpleString upstream;
    private final SimpleString address;
    private final SimpleString queueNameFormat;
    private final RoutingType routingType;
    private final SimpleString queueFilterString;
    private SimpleString fqqn;
    private SimpleString queueName;

    FederatedAddressConsumerKey(SimpleString federation, SimpleString upstream, SimpleString address, RoutingType routingType, SimpleString queueNameFormat, SimpleString queueFilterString) {
        this.federation = federation;
        this.upstream = upstream;
        this.address = address;
        this.routingType = routingType;
        this.queueNameFormat = queueNameFormat;
        this.queueFilterString = queueFilterString;
    }

    @Override
    public SimpleString getQueueName() {
        if (this.queueName == null) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("address", this.address.toString());
            data.put("routeType", this.routingType.name().toLowerCase());
            data.put("upstream", this.upstream.toString());
            data.put("federation", this.federation.toString());
            this.queueName = SimpleString.of((String)StrSubstitutor.replace((Object)this.queueNameFormat, data));
        }
        return this.queueName;
    }

    @Override
    public SimpleString getQueueFilterString() {
        return this.queueFilterString;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public SimpleString getFqqn() {
        if (this.fqqn == null) {
            this.fqqn = CompositeAddress.toFullyQualified((SimpleString)this.getAddress(), (SimpleString)this.getQueueName());
        }
        return this.fqqn;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public SimpleString getFilterString() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederatedAddressConsumerKey)) {
            return false;
        }
        FederatedAddressConsumerKey that = (FederatedAddressConsumerKey)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.queueNameFormat, that.queueNameFormat) && this.routingType == that.routingType && Objects.equals(this.queueFilterString, that.queueFilterString);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.queueNameFormat, this.routingType, this.queueFilterString);
    }
}

