/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.security.cert.X509Certificate;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.Closeable;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.exception.ActiveMQXAException;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.TempQueueObserver;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.PrefixUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class ServerSessionImpl
implements ServerSession,
FailureListener {
    private static final Logger logger = Logger.getLogger(ServerSessionImpl.class);
    private boolean securityEnabled = true;
    protected final String username;
    protected final String password;
    protected final String validatedUser;
    private final int minLargeMessageSize;
    protected boolean autoCommitSends;
    protected boolean autoCommitAcks;
    protected final boolean preAcknowledge;
    protected final boolean strictUpdateDeliveryCount;
    protected final RemotingConnection remotingConnection;
    protected final Map<Long, ServerConsumer> consumers = new ConcurrentHashMap<Long, ServerConsumer>();
    protected final Map<String, ServerProducer> producers = new ConcurrentHashMap<String, ServerProducer>();
    protected Transaction tx;
    protected boolean xa;
    protected final PagingManager pagingManager;
    protected final StorageManager storageManager;
    private final ResourceManager resourceManager;
    public final PostOffice postOffice;
    private final SecurityStore securityStore;
    protected final ManagementService managementService;
    protected volatile boolean started = false;
    protected final Map<SimpleString, TempQueueCleanerUpper> tempQueueCleannerUppers = new HashMap<SimpleString, TempQueueCleanerUpper>();
    protected final String name;
    protected final ActiveMQServer server;
    private final SimpleString managementAddress;
    protected final RoutingContext routingContext = new RoutingContextImpl(null);
    protected final SessionCallback callback;
    private volatile SimpleString defaultAddress;
    private volatile int timeoutSeconds;
    private Map<String, String> metaData;
    private final OperationContext context;
    protected final Map<SimpleString, Pair<Object, AtomicLong>> targetAddressInfos = new HashMap<SimpleString, Pair<Object, AtomicLong>>();
    private final long creationTime = System.currentTimeMillis();
    private volatile boolean closed = false;
    private boolean prefixEnabled = false;
    private Map<SimpleString, RoutingType> prefixes;
    private Set<Closeable> closeables;
    private final Executor sessionExecutor;

    public ServerSessionImpl(String name, String username, String password, String validatedUser, int minLargeMessageSize, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean strictUpdateDeliveryCount, boolean xa, RemotingConnection remotingConnection, StorageManager storageManager, PostOffice postOffice, ResourceManager resourceManager, SecurityStore securityStore, ManagementService managementService, ActiveMQServer server, SimpleString managementAddress, SimpleString defaultAddress, SessionCallback callback, OperationContext context, PagingManager pagingManager, Map<SimpleString, RoutingType> prefixes) throws Exception {
        this.username = username;
        this.password = password;
        this.validatedUser = validatedUser;
        this.minLargeMessageSize = minLargeMessageSize;
        this.autoCommitSends = autoCommitSends;
        this.autoCommitAcks = autoCommitAcks;
        this.preAcknowledge = preAcknowledge;
        this.remotingConnection = remotingConnection;
        this.storageManager = storageManager;
        this.postOffice = postOffice;
        this.resourceManager = resourceManager;
        this.securityStore = securityStore;
        this.pagingManager = pagingManager;
        this.timeoutSeconds = resourceManager.getTimeoutSeconds();
        this.xa = xa;
        this.strictUpdateDeliveryCount = strictUpdateDeliveryCount;
        this.managementService = managementService;
        this.name = name;
        this.server = server;
        this.prefixes = prefixes;
        if (this.prefixes != null && !this.prefixes.isEmpty()) {
            this.prefixEnabled = true;
        }
        this.managementAddress = managementAddress;
        this.callback = callback;
        this.defaultAddress = defaultAddress;
        remotingConnection.addFailureListener((FailureListener)this);
        this.context = context;
        this.sessionExecutor = server.getExecutorFactory().getExecutor();
        if (!xa) {
            this.tx = this.newTransaction();
        }
        this.sendSessionNotification(CoreNotificationType.SESSION_CREATED);
    }

    @Override
    public void enableSecurity() {
        this.securityEnabled = true;
    }

    @Override
    public void addCloseable(Closeable closeable) {
        if (this.closeables == null) {
            this.closeables = new HashSet<Closeable>();
        }
        this.closeables.add(closeable);
    }

    @Override
    public Executor getSessionExecutor() {
        return this.sessionExecutor;
    }

    @Override
    public void disableSecurity() {
        this.securityEnabled = false;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public OperationContext getSessionContext() {
        return this.context;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getConnectionID() {
        return this.remotingConnection.getID();
    }

    @Override
    public Set<ServerConsumer> getServerConsumers() {
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        return Collections.unmodifiableSet(consumersClone);
    }

    @Override
    public void markTXFailed(Throwable e) {
        Transaction currentTX = this.tx;
        if (currentTX != null) {
            if (e instanceof ActiveMQException) {
                currentTX.markAsRollbackOnly((ActiveMQException)e);
            } else {
                ActiveMQException exception = new ActiveMQException(e.getMessage());
                exception.initCause(e);
                currentTX.markAsRollbackOnly(exception);
            }
        }
    }

    @Override
    public boolean removeConsumer(long consumerID) throws Exception {
        return this.consumers.remove(consumerID) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose(boolean failed) throws Exception {
        if (this.callback != null) {
            this.callback.close(failed);
        }
        ServerSessionImpl serverSessionImpl = this;
        synchronized (serverSessionImpl) {
            if (!this.closed && this.server.hasBrokerSessionPlugins()) {
                this.server.callBrokerSessionPlugins(plugin -> plugin.beforeCloseSession(this, failed));
            }
            this.setStarted(false);
            if (this.closed) {
                return;
            }
            if (this.tx != null && this.tx.getXid() == null) {
                try {
                    this.rollback(failed, false);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToRollbackOnClose(e);
                }
            }
        }
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        for (ServerConsumer consumer : consumersClone) {
            try {
                consumer.close(failed);
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.unableToCloseConsumer(e);
                try {
                    consumer.removeItself();
                }
                catch (Throwable e2) {
                    ActiveMQServerLogger.LOGGER.unableToRemoveConsumer(e2);
                }
            }
        }
        this.consumers.clear();
        this.producers.clear();
        if (this.closeables != null) {
            for (Closeable closeable : this.closeables) {
                closeable.close(failed);
            }
        }
        Iterator<Closeable> iterator = this;
        synchronized (iterator) {
            this.server.removeSession(this.name);
            this.remotingConnection.removeFailureListener((FailureListener)this);
            if (this.callback != null) {
                this.callback.closed();
            }
            this.closed = true;
            this.sendSessionNotification(CoreNotificationType.SESSION_CLOSED);
            if (this.server.hasBrokerSessionPlugins()) {
                this.server.callBrokerSessionPlugins(plugin -> plugin.afterCloseSession(this, failed));
            }
        }
    }

    private void sendSessionNotification(CoreNotificationType type) throws Exception {
        TypedProperties props = new TypedProperties();
        if (this.getConnectionID() != null) {
            props.putSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME, SimpleString.toSimpleString((String)this.getConnectionID().toString()));
        }
        props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)this.getUsername()));
        props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)this.getName()));
        props.putSimpleStringProperty(ManagementHelper.HDR_CLIENT_ID, SimpleString.toSimpleString((String)this.remotingConnection.getClientID()));
        props.putSimpleStringProperty(ManagementHelper.HDR_PROTOCOL_NAME, SimpleString.toSimpleString((String)this.remotingConnection.getProtocolName()));
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.managementService.getManagementNotificationAddress());
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, 0);
        this.managementService.sendNotification(new Notification(null, (NotificationType)type, props));
    }

    private void securityCheck(SimpleString address, CheckType checkType, SecurityAuth auth) throws Exception {
        if (this.securityEnabled) {
            this.securityStore.check(address, checkType, auth);
        }
    }

    private void securityCheck(SimpleString address, SimpleString queue, CheckType checkType, SecurityAuth auth) throws Exception {
        if (this.securityEnabled) {
            this.securityStore.check(address, queue, checkType, auth);
        }
    }

    @Override
    public ServerConsumer createConsumer(long consumerID, SimpleString queueName, SimpleString filterString, boolean browseOnly) throws Exception {
        return this.createConsumer(consumerID, queueName, filterString, browseOnly, true, null);
    }

    @Override
    public ServerConsumer createConsumer(long consumerID, SimpleString queueName, SimpleString filterString, boolean browseOnly, boolean supportLargeMessage, Integer credits) throws Exception {
        return this.createConsumer(consumerID, queueName, filterString, ActiveMQDefaultConfiguration.getDefaultConsumerPriority(), browseOnly, supportLargeMessage, credits);
    }

    @Override
    public ServerConsumer createConsumer(long consumerID, SimpleString queueName, SimpleString filterString, int priority, boolean browseOnly, boolean supportLargeMessage, Integer credits) throws Exception {
        SimpleString unPrefixedQueueName;
        Binding binding;
        if (AuditLogger.isEnabled()) {
            AuditLogger.createCoreConsumer((Object)this, (String)this.getUsername(), (Object[])new Object[]{consumerID, queueName, filterString, priority, browseOnly, supportLargeMessage, credits});
        }
        if ((binding = this.postOffice.getBinding(unPrefixedQueueName = this.removePrefix(queueName))) == null || binding.getType() != BindingType.LOCAL_QUEUE) {
            throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(unPrefixedQueueName);
        }
        SimpleString address = this.removePrefix(binding.getAddress());
        if (browseOnly) {
            try {
                this.securityCheck(address, queueName, CheckType.BROWSE, this);
            }
            catch (Exception e) {
                this.securityCheck(address.concat(".").concat(unPrefixedQueueName), queueName, CheckType.BROWSE, this);
            }
        } else {
            try {
                this.securityCheck(address, queueName, CheckType.CONSUME, this);
            }
            catch (Exception e) {
                this.securityCheck(address.concat(".").concat(unPrefixedQueueName), queueName, CheckType.CONSUME, this);
            }
        }
        Filter filter = FilterImpl.createFilter(filterString);
        if (this.server.hasBrokerConsumerPlugins()) {
            this.server.callBrokerConsumerPlugins(plugin -> plugin.beforeCreateConsumer(consumerID, (QueueBinding)binding, filterString, browseOnly, supportLargeMessage));
        }
        ServerConsumerImpl consumer = new ServerConsumerImpl(consumerID, this, (QueueBinding)binding, filter, priority, this.started, browseOnly, this.storageManager, this.callback, this.preAcknowledge, this.strictUpdateDeliveryCount, this.managementService, supportLargeMessage, credits, this.server);
        this.consumers.put(consumer.getID(), consumer);
        if (this.server.hasBrokerConsumerPlugins()) {
            this.server.callBrokerConsumerPlugins(plugin -> plugin.afterCreateConsumer(consumer));
        }
        if (!browseOnly) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, address);
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
            Queue theQueue = (Queue)binding.getBindable();
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, theQueue.getConsumerCount());
            props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)this.username));
            props.putSimpleStringProperty(ManagementHelper.HDR_VALIDATED_USER, SimpleString.toSimpleString((String)this.validatedUser));
            String certSubjectDN = "unavailable";
            X509Certificate[] certs = CertificateUtil.getCertsFromConnection((RemotingConnection)this.remotingConnection);
            if (certs != null && certs.length > 0 && certs[0] != null) {
                certSubjectDN = certs[0].getSubjectDN().getName();
            }
            props.putSimpleStringProperty(ManagementHelper.HDR_CERT_SUBJECT_DN, SimpleString.toSimpleString((String)certSubjectDN));
            props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)this.remotingConnection.getRemoteAddress()));
            props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)this.name));
            if (filterString != null) {
                props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
            }
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_CREATED, props);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Session with user=" + this.username + ", connection=" + this.remotingConnection + " created a consumer on queue " + unPrefixedQueueName + ", filter = " + filterString));
            }
            this.managementService.sendNotification(notification);
        }
        return consumer;
    }

    @Override
    public void resetTX(Transaction transaction) {
        this.tx = transaction;
        this.autoCommitAcks = transaction == null;
        this.autoCommitSends = transaction == null;
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString name, SimpleString filterString, boolean temporary, boolean durable) throws Exception {
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(address.toString());
        return this.createQueue(address, name, as.getDefaultQueueRoutingType(), filterString, temporary, durable, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), false);
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString name, RoutingType routingType, SimpleString filterString, boolean temporary, boolean durable) throws Exception {
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(address.toString());
        return this.createQueue(address, name, routingType, filterString, temporary, durable, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), false);
    }

    @Override
    public Queue createQueue(AddressInfo addressInfo, SimpleString name, SimpleString filterString, boolean temporary, boolean durable) throws Exception {
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(addressInfo.getName().toString());
        return this.createQueue(addressInfo, name, filterString, temporary, durable, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), as.isDefaultExclusiveQueue(), as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), as.isDefaultLastValueQueue(), as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), as.isAutoDeleteQueues(), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), false);
    }

    public Queue createQueue(AddressInfo addressInfo, SimpleString name, SimpleString filterString, boolean temporary, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreated) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.createQueue((Object)this, (String)this.getUsername(), (Object[])new Object[]{addressInfo, name, filterString, temporary, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreated});
        }
        SimpleString unPrefixedName = this.removePrefix(name);
        AddressInfo art = this.getAddressAndRoutingType(addressInfo);
        if (durable) {
            this.securityCheck(addressInfo.getName(), name, CheckType.CREATE_DURABLE_QUEUE, this);
        } else {
            this.securityCheck(addressInfo.getName(), name, CheckType.CREATE_NON_DURABLE_QUEUE, this);
        }
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(art.getName().toString());
        if (as.isAutoCreateAddresses() && this.server.getAddressInfo(art.getName()) == null) {
            this.securityCheck(addressInfo.getName(), name, CheckType.CREATE_ADDRESS, this);
        }
        this.server.checkQueueCreationLimit(this.getUsername());
        Queue queue = this.server.createQueue(art, unPrefixedName, filterString, SimpleString.toSimpleString((String)this.getUsername()), durable, temporary, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, as.isAutoCreateAddresses());
        if (temporary) {
            TempQueueCleanerUpper cleaner = new TempQueueCleanerUpper(this.server, unPrefixedName);
            if (this.remotingConnection instanceof TempQueueObserver) {
                cleaner.setObserver((TempQueueObserver)this.remotingConnection);
            }
            this.remotingConnection.addCloseListener((CloseListener)cleaner);
            this.remotingConnection.addFailureListener((FailureListener)cleaner);
            this.tempQueueCleannerUppers.put(unPrefixedName, cleaner);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Queue " + unPrefixedName + " created on address " + addressInfo.getName() + " with filter=" + filterString + " temporary = " + temporary + " durable=" + durable + " on session user=" + this.username + ", connection=" + this.remotingConnection));
        }
        return queue;
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString name, RoutingType routingType, SimpleString filterString, boolean temporary, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean autoCreated) throws Exception {
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(address.toString());
        return this.createQueue(new AddressInfo(address, routingType), name, filterString, temporary, durable, maxConsumers, purgeOnNoConsumers, as.isDefaultExclusiveQueue(), as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), as.isDefaultLastValueQueue(), as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), as.isAutoDeleteQueues(), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreated);
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString name, RoutingType routingType, SimpleString filterString, boolean temporary, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue, boolean autoCreated) throws Exception {
        return this.createQueue(address, name, routingType, filterString, temporary, durable, maxConsumers, purgeOnNoConsumers, exclusive, null, null, lastValue, null, null, null, null, null, null, null, autoCreated);
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString name, RoutingType routingType, SimpleString filterString, boolean temporary, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean autoCreated) throws Exception {
        if (exclusive == null || groupRebalance == null || groupBuckets == null || lastValue == null || lastValueKey == null || nonDestructive == null || consumersBeforeDispatch == null || delayBeforeDispatch == null || autoDelete == null || autoDeleteDelay == null || autoDeleteMessageCount == null) {
            AddressSettings as = this.server.getAddressSettingsRepository().getMatch(address.toString());
            return this.createQueue(new AddressInfo(address, routingType), name, filterString, temporary, durable, maxConsumers, purgeOnNoConsumers, exclusive == null ? as.isDefaultExclusiveQueue() : exclusive.booleanValue(), groupRebalance == null ? as.isDefaultGroupRebalance() : groupRebalance.booleanValue(), groupBuckets == null ? as.getDefaultGroupBuckets() : groupBuckets.intValue(), lastValue == null ? as.isDefaultLastValueQueue() : lastValue.booleanValue(), lastValueKey == null ? as.getDefaultLastValueKey() : lastValueKey, nonDestructive == null ? as.isDefaultNonDestructive() : nonDestructive.booleanValue(), consumersBeforeDispatch == null ? as.getDefaultConsumersBeforeDispatch() : consumersBeforeDispatch.intValue(), delayBeforeDispatch == null ? as.getDefaultDelayBeforeDispatch() : delayBeforeDispatch.longValue(), autoDelete == null ? as.isAutoDeleteQueues() : autoDelete.booleanValue(), autoDeleteDelay == null ? as.getAutoDeleteQueuesDelay() : autoDeleteDelay.longValue(), autoDeleteMessageCount == null ? as.getAutoDeleteQueuesMessageCount() : autoDeleteMessageCount.longValue(), autoCreated);
        }
        return this.createQueue(new AddressInfo(address, routingType), name, filterString, temporary, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreated);
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString name, RoutingType routingType, SimpleString filterString, boolean temporary, boolean durable, boolean autoCreated) throws Exception {
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(address.toString());
        return this.createQueue(address, name, routingType, filterString, temporary, durable, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), autoCreated);
    }

    @Override
    public Queue createQueue(AddressInfo addressInfo, SimpleString name, SimpleString filterString, boolean temporary, boolean durable, boolean autoCreated) throws Exception {
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(addressInfo.getName().toString());
        return this.createQueue(addressInfo, name, filterString, temporary, durable, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), as.isDefaultExclusiveQueue(), as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), as.isDefaultLastValueQueue(), as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), as.isAutoDeleteQueues(), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreated);
    }

    @Override
    public Queue createQueue(AddressInfo addressInfo, SimpleString name, SimpleString filterString, boolean temporary, boolean durable, Boolean exclusive, Boolean lastValue, boolean autoCreated) throws Exception {
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(addressInfo.getName().toString());
        return this.createQueue(addressInfo, name, filterString, temporary, durable, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), exclusive == null ? as.isDefaultExclusiveQueue() : exclusive.booleanValue(), as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), lastValue == null ? as.isDefaultLastValueQueue() : lastValue.booleanValue(), as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), as.isAutoDeleteQueues(), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreated);
    }

    @Override
    public AddressInfo createAddress(SimpleString address, EnumSet<RoutingType> routingTypes, boolean autoCreated) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.serverSessionCreateAddress((Object)this.getName(), (String)this.getUsername(), (Object[])new Object[]{address, routingTypes, autoCreated});
        }
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        Pair<SimpleString, EnumSet<RoutingType>> art = this.getAddressAndRoutingTypes(realAddress, routingTypes);
        this.securityCheck((SimpleString)art.getA(), CheckType.CREATE_ADDRESS, this);
        this.server.addOrUpdateAddressInfo(new AddressInfo((SimpleString)art.getA(), (EnumSet)art.getB()).setAutoCreated(autoCreated));
        return this.server.getAddressInfo((SimpleString)art.getA());
    }

    @Override
    public AddressInfo createAddress(SimpleString address, RoutingType routingType, boolean autoCreated) throws Exception {
        return this.createAddress(new AddressInfo(address, routingType), autoCreated);
    }

    @Override
    public AddressInfo createAddress(AddressInfo addressInfo, boolean autoCreated) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.serverSessionCreateAddress((Object)this.getName(), (String)this.getUsername(), (Object[])new Object[]{addressInfo, autoCreated});
        }
        AddressInfo art = this.getAddressAndRoutingType(addressInfo);
        this.securityCheck(art.getName(), CheckType.CREATE_ADDRESS, this);
        this.server.addOrUpdateAddressInfo(art.setAutoCreated(autoCreated));
        return this.server.getAddressInfo(art.getName());
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString name, RoutingType routingType, SimpleString filterString, boolean durable, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue) throws Exception {
        this.createSharedQueue(address, name, routingType, filterString, durable, maxConsumers, purgeOnNoConsumers, exclusive, null, null, lastValue, null, null, null, null, null, null, null);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString name, RoutingType routingType, SimpleString filterString, boolean durable, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.createSharedQueue((Object)this, (String)this.getUsername(), (Object[])new Object[]{address, name, routingType, filterString, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount});
        }
        address = this.removePrefix(address);
        this.securityCheck(address, name, durable ? CheckType.CREATE_DURABLE_QUEUE : CheckType.CREATE_NON_DURABLE_QUEUE, this);
        this.server.checkQueueCreationLimit(this.getUsername());
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(address.toString());
        this.server.createSharedQueue(address, routingType, name, filterString, SimpleString.toSimpleString((String)this.getUsername()), durable, maxConsumers == null ? as.getDefaultMaxConsumers() : maxConsumers.intValue(), purgeOnNoConsumers == null ? as.isDefaultPurgeOnNoConsumers() : purgeOnNoConsumers.booleanValue(), exclusive == null ? as.isDefaultExclusiveQueue() : exclusive.booleanValue(), groupRebalance == null ? as.isDefaultGroupRebalance() : groupRebalance.booleanValue(), groupBuckets == null ? as.getDefaultGroupBuckets() : groupBuckets.intValue(), lastValue == null ? as.isDefaultLastValueQueue() : lastValue.booleanValue(), lastValueKey == null ? as.getDefaultLastValueKey() : lastValueKey, nonDestructive == null ? as.isDefaultNonDestructive() : nonDestructive.booleanValue(), consumersBeforeDispatch == null ? as.getDefaultConsumersBeforeDispatch() : consumersBeforeDispatch.intValue(), delayBeforeDispatch == null ? as.getDefaultDelayBeforeDispatch() : delayBeforeDispatch.longValue(), autoDelete == null ? as.isAutoDeleteQueues() : autoDelete.booleanValue(), autoDeleteDelay == null ? as.getAutoDeleteQueuesDelay() : delayBeforeDispatch.longValue(), autoDeleteMessageCount == null ? as.getAutoDeleteQueuesMessageCount() : autoDeleteMessageCount.longValue());
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString name, RoutingType routingType, boolean durable, SimpleString filterString) throws Exception {
        this.createSharedQueue(address, name, routingType, filterString, durable, null, null, null, null);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString name, boolean durable, SimpleString filterString) throws Exception {
        this.createSharedQueue(address, name, null, durable, filterString);
    }

    @Override
    public RemotingConnection getRemotingConnection() {
        return this.remotingConnection;
    }

    @Override
    public void deleteQueue(SimpleString queueToDelete) throws Exception {
        SimpleString unPrefixedQueueName;
        Binding binding;
        if (AuditLogger.isEnabled()) {
            AuditLogger.destroyQueue((Object)this, (String)this.getUsername(), (Object[])new Object[]{queueToDelete});
        }
        if ((binding = this.postOffice.getBinding(unPrefixedQueueName = this.removePrefix(queueToDelete))) == null || binding.getType() != BindingType.LOCAL_QUEUE) {
            throw new ActiveMQNonExistentQueueException();
        }
        this.server.destroyQueue(unPrefixedQueueName, this, true);
        TempQueueCleanerUpper cleaner = this.tempQueueCleannerUppers.remove(unPrefixedQueueName);
        if (cleaner != null) {
            this.remotingConnection.removeCloseListener((CloseListener)cleaner);
            this.remotingConnection.removeFailureListener((FailureListener)cleaner);
        }
    }

    @Override
    public QueueQueryResult executeQueueQuery(SimpleString name) throws Exception {
        return this.server.queueQuery(this.removePrefix(name));
    }

    @Override
    public AddressQueryResult executeAddressQuery(SimpleString name) throws Exception {
        return this.server.addressQuery(this.removePrefix(name));
    }

    @Override
    public BindingQueryResult executeBindingQuery(SimpleString address) throws Exception {
        return this.server.bindingQuery(this.removePrefix(address));
    }

    @Override
    public void forceConsumerDelivery(long consumerID, long sequence) throws Exception {
        ServerConsumer consumer = this.locateConsumer(consumerID);
        if (consumer != null) {
            consumer.forceDelivery(sequence);
        }
    }

    @Override
    public void acknowledge(long consumerID, long messageID) throws Exception {
        ServerConsumer consumer = this.findConsumer(consumerID);
        if (this.tx != null && this.tx.getState() == Transaction.State.ROLLEDBACK) {
            Transaction newTX = this.newTransaction();
            try {
                consumer.acknowledge(newTX, messageID);
            }
            catch (Exception e) {
                logger.debug((Object)("Ignored exception while acking messageID " + messageID + " on a rolledback TX"), (Throwable)e);
            }
            newTX.rollback();
        } else {
            consumer.acknowledge(this.autoCommitAcks ? null : this.tx, messageID);
        }
    }

    @Override
    public ServerConsumer locateConsumer(long consumerID) {
        return this.consumers.get(consumerID);
    }

    private ServerConsumer findConsumer(long consumerID) throws Exception {
        ServerConsumer consumer = this.locateConsumer(consumerID);
        if (consumer == null) {
            Transaction currentTX = this.tx;
            ActiveMQIllegalStateException exception = ActiveMQMessageBundle.BUNDLE.consumerDoesntExist(consumerID);
            if (currentTX != null) {
                currentTX.markAsRollbackOnly((ActiveMQException)exception);
            }
            throw exception;
        }
        return consumer;
    }

    @Override
    public void individualAcknowledge(long consumerID, long messageID) throws Exception {
        ServerConsumer consumer = this.findConsumer(consumerID);
        if (this.tx != null && this.tx.getState() == Transaction.State.ROLLEDBACK) {
            Transaction newTX = this.newTransaction();
            consumer.individualAcknowledge(this.tx, messageID);
            newTX.rollback();
        } else {
            consumer.individualAcknowledge(this.autoCommitAcks ? null : this.tx, messageID);
        }
    }

    @Override
    public void individualCancel(long consumerID, long messageID, boolean failed) throws Exception {
        ServerConsumer consumer = this.locateConsumer(consumerID);
        if (consumer != null) {
            consumer.individualCancel(messageID, failed);
        }
    }

    @Override
    public void expire(long consumerID, long messageID) throws Exception {
        ServerConsumer consumer = this.locateConsumer(consumerID);
        MessageReference ref = consumer.removeReferenceByID(messageID);
        if (ref != null) {
            ref.getQueue().expire(ref, consumer);
        }
    }

    @Override
    public synchronized void commit() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Calling commit");
        }
        try {
            if (this.tx != null) {
                this.tx.commit();
            }
        }
        finally {
            this.tx = this.xa ? null : this.newTransaction();
        }
    }

    @Override
    public void rollback(boolean considerLastMessageAsDelivered) throws Exception {
        this.rollback(false, considerLastMessageAsDelivered);
    }

    private synchronized void rollback(boolean clientFailed, boolean considerLastMessageAsDelivered) throws Exception {
        if (this.tx == null) {
            this.tx = this.newTransaction();
        }
        this.doRollback(clientFailed, considerLastMessageAsDelivered, this.tx);
        this.tx = this.xa ? null : this.newTransaction();
    }

    @Override
    public Transaction newTransaction() {
        return new TransactionImpl(null, this.storageManager, this.timeoutSeconds);
    }

    private Transaction newTransaction(Xid xid) {
        return new TransactionImpl(xid, this.storageManager, this.timeoutSeconds);
    }

    @Override
    public synchronized void xaCommit(Xid xid, boolean onePhase) throws Exception {
        if (this.tx != null && this.tx.getXid().equals(xid)) {
            String msg = "Cannot commit, session is currently doing work in transaction " + this.tx.getXid();
            throw new ActiveMQXAException(-6, msg);
        }
        Transaction theTx = this.resourceManager.removeTransaction(xid);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("XAcommit into " + theTx + ", xid=" + xid));
        }
        if (theTx == null) {
            if (this.resourceManager.getHeuristicCommittedTransactions().contains(xid)) {
                throw new ActiveMQXAException(7, "transaction has been heuristically committed: " + xid);
            }
            if (this.resourceManager.getHeuristicRolledbackTransactions().contains(xid)) {
                throw new ActiveMQXAException(6, "transaction has been heuristically rolled back: " + xid);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("XAcommit into " + theTx + ", xid=" + xid + " cannot find it"));
            }
            throw new ActiveMQXAException(-4, "Cannot find xid in resource manager: " + xid);
        }
        if (theTx.getState() == Transaction.State.SUSPENDED) {
            this.resourceManager.putTransaction(xid, theTx);
            throw new ActiveMQXAException(-6, "Cannot commit transaction, it is suspended " + xid);
        }
        theTx.commit(onePhase);
    }

    @Override
    public synchronized void xaEnd(Xid xid) throws Exception {
        if (this.tx != null && this.tx.getXid().equals(xid)) {
            if (this.tx.getState() == Transaction.State.SUSPENDED) {
                String msg = "Cannot end, transaction is suspended";
                throw new ActiveMQXAException(-6, "Cannot end, transaction is suspended");
            }
            if (this.tx.getState() == Transaction.State.ROLLEDBACK) {
                String msg = "Cannot end, transaction is rolled back";
                boolean timeout = this.tx.hasTimedOut();
                this.tx = null;
                if (timeout) {
                    throw new ActiveMQXAException(106, "Cannot end, transaction is rolled back");
                }
                throw new ActiveMQXAException(-6, "Cannot end, transaction is rolled back");
            }
            this.tx = null;
        } else {
            Transaction theTx = this.resourceManager.getTransaction(xid);
            if (theTx == null) {
                String msg = "Cannot find suspended transaction to end " + xid;
                throw new ActiveMQXAException(-4, msg);
            }
            if (theTx.getState() != Transaction.State.SUSPENDED) {
                String msg = "Transaction is not suspended " + xid;
                throw new ActiveMQXAException(-6, msg);
            }
            theTx.resume();
        }
    }

    @Override
    public synchronized void xaForget(Xid xid) throws Exception {
        long id = this.resourceManager.removeHeuristicCompletion(xid);
        if (id != -1L) {
            try {
                this.storageManager.deleteHeuristicCompletion(id);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToDeleteHeuristicCompletion(e);
                throw new ActiveMQXAException(-7);
            }
        } else {
            throw new ActiveMQXAException(-4);
        }
    }

    @Override
    public synchronized void xaJoin(Xid xid) throws Exception {
        Transaction theTx = this.resourceManager.getTransaction(xid);
        if (theTx == null) {
            String msg = "Cannot find xid in resource manager: " + xid;
            throw new ActiveMQXAException(-4, msg);
        }
        if (theTx.getState() == Transaction.State.SUSPENDED) {
            throw new ActiveMQXAException(-6, "Cannot join tx, it is suspended " + xid);
        }
        this.tx = theTx;
    }

    @Override
    public synchronized void xaResume(Xid xid) throws Exception {
        if (this.tx != null) {
            String msg = "Cannot resume, session is currently doing work in a transaction " + this.tx.getXid();
            throw new ActiveMQXAException(-6, msg);
        }
        Transaction theTx = this.resourceManager.getTransaction(xid);
        if (theTx == null) {
            String msg = "Cannot find xid in resource manager: " + xid;
            throw new ActiveMQXAException(-4, msg);
        }
        if (theTx.getState() != Transaction.State.SUSPENDED) {
            throw new ActiveMQXAException(-6, "Cannot resume transaction, it is not suspended " + xid);
        }
        this.tx = theTx;
        this.tx.resume();
    }

    @Override
    public synchronized void xaRollback(Xid xid) throws Exception {
        if (this.tx != null && this.tx.getXid().equals(xid)) {
            String msg = "Cannot roll back, session is currently doing work in a transaction " + this.tx.getXid();
            throw new ActiveMQXAException(-6, msg);
        }
        Transaction theTx = this.resourceManager.removeTransaction(xid);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("xarollback into " + theTx));
        }
        if (theTx == null) {
            if (this.resourceManager.getHeuristicCommittedTransactions().contains(xid)) {
                throw new ActiveMQXAException(7, "transaction has ben heuristically committed: " + xid);
            }
            if (this.resourceManager.getHeuristicRolledbackTransactions().contains(xid)) {
                throw new ActiveMQXAException(6, "transaction has ben heuristically rolled back: " + xid);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("xarollback into " + theTx + ", xid=" + xid + " forcing a rollback regular"));
            }
            try {
                this.rollback(false);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToRollbackOnTxTimedOut(e);
            }
            throw new ActiveMQXAException(-4, "Cannot find xid in resource manager: " + xid);
        }
        if (theTx.getState() == Transaction.State.SUSPENDED) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("xarollback into " + theTx + " sending tx back as it was suspended"));
            }
            this.resourceManager.putTransaction(xid, this.tx);
            throw new ActiveMQXAException(-6, "Cannot rollback transaction, it is suspended " + xid);
        }
        this.doRollback(false, false, theTx);
    }

    @Override
    public synchronized void xaStart(Xid xid) throws Exception {
        boolean added;
        if (this.tx != null) {
            ActiveMQServerLogger.LOGGER.xidReplacedOnXStart(this.tx.getXid().toString(), xid.toString());
            try {
                if (this.tx.getState() != Transaction.State.PREPARED) {
                    if (this.tx.getXid() != null) {
                        this.resourceManager.removeTransaction(this.tx.getXid());
                    }
                    this.tx.rollback();
                }
            }
            catch (Exception e) {
                logger.debug((Object)"An exception happened while we tried to debug the previous tx, we can ignore this exception", (Throwable)e);
            }
        }
        this.tx = this.newTransaction(xid);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("xastart into tx= " + this.tx));
        }
        if (!(added = this.resourceManager.putTransaction(xid, this.tx))) {
            String msg = "Cannot start, there is already a xid " + this.tx.getXid();
            throw new ActiveMQXAException(-8, msg);
        }
    }

    @Override
    public synchronized void xaFailed(Xid xid) throws Exception {
        Transaction theTX = this.resourceManager.getTransaction(xid);
        if (theTX == null) {
            theTX = this.newTransaction(xid);
            this.resourceManager.putTransaction(xid, theTX);
        }
        if (theTX.isEffective()) {
            logger.debug((Object)("Client failed with Xid " + xid + " but the server already had it " + (Object)((Object)theTX.getState())));
            this.tx = null;
        } else {
            theTX.markAsRollbackOnly(new ActiveMQException("Can't commit as a Failover happened during the operation"));
            this.tx = theTX;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("xastart into tx= " + this.tx));
        }
    }

    @Override
    public synchronized void xaSuspend() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("xasuspend on " + this.tx));
        }
        if (this.tx == null) {
            String msg = "Cannot suspend, session is not doing work in a transaction ";
            throw new ActiveMQXAException(-6, "Cannot suspend, session is not doing work in a transaction ");
        }
        if (this.tx.getState() == Transaction.State.SUSPENDED) {
            String msg = "Cannot suspend, transaction is already suspended " + this.tx.getXid();
            throw new ActiveMQXAException(-6, msg);
        }
        this.tx.suspend();
        this.tx = null;
    }

    @Override
    public synchronized void xaPrepare(Xid xid) throws Exception {
        if (this.tx != null && this.tx.getXid().equals(xid)) {
            String msg = "Cannot commit, session is currently doing work in a transaction " + this.tx.getXid();
            throw new ActiveMQXAException(-6, msg);
        }
        Transaction theTx = this.resourceManager.getTransaction(xid);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("xaprepare into , xid=" + xid + ", tx= " + this.tx));
        }
        if (theTx == null) {
            String msg = "Cannot find xid in resource manager: " + xid;
            throw new ActiveMQXAException(-4, msg);
        }
        if (theTx.getState() == Transaction.State.SUSPENDED) {
            throw new ActiveMQXAException(-6, "Cannot prepare transaction, it is suspended " + xid);
        }
        if (theTx.getState() == Transaction.State.PREPARED) {
            ActiveMQServerLogger.LOGGER.ignoringPrepareOnXidAlreadyCalled(xid.toString());
        } else {
            theTx.prepare();
        }
    }

    @Override
    public List<Xid> xaGetInDoubtXids() {
        return this.resourceManager.getInDoubtTransactions();
    }

    @Override
    public int xaGetTimeout() {
        return this.resourceManager.getTimeoutSeconds();
    }

    @Override
    public void xaSetTimeout(int timeout) {
        this.timeoutSeconds = timeout;
        if (this.tx != null) {
            this.tx.setTimeout(timeout);
        }
    }

    @Override
    public void start() {
        this.setStarted(true);
    }

    @Override
    public void stop() {
        this.setStarted(false);
    }

    @Override
    public void close(final boolean failed) {
        if (this.closed) {
            return;
        }
        this.context.executeOnCompletion(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
            }

            public void done() {
                try {
                    ServerSessionImpl.this.doClose(failed);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorClosingSession(e);
                }
            }
        });
    }

    @Override
    public void closeConsumer(long consumerID) throws Exception {
        ServerConsumer consumer = this.locateConsumer(consumerID);
        if (consumer != null) {
            consumer.close(false);
        } else {
            ActiveMQServerLogger.LOGGER.cannotFindConsumer(consumerID);
        }
    }

    @Override
    public void receiveConsumerCredits(long consumerID, int credits) throws Exception {
        ServerConsumer consumer = this.locateConsumer(consumerID);
        if (consumer == null) {
            logger.debug((Object)("There is no consumer with id " + consumerID));
            return;
        }
        consumer.receiveCredits(credits);
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.tx;
    }

    @Override
    public RoutingStatus send(Message message, boolean direct) throws Exception {
        return this.send(message, direct, false);
    }

    @Override
    public RoutingStatus send(Message message, boolean direct, boolean noAutoCreateQueue) throws Exception {
        return this.send(this.getCurrentTransaction(), message, direct, noAutoCreateQueue);
    }

    @Override
    public synchronized RoutingStatus send(Transaction tx, Message msg, boolean direct, boolean noAutoCreateQueue) throws Exception {
        return this.send(tx, msg, direct, noAutoCreateQueue, this.routingContext);
    }

    @Override
    public synchronized RoutingStatus send(Transaction tx, Message messageParameter, boolean direct, boolean noAutoCreateQueue, RoutingContext routingContext) throws Exception {
        RoutingStatus result;
        if (AuditLogger.isMessageEnabled()) {
            AuditLogger.coreSendMessage((Object)this, (String)this.getUsername(), (Object[])new Object[]{tx, messageParameter, direct, noAutoCreateQueue, routingContext});
        }
        Message message = LargeServerMessageImpl.checkLargeMessage(messageParameter, this.storageManager);
        if (this.server.hasBrokerMessagePlugins()) {
            this.server.callBrokerMessagePlugins(plugin -> plugin.beforeSend(this, tx, message, direct, noAutoCreateQueue));
        }
        try {
            if (!this.getRemotingConnection().isSupportsFlowControl() && this.pagingManager.isDiskFull()) {
                ActiveMQIOErrorException exception = ActiveMQMessageBundle.BUNDLE.diskBeyondLimit();
                this.getRemotingConnection().fail((ActiveMQException)exception);
                throw exception;
            }
            if (!message.isLargeMessage()) {
                long id = this.storageManager.generateID();
                message.setMessageID(id);
            }
            SimpleString address = message.getAddressSimpleString();
            if (this.defaultAddress == null && address != null) {
                this.defaultAddress = address;
            }
            if (address == null) {
                message.setAddress(this.defaultAddress);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("send(message=" + message + ", direct=" + direct + ") being called"));
            }
            if (message.getAddress() == null) {
                throw ActiveMQMessageBundle.BUNDLE.noAddress();
            }
            result = message.getAddressSimpleString().equals((Object)this.managementAddress) ? this.handleManagementMessage(tx, message, direct) : this.doSend(tx, message, address, direct, noAutoCreateQueue, routingContext);
        }
        catch (Exception e) {
            if (this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.onSendException(this, tx, message, direct, noAutoCreateQueue, e));
            }
            throw e;
        }
        if (this.server.hasBrokerMessagePlugins()) {
            this.server.callBrokerMessagePlugins(plugin -> plugin.afterSend(this, tx, message, direct, noAutoCreateQueue, result));
        }
        return result;
    }

    @Override
    public void requestProducerCredits(final SimpleString address, final int credits) throws Exception {
        SimpleString addr = this.removePrefix(address);
        PagingStore store = this.server.getPagingManager().getPageStore(addr);
        if (store == null) {
            this.callback.sendProducerCreditsMessage(credits, address);
        } else if (!store.checkMemory(new Runnable(){

            @Override
            public void run() {
                ServerSessionImpl.this.callback.sendProducerCreditsMessage(credits, address);
            }
        })) {
            this.callback.sendProducerCreditsFailMessage(credits, address);
        }
    }

    @Override
    public void setTransferring(boolean transferring) {
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        for (ServerConsumer consumer : consumersClone) {
            consumer.setTransferring(transferring);
        }
    }

    @Override
    public void addMetaData(String key, String data) throws Exception {
        if (this.server.hasBrokerSessionPlugins()) {
            this.server.callBrokerSessionPlugins(plugin -> plugin.beforeSessionMetadataAdded(this, key, data));
        }
        if (this.metaData == null) {
            this.metaData = new HashMap<String, String>();
        }
        this.metaData.put(key, data);
        if (this.server.hasBrokerSessionPlugins()) {
            this.server.callBrokerSessionPlugins(plugin -> plugin.afterSessionMetadataAdded(this, key, data));
        }
    }

    @Override
    public boolean addUniqueMetaData(String key, String data) throws Exception {
        ServerSession sessionWithMetaData = this.server.lookupSession(key, data);
        if (sessionWithMetaData != null && sessionWithMetaData != this) {
            if (this.server.hasBrokerSessionPlugins()) {
                this.server.callBrokerSessionPlugins(plugin -> plugin.duplicateSessionMetadataFailure(this, key, data));
            }
            return false;
        }
        this.addMetaData(key, data);
        return true;
    }

    @Override
    public String getMetaData(String key) {
        String data = null;
        if (this.metaData != null) {
            data = this.metaData.get(key);
        }
        return data;
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    @Override
    public String[] getTargetAddresses() {
        Map<SimpleString, Pair<Object, AtomicLong>> copy = this.cloneTargetAddresses();
        Iterator<SimpleString> iter = copy.keySet().iterator();
        int num = copy.keySet().size();
        String[] addresses = new String[num];
        int i = 0;
        while (iter.hasNext()) {
            addresses[i] = iter.next().toString();
            ++i;
        }
        return addresses;
    }

    @Override
    public String getLastSentMessageID(String address) {
        Pair<Object, AtomicLong> value = this.targetAddressInfos.get(SimpleString.toSimpleString((String)address));
        if (value != null) {
            return value.getA().toString();
        }
        return null;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public void describeProducersInfo(JsonArrayBuilder array) throws Exception {
        Map<SimpleString, Pair<Object, AtomicLong>> targetCopy = this.cloneTargetAddresses();
        for (Map.Entry<SimpleString, Pair<Object, AtomicLong>> entry : targetCopy.entrySet()) {
            String uuid = null;
            if (entry.getValue().getA() != null) {
                uuid = entry.getValue().getA().toString();
            }
            JsonObjectBuilder producerInfo = JsonLoader.createObjectBuilder().add("connectionID", this.getConnectionID().toString()).add("sessionID", this.getName()).add("destination", entry.getKey().toString()).add("lastUUIDSent", JsonUtil.nullSafe((String)uuid)).add("msgSent", ((AtomicLong)entry.getValue().getB()).longValue());
            array.add(producerInfo);
        }
    }

    @Override
    public String getValidatedUser() {
        return this.validatedUser;
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, RoutingType routingType) throws Exception {
        return this.server.getPostOffice().getMatchingQueue(address, routingType);
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, SimpleString queueName, RoutingType routingType) throws Exception {
        return this.server.getPostOffice().getMatchingQueue(address, queueName, routingType);
    }

    @Override
    public AddressInfo getAddress(SimpleString address) {
        return this.server.getPostOffice().getAddressInfo(this.removePrefix(address));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.metaData != null) {
            for (Map.Entry<String, String> value : this.metaData.entrySet()) {
                String tmpValue;
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                if ((tmpValue = value.getValue()) == null || tmpValue.toString().isEmpty()) {
                    buffer.append(value.getKey() + "=*N/A*");
                    continue;
                }
                buffer.append(value.getKey() + "=" + tmpValue);
            }
        }
        return "ServerSessionImpl(" + buffer.toString() + ")";
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver) {
        try {
            ActiveMQServerLogger.LOGGER.clientConnectionFailed(this.name);
            this.close(true);
            ActiveMQServerLogger.LOGGER.clientConnectionFailedClearingSession(this.name);
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.errorClosingConnection(this);
        }
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    private Map<SimpleString, Pair<Object, AtomicLong>> cloneTargetAddresses() {
        return new HashMap<SimpleString, Pair<Object, AtomicLong>>(this.targetAddressInfos);
    }

    private void setStarted(boolean s) {
        HashSet<ServerConsumer> consumersClone = new HashSet<ServerConsumer>(this.consumers.values());
        for (ServerConsumer consumer : consumersClone) {
            consumer.setStarted(s);
        }
        this.started = s;
    }

    private RoutingStatus handleManagementMessage(Transaction tx, Message message, boolean direct) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.handleManagementMessage((Object)this.getName(), (String)this.getUsername(), (Object[])new Object[]{tx, message, direct});
        }
        try {
            this.securityCheck(this.removePrefix(message.getAddressSimpleString()), CheckType.MANAGE, this);
        }
        catch (ActiveMQException e) {
            if (!this.autoCommitSends) {
                tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        ICoreMessage reply = this.managementService.handleMessage(message);
        SimpleString replyTo = message.getReplyTo();
        if (replyTo != null) {
            if (replyTo.toString().startsWith("queue://") || replyTo.toString().startsWith("topic://")) {
                replyTo = SimpleString.toSimpleString((String)replyTo.toString().substring(8));
            } else if (replyTo.toString().startsWith("temp-queue://") || replyTo.toString().startsWith("temp-topic://")) {
                replyTo = SimpleString.toSimpleString((String)replyTo.toString().substring(13));
            }
            reply.setAddress(replyTo);
            this.doSend(tx, (Message)reply, null, direct, false, this.routingContext);
        }
        return RoutingStatus.OK;
    }

    private void doRollback(boolean clientFailed, boolean lastMessageAsDelived, Transaction theTx) throws Exception {
        boolean wasStarted = this.started;
        ArrayList<MessageReference> toCancel = new ArrayList<MessageReference>();
        for (ServerConsumer consumer : this.consumers.values()) {
            if (wasStarted) {
                consumer.setStarted(false);
            }
            toCancel.addAll(consumer.cancelRefs(clientFailed, lastMessageAsDelived, theTx));
        }
        if (theTx.getState() == Transaction.State.ROLLEDBACK) {
            Transaction newTX = this.newTransaction();
            this.cancelAndRollback(clientFailed, newTX, wasStarted, toCancel);
        } else {
            this.cancelAndRollback(clientFailed, theTx, wasStarted, toCancel);
        }
    }

    private void cancelAndRollback(boolean clientFailed, Transaction theTx, boolean wasStarted, List<MessageReference> toCancel) throws Exception {
        for (MessageReference ref : toCancel) {
            ref.getQueue().cancel(theTx, ref);
        }
        if (wasStarted && !clientFailed) {
            theTx.addOperation(new TransactionOperationAbstract(){

                @Override
                public void afterRollback(Transaction tx) {
                    for (ServerConsumer consumer : ServerSessionImpl.this.consumers.values()) {
                        consumer.setStarted(true);
                    }
                }
            });
        }
        theTx.rollback();
    }

    @Override
    public synchronized RoutingStatus doSend(Transaction tx, Message msg, SimpleString originalAddress, boolean direct, boolean noAutoCreateQueue) throws Exception {
        return this.doSend(tx, msg, originalAddress, direct, noAutoCreateQueue, this.routingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RoutingStatus doSend(Transaction tx, Message msg, SimpleString originalAddress, boolean direct, boolean noAutoCreateQueue, RoutingContext routingContext) throws Exception {
        RoutingStatus result = RoutingStatus.OK;
        RoutingType routingType = msg.getRoutingType();
        AddressInfo art = this.getAddressAndRoutingType(new AddressInfo(msg.getAddressSimpleString(), routingType));
        try {
            this.securityCheck(art.getName(), CheckType.SEND, this);
        }
        catch (ActiveMQException e) {
            if (!this.autoCommitSends && tx != null) {
                tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        if (this.server.getConfiguration().isPopulateValidatedUser() && this.validatedUser != null) {
            msg.setValidatedUserID(this.validatedUser);
        }
        if (tx == null || this.autoCommitSends) {
            routingContext.setTransaction(null);
        } else {
            routingContext.setTransaction(tx);
        }
        try {
            routingContext.setAddress(art.getName());
            routingContext.setRoutingType(art.getRoutingType());
            result = this.postOffice.route(msg, routingContext, direct);
            Pair<Object, AtomicLong> value = this.targetAddressInfos.get(msg.getAddressSimpleString());
            if (value == null) {
                this.targetAddressInfos.put(msg.getAddressSimpleString(), (Pair<Object, AtomicLong>)new Pair(msg.getUserID(), (Object)new AtomicLong(1L)));
            } else {
                value.setA(msg.getUserID());
                ((AtomicLong)value.getB()).incrementAndGet();
            }
        }
        finally {
            if (!routingContext.isReusable()) {
                routingContext.clear();
            }
        }
        return result;
    }

    @Override
    public List<MessageReference> getInTXMessagesForConsumer(long consumerId) {
        RefsOperation operation;
        Transaction transaction;
        if (this.tx != null) {
            RefsOperation oper = (RefsOperation)this.tx.getProperty(6);
            if (oper == null) {
                return Collections.emptyList();
            }
            return oper.getListOnConsumer(consumerId);
        }
        if (this.callback != null && (transaction = this.callback.getCurrentTransaction()) != null && (operation = (RefsOperation)transaction.getProperty(6)) != null) {
            return operation.getListOnConsumer(consumerId);
        }
        return Collections.emptyList();
    }

    @Override
    public SimpleString removePrefix(SimpleString address) {
        if (this.prefixEnabled && address != null) {
            return PrefixUtil.getAddress((SimpleString)address, this.prefixes);
        }
        return address;
    }

    @Override
    public SimpleString getPrefix(SimpleString address) {
        if (this.prefixEnabled && address != null) {
            return PrefixUtil.getPrefix((SimpleString)address, this.prefixes);
        }
        return null;
    }

    @Override
    public AddressInfo getAddressAndRoutingType(AddressInfo addressInfo) {
        if (this.prefixEnabled) {
            return addressInfo.getAddressAndRoutingType(this.prefixes);
        }
        return addressInfo;
    }

    @Override
    public Pair<SimpleString, EnumSet<RoutingType>> getAddressAndRoutingTypes(SimpleString address, EnumSet<RoutingType> defaultRoutingTypes) {
        if (this.prefixEnabled) {
            return PrefixUtil.getAddressAndRoutingTypes((SimpleString)address, defaultRoutingTypes, this.prefixes);
        }
        return new Pair((Object)address, defaultRoutingTypes);
    }

    @Override
    public void addProducer(ServerProducer serverProducer) {
        serverProducer.setSessionID(this.getName());
        serverProducer.setConnectionID(this.getConnectionID().toString());
        this.producers.put(serverProducer.getID(), serverProducer);
    }

    @Override
    public void removeProducer(String ID) {
        this.producers.remove(ID);
    }

    @Override
    public Map<String, ServerProducer> getServerProducers() {
        return Collections.unmodifiableMap(new HashMap<String, ServerProducer>(this.producers));
    }

    @Override
    public String getDefaultAddress() {
        return this.defaultAddress != null ? this.defaultAddress.toString() : null;
    }

    @Override
    public int getConsumerCount() {
        return this.getServerConsumers().size();
    }

    @Override
    public int getProducerCount() {
        return this.getServerProducers().size();
    }

    @Override
    public int getDefaultConsumerWindowSize(SimpleString address) {
        AddressSettings as = this.server.getAddressSettingsRepository().getMatch(address.toString());
        return as.getDefaultConsumerWindowSize();
    }

    public static class TempQueueCleanerUpper
    implements CloseListener,
    FailureListener {
        private final SimpleString bindingName;
        private final ActiveMQServer server;
        private TempQueueObserver observer;

        public TempQueueCleanerUpper(ActiveMQServer server, SimpleString bindingName) {
            this.server = server;
            this.bindingName = bindingName;
        }

        public void setObserver(TempQueueObserver observer) {
            this.observer = observer;
        }

        private void run() {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("deleting temporary queue " + this.bindingName));
                }
                try {
                    this.server.destroyQueue(this.bindingName, null, false);
                    if (this.observer != null) {
                        this.observer.tempQueueDeleted(this.bindingName);
                    }
                }
                catch (ActiveMQException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingTempQueue(e, this.bindingName);
            }
        }

        public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            this.run();
        }

        public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
            this.connectionFailed(me, failedOver);
        }

        public void connectionClosed() {
            this.run();
        }

        public String toString() {
            return "Temporary Cleaner for queue " + this.bindingName;
        }
    }
}

