/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.vocab;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.URI;
import org.openrdf.model.impl.ValueFactoryImpl;

public abstract class Vocabulary {
    private final URI namespace;
    private Map<String, URI> classes;
    private Map<String, URI> properties;
    private Map<URI, String> resourceToCommentMap;

    public Vocabulary(String namespace) {
        try {
            this.namespace = ValueFactoryImpl.getInstance().createURI(namespace);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid namespace '" + namespace + "'", e);
        }
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public URI getClass(String name) {
        URI res = this.classes.get(name);
        if (null == res) {
            throw new IllegalArgumentException("Unknown resource name '" + name + "'");
        }
        return res;
    }

    public URI getProperty(String name) {
        URI prop = this.properties.get(name);
        if (null == prop) {
            throw new IllegalArgumentException("Unknown property name '" + name + "'");
        }
        return prop;
    }

    public URI getProperty(String name, URI defaultValue) {
        URI prop = this.properties.get(name);
        if (null == prop) {
            return defaultValue;
        }
        return prop;
    }

    public URI getPropertyCamelCase(String property) {
        String[] names = property.split("\\W");
        String camelCase = names[0];
        for (int i = 1; i < names.length; ++i) {
            String tmp = names[i];
            camelCase = camelCase + tmp.replaceFirst("(.)", tmp.substring(0, 1).toUpperCase());
        }
        return this.getProperty(camelCase);
    }

    public URI[] getClasses() {
        if (this.classes == null) {
            return new URI[0];
        }
        Collection<URI> uris = this.classes.values();
        return uris.toArray(new URI[uris.size()]);
    }

    public URI[] getProperties() {
        if (this.properties == null) {
            return new URI[0];
        }
        Collection<URI> uris = this.properties.values();
        return uris.toArray(new URI[uris.size()]);
    }

    public Map<URI, String> getComments() {
        this.fillResourceToCommentMap();
        return Collections.unmodifiableMap(this.resourceToCommentMap);
    }

    public String getCommentFor(URI resource) {
        this.fillResourceToCommentMap();
        return this.resourceToCommentMap.get(resource);
    }

    protected URI createURI(String uriStr) {
        return ValueFactoryImpl.getInstance().createURI(uriStr);
    }

    protected URI createClass(String namespace, String resource) {
        URI res = this.createURI(namespace, resource);
        if (this.classes == null) {
            this.classes = new HashMap<String, URI>(10);
        }
        this.classes.put(resource, res);
        return res;
    }

    protected URI createProperty(String namespace, String property) {
        URI res = this.createURI(namespace, property);
        if (this.properties == null) {
            this.properties = new HashMap<String, URI>(10);
        }
        this.properties.put(property, res);
        return res;
    }

    private URI createURI(String namespace, String localName) {
        return ValueFactoryImpl.getInstance().createURI(namespace, localName);
    }

    private void fillResourceToCommentMap() {
        if (this.resourceToCommentMap != null) {
            return;
        }
        HashMap<URI, String> newMap = new HashMap<URI, String>();
        for (Field field : this.getClass().getFields()) {
            try {
                Comment comment;
                Object value = field.get(this);
                if (!(value instanceof URI) || (comment = field.getAnnotation(Comment.class)) == null) continue;
                newMap.put((URI)value, comment.value());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Error while creating resource to comment map.", iae);
            }
        }
        this.resourceToCommentMap = newMap;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Comment {
        public String value();
    }
}

