/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.spring.extender;

import java.util.Hashtable;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.services.BlueprintExtenderService;
import org.apache.aries.blueprint.spring.extender.SpringOsgiCompendiumNamespaceHandler;
import org.apache.aries.blueprint.spring.extender.SpringOsgiExtender;
import org.apache.aries.blueprint.spring.extender.SpringOsgiNamespaceHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<BlueprintExtenderService, SpringOsgiExtender> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    BundleContext bundleContext;
    ServiceTracker<BlueprintExtenderService, SpringOsgiExtender> tracker;
    ServiceRegistration<NamespaceHandler> osgiNamespaceRegistration;
    ServiceRegistration<NamespaceHandler> compendiumNamespaceRegistration;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.tracker = new ServiceTracker(this.bundleContext, BlueprintExtenderService.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("osgi.service.blueprint.namespace", "http://www.springframework.org/schema/osgi");
        this.osgiNamespaceRegistration = this.bundleContext.registerService(NamespaceHandler.class, (Object)new SpringOsgiNamespaceHandler(), props);
        props = new Hashtable();
        props.put("osgi.service.blueprint.namespace", "http://www.springframework.org/schema/osgi-compendium");
        this.compendiumNamespaceRegistration = this.bundleContext.registerService(NamespaceHandler.class, (Object)new SpringOsgiCompendiumNamespaceHandler(), props);
    }

    public void stop(BundleContext context) throws Exception {
        this.tracker.close();
        this.osgiNamespaceRegistration.unregister();
        this.compendiumNamespaceRegistration.unregister();
    }

    public SpringOsgiExtender addingService(ServiceReference<BlueprintExtenderService> reference) {
        BlueprintExtenderService blueprintExtenderService = (BlueprintExtenderService)this.bundleContext.getService(reference);
        SpringOsgiExtender extender = new SpringOsgiExtender(blueprintExtenderService);
        try {
            extender.start(this.bundleContext);
        }
        catch (Exception e) {
            LOGGER.error("Error starting SpringOsgiExtender", (Throwable)e);
        }
        return extender;
    }

    public void modifiedService(ServiceReference<BlueprintExtenderService> reference, SpringOsgiExtender service) {
    }

    public void removedService(ServiceReference<BlueprintExtenderService> reference, SpringOsgiExtender service) {
        try {
            service.stop(this.bundleContext);
        }
        catch (Exception e) {
            LOGGER.error("Error stopping SpringOsgiExtender", (Throwable)e);
        }
        this.bundleContext.ungetService(reference);
    }
}

