/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.spring.extender;

import java.net.URI;
import java.net.URL;
import java.util.Set;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringOsgiCompendiumNamespaceHandler
implements NamespaceHandler {
    public static final String CM_NAMESPACE = "http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.3.0";

    public URL getSchemaLocation(String namespace) {
        if (namespace.startsWith("http://www.springframework.org/schema/osgi-compendium/spring-osgi-compendium")) {
            String sub = namespace.substring("http://www.springframework.org/schema/osgi-compendium/".length());
            if ("spring-osgi-compendium.xsd".equals(sub)) {
                sub = "spring-osgi-compendium-1.2.xsd";
            }
            return this.getClass().getResource(sub);
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public Metadata parse(Element element, ParserContext context) {
        SpringOsgiCompendiumNamespaceHandler.fixDom(element, CM_NAMESPACE);
        NamespaceHandler handler = context.getNamespaceHandler(URI.create(CM_NAMESPACE));
        return handler.parse(element, context);
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        return component;
    }

    private static void fixDom(Node node, String namespace) {
        if (node.getNodeType() == 1) {
            if (!namespace.equals(node.getNamespaceURI())) {
                node.getOwnerDocument().renameNode(node, namespace, node.getLocalName());
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                SpringOsgiCompendiumNamespaceHandler.fixDom(children.item(i), namespace);
            }
        }
    }
}

