/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.spring.extender;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.aries.blueprint.services.BlueprintExtenderService;
import org.apache.aries.blueprint.spring.extender.SpringOsgiExtension;
import org.apache.aries.blueprint.utils.HeaderParser;
import org.apache.felix.utils.extender.AbstractExtender;
import org.apache.felix.utils.extender.Extension;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringOsgiExtender
extends AbstractExtender {
    public static final String SPRING_CONTEXT_HEADER = "Spring-Context";
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringOsgiExtender.class);
    private final BlueprintExtenderService blueprintExtenderService;

    public SpringOsgiExtender(BlueprintExtenderService blueprintExtenderService) {
        this.blueprintExtenderService = blueprintExtenderService;
    }

    @Override
    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        List<URL> paths = this.getSpringPaths(bundle);
        if (paths != null && !paths.isEmpty()) {
            return new SpringOsgiExtension(this.blueprintExtenderService, bundle, paths);
        }
        return null;
    }

    private List<URL> getSpringPaths(Bundle bundle) throws Exception {
        LOGGER.debug("Scanning bundle {}/{} for spring application", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
        ArrayList<URL> pathList = new ArrayList<URL>();
        String springHeader = (String)bundle.getHeaders().get(SPRING_CONTEXT_HEADER);
        if (springHeader == null) {
            springHeader = "*";
        }
        List paths = HeaderParser.parseHeader((String)springHeader);
        for (HeaderParser.PathElement path : paths) {
            String filePattern;
            String baseName;
            int pos;
            String name = path.getName();
            if ("*".equals(name)) {
                name = "META-INF/spring/*.xml";
            }
            if ((pos = name.lastIndexOf(47)) < 0) {
                baseName = "/";
                filePattern = name;
            } else {
                baseName = name.substring(0, pos + 1);
                filePattern = name.substring(pos + 1);
            }
            if (filePattern.contains("*")) {
                Enumeration e = bundle.findEntries(baseName, filePattern, false);
                while (e != null && e.hasMoreElements()) {
                    pathList.add((URL)e.nextElement());
                }
                continue;
            }
            pathList.add(bundle.getEntry(name));
        }
        if (!pathList.isEmpty()) {
            LOGGER.debug("Found spring application in bundle {}/{} with paths: {}", new Object[]{bundle.getSymbolicName(), bundle.getVersion(), pathList});
            if (this.isCompatible(bundle)) {
                return pathList;
            }
            LOGGER.info("Bundle {}/{} is not compatible with this blueprint extender", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
        } else {
            LOGGER.debug("No blueprint application found in bundle {}/{}", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
        }
        return null;
    }

    private boolean isCompatible(Bundle bundle) {
        return true;
    }

    @Override
    protected void debug(Bundle bundle, String msg) {
        LOGGER.debug(msg + ": " + bundle.getSymbolicName() + "/" + bundle.getVersion());
    }

    @Override
    protected void warn(Bundle bundle, String msg, Throwable t) {
        LOGGER.warn(msg + ": " + bundle.getSymbolicName() + "/" + bundle.getVersion(), t);
    }

    @Override
    protected void error(String msg, Throwable t) {
        LOGGER.error(msg, t);
    }
}

