/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.spring.extender;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.aries.blueprint.services.BlueprintExtenderService;
import org.apache.aries.blueprint.spring.extender.SpringXsdVersionResolver;
import org.apache.felix.utils.extender.Extension;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SpringOsgiExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringOsgiExtension.class);
    private final BlueprintExtenderService blueprintExtenderService;
    private final Bundle bundle;
    private final List<URL> paths;
    BlueprintContainer container;

    public SpringOsgiExtension(BlueprintExtenderService blueprintExtenderService, Bundle bundle, List<URL> paths) {
        this.blueprintExtenderService = blueprintExtenderService;
        this.bundle = bundle;
        this.paths = paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        ArrayList<URL> bpPaths = new ArrayList<URL>();
        LinkedHashSet<URI> namespaces = new LinkedHashSet<URI>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        for (URL url : this.paths) {
            InputStream is = url.openStream();
            try {
                InputSource inputSource = new InputSource(is);
                DocumentBuilder builder = dbf.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                Attr schemaLoc = doc.getDocumentElement().getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                if (schemaLoc == null) continue;
                ArrayList<String> locs = new ArrayList<String>(Arrays.asList(schemaLoc.getValue().split("\\s+")));
                locs.remove("");
                for (int i = 0; i < locs.size() / 2; ++i) {
                    String ns = (String)locs.get(i * 2);
                    namespaces.add(URI.create(ns));
                    if (!ns.startsWith("http://www.springframework.org/schema/osgi-compendium")) continue;
                    namespaces.add(URI.create("http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.3.0"));
                }
            }
            finally {
                is.close();
            }
        }
        File file = File.createTempFile("blueprint-spring-extender", ".xml");
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write("<blueprint xmlns=\"http://www.osgi.org/xmlns/blueprint/v1.0.0\"\n");
            writer.write("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            writer.write("\txmlns:bean=\"http://www.springframework.org/schema/beans\"\n");
            writer.write("\txsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-" + SpringXsdVersionResolver.resolve() + ".xsd\">\n");
            for (URL url : this.paths) {
                writer.write("\t<bean:import resource=\"" + url.toString() + "\"/>\n");
            }
            writer.write("</blueprint>\n");
        }
        finally {
            writer.close();
        }
        LOGGER.info("Generated blueprint for bundle {}/{} at {}", new Object[]{this.bundle.getSymbolicName(), this.bundle.getVersion(), file});
        bpPaths.add(file.toURI().toURL());
        this.container = this.blueprintExtenderService.createContainer(this.bundle, bpPaths, namespaces);
    }

    @Override
    public void destroy() throws Exception {
        if (this.container == this.blueprintExtenderService.getContainer(this.bundle)) {
            this.blueprintExtenderService.destroyContainer(this.bundle, this.container);
        }
    }
}

