/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.spring.extender;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableRefMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringOsgiNamespaceHandler
implements NamespaceHandler {
    public static final String BLUEPRINT_NAMESPACE = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    public static final String SPRING_NAMESPACE = "http://www.springframework.org/schema/beans";
    public static final String BEAN_ELEMENT = "bean";
    public static final String BEAN_NAME_ELEMENT = "bean-name";
    public static final String FILTER_ATTRIBUTE = "filter";
    public static final String INTERFACE_ATTRIBUTE = "interface";
    public static final String TIMEOUT_ATTRIBUTE = "timeout";
    public static final String DEPENDS_ON_ATTRIBUTE = "depends-on";
    public static final String CARDINALITY_ATTRIBUTE = "cardinality";
    public static final String LISTENER_ELEMENT = "listener";
    public static final String REF_ATTRIBUTE = "ref";
    public static final String BIND_METHOD_ATTRIBUTE = "bind-method";
    public static final String UNBIND_METHOD_ATTRIBUTE = "unbind-method";
    public static final String ID_ATTRIBUTE = "id";
    public static final String CARDINALITY_0_1 = "0..1";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String VALUE_REF_ATTRIBUTE = "value-ref";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String KEY_REF_ATTRIBUTE = "key-ref";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String SERVICE_PROPERTIES_ELEMENT = "service-properties";
    public static final String REGISTRATION_LISTENER_ELEMENT = "registration-listener";
    public static final String INTERFACES_ELEMENT = "interfaces";
    public static final String VALUE_ELEMENT = "value";
    public static final String AUTO_EXPORT_ATTRIBUTE = "auto-export";
    public static final String AUTO_EXPORT_INTERFACES = "interfaces";
    public static final String AUTO_EXPORT_CLASS_HIERARCHY = "class-hierarchy";
    public static final String AUTO_EXPORT_ALL_CLASSES = "all-classes";
    public static final String RANKING_ATTRIBUTE = "ranking";
    public static final String REFERENCE_ELEMENT = "reference";
    public static final String SERVICE_ELEMENT = "service";
    public static final String BUNDLE_ELEMENT = "bundle";
    public static final String SET_ELEMENT = "set";
    public static final String LIST_ELEMENT = "list";
    public static final int DEFAULT_TIMEOUT = 300000;
    public static final String REGISTRATION_METHOD_ATTRIBUTE = "registration-method";
    public static final String UNREGISTRATION_METHOD_ATTRIBUTE = "unregistration-method";
    private int idCounter;

    public URL getSchemaLocation(String namespace) {
        if (namespace.startsWith("http://www.springframework.org/schema/osgi/spring-osgi")) {
            String sub = namespace.substring("http://www.springframework.org/schema/osgi/".length());
            if ("spring-osgi.xsd".equals(sub)) {
                sub = "spring-osgi-1.2.xsd";
            }
            return this.getClass().getResource(sub);
        }
        return null;
    }

    public Set<Class> getManagedClasses() {
        return null;
    }

    public Metadata parse(Element element, ParserContext context) {
        if (REFERENCE_ELEMENT.equals(element.getLocalName())) {
            return this.parseReference(element, context);
        }
        if (SERVICE_ELEMENT.equals(element.getLocalName())) {
            return this.parseService(element, context);
        }
        if (BUNDLE_ELEMENT.equals(element.getLocalName())) {
            return this.parseBundle(element, context);
        }
        if (SET_ELEMENT.equals(element.getLocalName())) {
            return this.parseSet(element, context);
        }
        if (LIST_ELEMENT.equals(element.getLocalName())) {
            return this.parseList(element, context);
        }
        throw new UnsupportedOperationException();
    }

    private Metadata parseBundle(Element element, ParserContext context) {
        throw new UnsupportedOperationException();
    }

    private Metadata parseList(Element element, ParserContext context) {
        throw new UnsupportedOperationException();
    }

    private Metadata parseSet(Element element, ParserContext context) {
        throw new UnsupportedOperationException();
    }

    private Metadata parseService(Element element, ParserContext context) {
        String[] dependsOn;
        MutableServiceMetadata metadata = (MutableServiceMetadata)context.createMetadata(MutableServiceMetadata.class);
        if (element.hasAttribute(ID_ATTRIBUTE)) {
            metadata.setId(element.getAttribute(ID_ATTRIBUTE));
        } else {
            metadata.setId(this.generateId(context));
        }
        if (this.nonEmpty(element.getAttribute(REF_ATTRIBUTE)) != null) {
            MutableRefMetadata ref = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
            ref.setComponentId(element.getAttribute(REF_ATTRIBUTE));
            metadata.setServiceComponent((Target)ref);
        }
        metadata.setRanking(this.nonEmpty(element.getAttribute(RANKING_ATTRIBUTE)) != null ? Integer.parseInt(element.getAttribute(RANKING_ATTRIBUTE)) : 0);
        String itf = this.nonEmpty(element.getAttribute(INTERFACE_ATTRIBUTE));
        if (itf != null) {
            metadata.addInterface(itf);
        }
        metadata.setDependsOn((dependsOn = StringUtils.tokenizeToStringArray((String)this.nonEmpty(element.getAttribute(DEPENDS_ON_ATTRIBUTE)), (String)",; ")) != null ? Arrays.asList(dependsOn) : null);
        String autoExp = this.nonEmpty(element.getAttribute(AUTO_EXPORT_ATTRIBUTE));
        if ("interfaces".equals(autoExp)) {
            metadata.setAutoExport(2);
        } else if (AUTO_EXPORT_CLASS_HIERARCHY.equals(autoExp)) {
            metadata.setAutoExport(3);
        } else if (AUTO_EXPORT_ALL_CLASSES.equals(autoExp)) {
            metadata.setAutoExport(4);
        } else {
            metadata.setAutoExport(1);
        }
        for (Element child : this.getChildren(element)) {
            if (element.getNamespaceURI().equals(child.getNamespaceURI())) {
                if ("interfaces".equals(child.getLocalName())) {
                    List<String> itfs = this.parseInterfaces(child);
                    for (String intf : itfs) {
                        metadata.addInterface(intf);
                    }
                    continue;
                }
                if (REGISTRATION_LISTENER_ELEMENT.equals(child.getLocalName())) {
                    String regMethod = this.nonEmpty(child.getAttribute(REGISTRATION_METHOD_ATTRIBUTE));
                    String unregMethod = this.nonEmpty(child.getAttribute(UNREGISTRATION_METHOD_ATTRIBUTE));
                    String refStr = this.nonEmpty(child.getAttribute(REF_ATTRIBUTE));
                    MutableRefMetadata listenerComponent = null;
                    if (refStr != null) {
                        MutableRefMetadata ref = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
                        ref.setComponentId(refStr);
                        listenerComponent = ref;
                    }
                    for (Element cchild : this.getChildren(child)) {
                        if (listenerComponent != null) {
                            throw new IllegalArgumentException("Only one of @ref attribute or inlined bean definition element is allowed");
                        }
                        listenerComponent = this.parseInlinedTarget(context, (ComponentMetadata)metadata, cchild);
                    }
                    if (listenerComponent == null) {
                        throw new IllegalArgumentException("Missing @ref attribute or inlined bean definition element");
                    }
                    metadata.addRegistrationListener((Target)listenerComponent, regMethod, unregMethod);
                    continue;
                }
                if (!SERVICE_PROPERTIES_ELEMENT.equals(child.getLocalName())) continue;
                for (Element e : this.getChildren(child)) {
                    MutableRefMetadata val;
                    MutableRefMetadata key;
                    if (!ENTRY_ELEMENT.equals(e.getLocalName())) continue;
                    boolean hasKeyAttribute = e.hasAttribute(KEY_ATTRIBUTE);
                    boolean hasKeyRefAttribute = e.hasAttribute(KEY_REF_ATTRIBUTE);
                    if (hasKeyRefAttribute && !hasKeyAttribute) {
                        MutableRefMetadata r = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
                        r.setComponentId(e.getAttribute(KEY_REF_ATTRIBUTE));
                        key = r;
                    } else if (hasKeyAttribute && !hasKeyRefAttribute) {
                        MutableValueMetadata v = (MutableValueMetadata)context.createMetadata(MutableValueMetadata.class);
                        v.setStringValue(e.getAttribute(KEY_ATTRIBUTE));
                        key = v;
                    } else {
                        throw new IllegalStateException("Either key or key-ref must be specified");
                    }
                    boolean hasValAttribute = e.hasAttribute("value");
                    boolean hasValRefAttribute = e.hasAttribute(VALUE_REF_ATTRIBUTE);
                    if (hasValRefAttribute && !hasValAttribute) {
                        MutableRefMetadata r = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
                        r.setComponentId(e.getAttribute(VALUE_REF_ATTRIBUTE));
                        val = r;
                    } else if (hasValAttribute && !hasValRefAttribute) {
                        MutableValueMetadata v = (MutableValueMetadata)context.createMetadata(MutableValueMetadata.class);
                        v.setStringValue(e.getAttribute("value"));
                        val = v;
                    } else {
                        throw new IllegalStateException("Either val or val-ref must be specified");
                    }
                    metadata.addServiceProperty((NonNullMetadata)key, (Metadata)val);
                }
                continue;
            }
            if (BLUEPRINT_NAMESPACE.equals(child.getNamespaceURI()) && BEAN_ELEMENT.equals(child.getLocalName())) {
                if (metadata.getServiceComponent() != null) {
                    throw new IllegalArgumentException("Only one of @ref attribute and bean element is allowed");
                }
                Target bean = (Target)context.parseElement(BeanMetadata.class, (ComponentMetadata)metadata, child);
                metadata.setServiceComponent(bean);
                continue;
            }
            if (metadata.getServiceComponent() != null) {
                throw new IllegalArgumentException("Only one of @ref attribute or inlined bean definition element is allowed");
            }
            NamespaceHandler handler = context.getNamespaceHandler(URI.create(child.getNamespaceURI()));
            if (handler == null) {
                throw new IllegalStateException("No NamespaceHandler found for " + child.getNamespaceURI());
            }
            Metadata md = handler.parse(child, context);
            if (!(md instanceof Target)) {
                throw new IllegalStateException("NamespaceHandler did not return a Target instance but " + md);
            }
            metadata.setServiceComponent((Target)md);
        }
        return metadata;
    }

    private Metadata parseReference(Element element, ParserContext context) {
        MutableReferenceMetadata metadata = (MutableReferenceMetadata)context.createMetadata(MutableReferenceMetadata.class);
        if (element.hasAttribute(ID_ATTRIBUTE)) {
            metadata.setId(element.getAttribute(ID_ATTRIBUTE));
        } else {
            metadata.setId(this.generateId(context));
        }
        metadata.setAvailability(CARDINALITY_0_1.equals(element.getAttribute(CARDINALITY_ATTRIBUTE)) ? 2 : 1);
        metadata.setTimeout(this.getLong(element.getAttribute(TIMEOUT_ATTRIBUTE), 300000L));
        metadata.setInterface(element.getAttribute(INTERFACE_ATTRIBUTE));
        metadata.setFilter(element.getAttribute(FILTER_ATTRIBUTE));
        String[] dependsOn = StringUtils.tokenizeToStringArray((String)element.getAttribute(DEPENDS_ON_ATTRIBUTE), (String)",; ");
        metadata.setDependsOn(dependsOn != null ? Arrays.asList(dependsOn) : null);
        metadata.setComponentName(element.getAttribute(BEAN_NAME_ELEMENT));
        for (Element child : this.getChildren(element)) {
            if (element.getNamespaceURI().equals(child.getNamespaceURI())) {
                if ("interfaces".equals(child.getLocalName())) {
                    List<String> itfs = this.parseInterfaces(child);
                    metadata.setExtraInterfaces(itfs);
                    continue;
                }
                if (!LISTENER_ELEMENT.equals(child.getLocalName())) continue;
                String bindMethod = this.nonEmpty(child.getAttribute(BIND_METHOD_ATTRIBUTE));
                String unbindMethod = this.nonEmpty(child.getAttribute(UNBIND_METHOD_ATTRIBUTE));
                String refStr = this.nonEmpty(child.getAttribute(REF_ATTRIBUTE));
                MutableRefMetadata listenerComponent = null;
                if (refStr != null) {
                    MutableRefMetadata ref = (MutableRefMetadata)context.createMetadata(MutableRefMetadata.class);
                    ref.setComponentId(refStr);
                    listenerComponent = ref;
                }
                for (Element cchild : this.getChildren(child)) {
                    if (listenerComponent != null) {
                        throw new IllegalArgumentException("Only one of @ref attribute or inlined bean definition element is allowed");
                    }
                    listenerComponent = this.parseInlinedTarget(context, (ComponentMetadata)metadata, cchild);
                }
                if (listenerComponent == null) {
                    throw new IllegalArgumentException("Missing @ref attribute or inlined bean definition element");
                }
                metadata.addServiceListener((Target)listenerComponent, bindMethod, unbindMethod);
                continue;
            }
            throw new UnsupportedOperationException("Custom namespaces not supported");
        }
        return metadata;
    }

    private Target parseInlinedTarget(ParserContext context, ComponentMetadata metadata, Element element) {
        Target listenerComponent;
        if (BLUEPRINT_NAMESPACE.equals(element.getNamespaceURI()) && BEAN_ELEMENT.equals(element.getLocalName())) {
            listenerComponent = (Target)context.parseElement(BeanMetadata.class, metadata, element);
        } else {
            NamespaceHandler handler = context.getNamespaceHandler(URI.create(element.getNamespaceURI()));
            if (handler == null) {
                throw new IllegalStateException("No NamespaceHandler found for " + element.getNamespaceURI());
            }
            Metadata md = handler.parse(element, context);
            if (!(md instanceof Target)) {
                throw new IllegalStateException("NamespaceHandler did not return a Target instance but " + md);
            }
            listenerComponent = (Target)md;
        }
        return listenerComponent;
    }

    private List<String> parseInterfaces(Element element) {
        ArrayList<String> extra = new ArrayList<String>();
        for (Element e : this.getChildren(element)) {
            if ("value".equals(e.getLocalName())) {
                extra.add(SpringOsgiNamespaceHandler.getTextValue(e));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported child: " + element.getLocalName());
        }
        return extra;
    }

    private String nonEmpty(String ref) {
        return ref != null && ref.isEmpty() ? null : ref;
    }

    private String generateId(ParserContext context) {
        String id;
        do {
            id = ".spring-osgi-" + ++this.idCounter;
        } while (context.getComponentDefinitionRegistry().containsComponentDefinition(id));
        return id;
    }

    public ComponentMetadata decorate(Node node, ComponentMetadata component, ParserContext context) {
        return component;
    }

    private List<Element> getChildren(Element element) {
        ArrayList<Element> children = new ArrayList<Element>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            children.add((Element)child);
        }
        return children;
    }

    private long getLong(String str, long def) {
        if (str == null || str.isEmpty()) {
            return def;
        }
        return Long.parseLong(str);
    }

    public static String getTextValue(Element valueEle) {
        Assert.notNull((Object)valueEle, (String)"Element must not be null");
        StringBuilder sb = new StringBuilder();
        NodeList nl = valueEle.getChildNodes();
        int l = nl.getLength();
        for (int i = 0; i < l; ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            sb.append(item.getNodeValue());
        }
        return sb.toString();
    }
}

