/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.spring.extender;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.SpringVersion;

public class SpringXsdVersionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringXsdVersionResolver.class);
    private static final String DEFAULT_VERSION = "4.3";
    private static final Pattern PATTERN = Pattern.compile("^\\d*\\.\\d*");

    public static String resolve() {
        Matcher matcher;
        String fullVersion = SpringVersion.getVersion();
        if (fullVersion != null && (matcher = PATTERN.matcher(fullVersion)).find()) {
            return matcher.group(0);
        }
        LOGGER.trace("Could not resolve xsd version from Spring's version {}", (Object)fullVersion);
        return DEFAULT_VERSION;
    }
}

