/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.apache.aries.jpa.container.ManagedPersistenceUnitInfo;
import org.apache.aries.jpa.container.impl.InvalidPersistenceUnitException;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.apache.aries.jpa.container.quiesce.impl.DestroyCallback;
import org.apache.aries.jpa.container.quiesce.impl.EMFProxyFactory;
import org.apache.aries.jpa.container.quiesce.impl.NamedCallback;
import org.apache.aries.jpa.container.quiesce.impl.QuiesceEMF;
import org.apache.aries.util.AriesFrameworkUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerFactoryManager
implements ServiceTrackerCustomizer {
    public static final String DATA_SOURCE_NAME = "org.apache.aries.jpa.data.source.name";
    public static final String DATA_SOURCE_NAME_JTA = "org.apache.aries.jpa.data.source.name.jta";
    private final BundleContext containerContext;
    private final Bundle bundle;
    private ServiceReference provider;
    private Map<String, ? extends ManagedPersistenceUnitInfo> persistenceUnits;
    private Collection<ParsedPersistenceUnit> parsedData;
    private Map<String, EntityManagerFactory> emfs = null;
    private ConcurrentMap<String, ServiceRegistration> registrations = null;
    private boolean quiesce = false;
    private volatile ServiceTracker jndiTracker;
    private volatile ServiceTracker dataSourceFactoriesTracker;
    private final ConcurrentMap<String, Collection<String>> dataSourceFactories = new ConcurrentHashMap<String, Collection<String>>();
    private final ConcurrentMap<String, Collection<String>> jndiServices = new ConcurrentHashMap<String, Collection<String>>();
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container");

    public EntityManagerFactoryManager(BundleContext containerCtx, Bundle b) {
        this.containerContext = containerCtx;
        this.bundle = b;
    }

    private Map<String, ? extends ManagedPersistenceUnitInfo> getInfoMap(Collection<? extends ManagedPersistenceUnitInfo> infos) {
        Map<String, ManagedPersistenceUnitInfo> map = Collections.synchronizedMap(new HashMap());
        if (infos != null) {
            for (ManagedPersistenceUnitInfo managedPersistenceUnitInfo : infos) {
                map.put(managedPersistenceUnitInfo.getPersistenceUnitInfo().getPersistenceUnitName(), managedPersistenceUnitInfo);
            }
        }
        return map;
    }

    public synchronized boolean providerRemoved(ServiceReference ref) {
        boolean toReturn = false;
        if (this.provider != null) {
            toReturn = this.provider.equals(ref);
        }
        if (toReturn) {
            this.destroy();
        }
        return toReturn;
    }

    public synchronized void bundleStateChange() throws InvalidPersistenceUnitException {
        switch (this.bundle.getState()) {
            case 4: {
                this.unregisterEntityManagerFactories();
                break;
            }
            case 8: 
            case 32: {
                if (this.dataSourceFactoriesTracker == null) {
                    this.dataSourceFactoriesTracker = new ServiceTracker(this.bundle.getBundleContext(), "org.osgi.service.jdbc.DataSourceFactory", (ServiceTrackerCustomizer)this);
                    this.dataSourceFactoriesTracker.open();
                }
                if (this.jndiTracker == null) {
                    try {
                        this.jndiTracker = new ServiceTracker(this.bundle.getBundleContext(), FrameworkUtil.createFilter((String)"(osgi.jndi.service.name=*)"), (ServiceTrackerCustomizer)this);
                        this.jndiTracker.open();
                    }
                    catch (InvalidSyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                ExecutorService executor = Executors.newSingleThreadExecutor();
                Future<Void> result = executor.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws InvalidPersistenceUnitException {
                        EntityManagerFactoryManager.this.registerEntityManagerFactories();
                        return null;
                    }
                });
                executor.shutdown();
                this.handleCreationResult(result);
                break;
            }
            case 16: {
                this.quiesce = false;
                if (this.jndiTracker != null) {
                    this.jndiTracker.close();
                    this.jndiTracker = null;
                }
                if (this.dataSourceFactoriesTracker != null) {
                    this.dataSourceFactoriesTracker.close();
                    this.dataSourceFactoriesTracker = null;
                }
                this.unregisterEntityManagerFactories();
                break;
            }
            case 2: {
                this.destroyEntityManagerFactories();
            }
        }
    }

    private void handleCreationResult(Future<Void> result) throws InvalidPersistenceUnitException {
        try {
            result.get(5000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            _logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidPersistenceUnitException) {
                throw (InvalidPersistenceUnitException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
        }
        catch (TimeoutException e) {
            _logger.info("EntityManagerFactory creation takes long. Continuing in background", (Throwable)e);
        }
    }

    private void unregisterEntityManagerFactories() {
        if (this.registrations != null) {
            for (Map.Entry entry : this.registrations.entrySet()) {
                AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)((ServiceRegistration)entry.getValue()));
                this.clearQuiesce(this.emfs.get(entry.getKey()));
                this.persistenceUnits.get(entry.getKey()).unregistered();
            }
            this.registrations = null;
        }
    }

    private void unregisterEntityManagerFactory(String unit) {
        if (this.registrations != null) {
            AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)((ServiceRegistration)this.registrations.remove(unit)));
            this.clearQuiesce(this.emfs.get(unit));
            this.persistenceUnits.get(unit).unregistered();
        }
    }

    private void clearQuiesce(EntityManagerFactory emf) {
        if (emf instanceof QuiesceEMF) {
            ((QuiesceEMF)emf).clearQuiesce();
        }
    }

    private void registerEntityManagerFactories() throws InvalidPersistenceUnitException {
        if (this.registrations == null) {
            this.registrations = new ConcurrentHashMap<String, ServiceRegistration>();
        }
        if (this.provider != null && !this.quiesce) {
            this.createEntityManagerFactories();
            String providerName = (String)this.provider.getProperty("javax.persistence.provider");
            if (providerName == null) {
                _logger.warn(NLS.MESSAGES.getMessage("no.provider.specified", new Object[]{this.bundle.getSymbolicName() + '/' + this.bundle.getVersion(), "osgi.unit.provider", this.provider}));
            }
            for (Map.Entry<String, EntityManagerFactory> entry : this.emfs.entrySet()) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                String unitName = entry.getKey();
                if (this.registrations.containsKey(unitName) || !this.availableDataSourceFactory(unitName) || !this.availableJndiService(unitName)) continue;
                props.put("osgi.unit.name", unitName);
                if (providerName != null) {
                    props.put("osgi.unit.provider", providerName);
                }
                props.put("osgi.unit.version", this.bundle.getVersion());
                props.put("org.apache.aries.jpa.container.managed", Boolean.TRUE);
                props.put("org.apache.aries.jpa.default.unit.name", "".equals(unitName));
                try {
                    this.registrations.put(unitName, this.bundle.getBundleContext().registerService(EntityManagerFactory.class.getCanonicalName(), (Object)entry.getValue(), props));
                    this.persistenceUnits.get(unitName).registered();
                }
                catch (Exception e) {
                    _logger.error(NLS.MESSAGES.getMessage("cannot.register.persistence.unit", new Object[]{unitName, this.bundle.getSymbolicName() + '/' + this.bundle.getVersion()}));
                    throw new InvalidPersistenceUnitException(e);
                }
            }
        }
    }

    private boolean availableJndiService(String unitName) {
        String jtaDsName;
        ManagedPersistenceUnitInfo mpui = this.persistenceUnits.get(unitName);
        String dsName = (String)mpui.getContainerProperties().get(DATA_SOURCE_NAME);
        if (dsName != null && dsName.startsWith("osgi:service/")) {
            String jndi = dsName.substring("osgi:service/".length());
            if (this.jndiServices.containsKey(jndi)) {
                ((Collection)this.jndiServices.get(jndi)).add(unitName);
                if (_logger.isDebugEnabled()) {
                    _logger.debug(NLS.MESSAGES.getMessage("jndiservice.found", new Object[]{unitName, this.bundle.getSymbolicName(), this.bundle.getVersion(), jndi}));
                }
            } else {
                _logger.debug(NLS.MESSAGES.getMessage("jndiservice.not.found", new Object[]{unitName, this.bundle.getSymbolicName(), this.bundle.getVersion(), jndi}));
                return false;
            }
        }
        if ((jtaDsName = (String)mpui.getContainerProperties().get(DATA_SOURCE_NAME_JTA)) != null && jtaDsName.startsWith("osgi:service/")) {
            String jndi = jtaDsName.substring("osgi:service/".length());
            if (this.jndiServices.containsKey(jndi)) {
                ((Collection)this.jndiServices.get(jndi)).add(unitName);
                if (_logger.isDebugEnabled()) {
                    _logger.debug(NLS.MESSAGES.getMessage("jndiservice.found", new Object[]{unitName, this.bundle.getSymbolicName(), this.bundle.getVersion(), jndi}));
                }
            } else {
                _logger.debug(NLS.MESSAGES.getMessage("jndiservice.not.found", new Object[]{unitName, this.bundle.getSymbolicName(), this.bundle.getVersion(), jndi}));
                return false;
            }
        }
        return true;
    }

    private boolean availableDataSourceFactory(String unitName) {
        ManagedPersistenceUnitInfo mpui = this.persistenceUnits.get(unitName);
        String driver = (String)mpui.getPersistenceUnitInfo().getProperties().get("org.apache.aries.jpa.data.source.factory.class");
        if (Boolean.parseBoolean((String)mpui.getContainerProperties().get("org.apache.aries.jpa.use.data.source.factory")) && driver != null) {
            if (this.dataSourceFactories.containsKey(driver)) {
                ((Collection)this.dataSourceFactories.get(driver)).add(unitName);
                if (_logger.isDebugEnabled()) {
                    _logger.debug(NLS.MESSAGES.getMessage("datasourcefactory.found", new Object[]{unitName, this.bundle.getSymbolicName(), this.bundle.getVersion(), driver}));
                }
                return true;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug(NLS.MESSAGES.getMessage("datasourcefactory.not.found", new Object[]{unitName, this.bundle.getSymbolicName(), this.bundle.getVersion(), driver}));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEntityManagerFactories() throws InvalidPersistenceUnitException {
        if (this.emfs == null) {
            this.emfs = new HashMap<String, EntityManagerFactory>();
        }
        if (this.provider == null || !this.emfs.isEmpty() || this.quiesce) {
            return;
        }
        try {
            PersistenceProvider providerService = (PersistenceProvider)this.containerContext.getService(this.provider);
            if (providerService == null) {
                _logger.warn(NLS.MESSAGES.getMessage("persistence.provider.gone.awol", new Object[]{this.bundle.getSymbolicName() + '/' + this.bundle.getVersion()}));
                throw new InvalidPersistenceUnitException();
            }
            for (String unitName : this.persistenceUnits.keySet()) {
                ManagedPersistenceUnitInfo mpui = this.persistenceUnits.get(unitName);
                try {
                    EntityManagerFactory emf = providerService.createContainerEntityManagerFactory(mpui.getPersistenceUnitInfo(), mpui.getContainerProperties());
                    EntityManagerFactory emfProxy = EMFProxyFactory.createProxy(emf, unitName);
                    this.emfs.put(unitName, emfProxy);
                }
                catch (Exception e) {
                    _logger.warn("Error creating EntityManagerFactory", (Throwable)e);
                }
            }
        }
        finally {
            this.containerContext.ungetService(this.provider);
        }
    }

    public synchronized void manage(ServiceReference ref, Collection<? extends ManagedPersistenceUnitInfo> infos) throws IllegalStateException {
        this.provider = ref;
        this.persistenceUnits = this.getInfoMap(infos);
    }

    public synchronized void manage(Collection<ParsedPersistenceUnit> parsedUnits, ServiceReference ref, Collection<? extends ManagedPersistenceUnitInfo> infos) throws IllegalStateException {
        this.parsedData = parsedUnits;
        this.provider = ref;
        this.persistenceUnits = this.getInfoMap(infos);
    }

    public synchronized void destroy() {
        this.destroyEntityManagerFactories();
        this.provider = null;
        this.persistenceUnits = null;
        if (this.jndiTracker != null) {
            this.jndiTracker.close();
            this.jndiTracker = null;
        }
        if (this.dataSourceFactoriesTracker != null) {
            this.dataSourceFactoriesTracker.close();
            this.dataSourceFactoriesTracker = null;
        }
    }

    private void destroyEntityManagerFactories() {
        if (this.registrations != null) {
            this.unregisterEntityManagerFactories();
        }
        if (this.emfs != null) {
            for (Map.Entry<String, EntityManagerFactory> entry : this.emfs.entrySet()) {
                try {
                    entry.getValue().close();
                }
                catch (Exception e) {
                    _logger.error(NLS.MESSAGES.getMessage("could.not.close.persistence.unit", new Object[]{entry.getKey(), this.bundle.getSymbolicName() + '/' + this.bundle.getVersion()}), (Throwable)e);
                }
            }
        }
        this.emfs = null;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Collection<ParsedPersistenceUnit> getParsedPersistenceUnits() {
        return this.parsedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce(DestroyCallback countdown) {
        HashMap<EntityManagerFactory, ServiceRegistration> entries = new HashMap<EntityManagerFactory, ServiceRegistration>();
        ArrayList<String> names = new ArrayList<String>();
        EntityManagerFactoryManager entityManagerFactoryManager = this;
        synchronized (entityManagerFactoryManager) {
            if ((this.bundle.getState() & 0x28) != 0) {
                this.quiesce = true;
            }
            if (this.emfs != null) {
                for (String string : this.emfs.keySet()) {
                    entries.put(this.emfs.get(string), this.registrations != null ? (ServiceRegistration)this.registrations.get(string) : null);
                    names.add(string);
                }
            }
        }
        if (entries.isEmpty()) {
            countdown.callback();
        } else {
            NamedCallback callback = new NamedCallback(names, countdown);
            for (Map.Entry entry : entries.entrySet()) {
                this.quiesce((EntityManagerFactory)entry.getKey(), callback, (ServiceRegistration)entry.getValue());
            }
        }
    }

    private void quiesce(EntityManagerFactory emf, NamedCallback callback, ServiceRegistration reg) {
        if (emf instanceof QuiesceEMF) {
            ((QuiesceEMF)emf).quiesce(callback, reg);
        }
    }

    public StringBuffer addingService(ServiceReference reference) {
        Object driverClass = reference.getProperty("osgi.jdbc.driver.class");
        if (driverClass != null) {
            StringBuffer sb = new StringBuffer(String.valueOf(reference.getProperty("osgi.jdbc.driver.class")));
            if (this.dataSourceFactories.putIfAbsent(sb.toString(), new ArrayList()) == null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug(NLS.MESSAGES.getMessage("new.datasourcefactory.available", new Object[]{sb.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
                }
                try {
                    this.bundleStateChange();
                }
                catch (InvalidPersistenceUnitException e) {
                    _logger.warn(NLS.MESSAGES.getMessage("new.datasourcefactory.error", new Object[]{sb.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion()}), (Throwable)e);
                }
            }
            return sb;
        }
        Object jndiName = reference.getProperty("osgi.jndi.service.name");
        if (jndiName != null) {
            StringBuffer sb = new StringBuffer(String.valueOf(jndiName));
            if (this.jndiServices.putIfAbsent(sb.toString(), new ArrayList()) == null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug(NLS.MESSAGES.getMessage("new.jndiservice.available", new Object[]{sb.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
                }
                try {
                    this.bundleStateChange();
                }
                catch (InvalidPersistenceUnitException e) {
                    _logger.warn(NLS.MESSAGES.getMessage("new.jndiservice.error", new Object[]{sb.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion()}), (Throwable)e);
                }
            }
            return sb;
        }
        throw new IllegalStateException();
    }

    public void modifiedService(ServiceReference reference, Object service) {
        if (reference.getProperty("osgi.jdbc.driver.class") != null) {
            if (!service.toString().equals(reference.getProperty("osgi.jdbc.driver.class"))) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug(NLS.MESSAGES.getMessage("changed.datasourcefactory.available", new Object[]{service.toString(), reference.getProperty("osgi.jdbc.driver.class"), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
                }
                this.removedService(reference, service);
                StringBuffer sb = (StringBuffer)service;
                sb.delete(0, sb.length());
                sb.append(this.addingService(reference));
            }
        } else if (reference.getProperty("osgi.jndi.service.name") != null && !service.toString().equals(reference.getProperty("osgi.jndi.service.name"))) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(NLS.MESSAGES.getMessage("changed.jndiservice.available", new Object[]{service.toString(), reference.getProperty("osgi.jndi.service.name"), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
            }
            this.removedService(reference, service);
            StringBuffer sb = (StringBuffer)service;
            sb.delete(0, sb.length());
            sb.append(this.addingService(reference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        if (reference.getProperty("osgi.jdbc.driver.class") != null) {
            Collection units;
            if (_logger.isDebugEnabled()) {
                _logger.debug(NLS.MESSAGES.getMessage("datasourcefactory.unavailable", new Object[]{service.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
            }
            Object[] objects = this.dataSourceFactoriesTracker.getServices();
            boolean gone = true;
            if (objects != null) {
                for (Object o : objects) {
                    if (!service.equals(o)) continue;
                    gone = false;
                    break;
                }
            }
            if (gone && (units = (Collection)this.dataSourceFactories.remove(service.toString())) != null) {
                EntityManagerFactoryManager entityManagerFactoryManager = this;
                synchronized (entityManagerFactoryManager) {
                    if (_logger.isInfoEnabled()) {
                        _logger.info(NLS.MESSAGES.getMessage("in.use.datasourcefactory.unavailable", new Object[]{service.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion(), units}));
                    }
                    for (String unit : units) {
                        this.unregisterEntityManagerFactory(unit);
                    }
                }
            }
        } else if (reference.getProperty("osgi.jndi.service.name") != null) {
            Object units;
            if (_logger.isDebugEnabled()) {
                _logger.debug(NLS.MESSAGES.getMessage("jndiservice.unavailable", new Object[]{service.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion()}));
            }
            Object[] objects = this.jndiTracker.getServices();
            boolean gone = true;
            if (objects != null) {
                units = objects;
                int n = ((Object[])units).length;
                for (int i = 0; i < n; ++i) {
                    Object o = units[i];
                    if (!service.equals(o)) continue;
                    gone = false;
                    break;
                }
            }
            if (gone && (units = (Collection)this.jndiServices.remove(service.toString())) != null) {
                EntityManagerFactoryManager entityManagerFactoryManager = this;
                synchronized (entityManagerFactoryManager) {
                    if (_logger.isInfoEnabled()) {
                        _logger.info(NLS.MESSAGES.getMessage("in.use.jndiservice.unavailable", new Object[]{service.toString(), this.bundle.getSymbolicName(), this.bundle.getVersion(), units}));
                    }
                    Iterator iterator = units.iterator();
                    while (iterator.hasNext()) {
                        String unit = (String)iterator.next();
                        this.unregisterEntityManagerFactory(unit);
                    }
                }
            }
        }
    }
}

