/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

public class AriesEntityManagerFactoryBuilder
implements EntityManagerFactoryBuilder {
    private static final String JAVAX_PERSISTENCE_JDBC_DRIVER = "javax.persistence.jdbc.driver";
    private PersistenceProvider provider;
    private PersistenceUnitInfo persistenceUnit;
    private String driver;

    public AriesEntityManagerFactoryBuilder(PersistenceProvider provider, PersistenceUnitInfo persistenceUnit) {
        this.provider = provider;
        this.persistenceUnit = persistenceUnit;
        this.driver = (String)persistenceUnit.getProperties().get(JAVAX_PERSISTENCE_JDBC_DRIVER);
    }

    public EntityManagerFactory createEntityManagerFactory(Map<String, Object> props) {
        String newDriver = (String)props.get(JAVAX_PERSISTENCE_JDBC_DRIVER);
        if (this.driver == null) {
            this.driver = newDriver;
        } else if (newDriver != null && !newDriver.equals(this.driver)) {
            throw new IllegalArgumentException("Can not rebind to a different database driver");
        }
        return this.provider.createContainerEntityManagerFactory(this.persistenceUnit, props);
    }
}

