/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.Dictionary;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.aries.jpa.container.impl.AriesEntityManagerFactoryBuilder;
import org.apache.aries.jpa.container.impl.DSFTracker;
import org.apache.aries.jpa.container.impl.DataSourceTracker;
import org.apache.aries.jpa.container.impl.ManagedEMF;
import org.apache.aries.jpa.container.impl.StoredPerProvider;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.apache.aries.jpa.container.weaving.impl.DummyDataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceProviderTracker
extends ServiceTracker<PersistenceProvider, StoredPerProvider> {
    private static final String JAVAX_PERSISTENCE_PROVIDER = "javax.persistence.provider";
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceProviderTracker.class);
    private PersistenceUnit punit;

    public PersistenceProviderTracker(BundleContext context, PersistenceUnit punit) {
        super(context, PersistenceProviderTracker.createFilter(context, punit), null);
        this.punit = punit;
    }

    private static Filter createFilter(BundleContext context, PersistenceUnit punit) {
        String filter = punit.getPersistenceProviderClassName() != null ? String.format("(&(objectClass=%s)(%s=%s))", PersistenceProvider.class.getName(), JAVAX_PERSISTENCE_PROVIDER, punit.getPersistenceProviderClassName()) : String.format("(objectClass=%s)", PersistenceProvider.class.getName());
        try {
            return context.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public StoredPerProvider addingService(ServiceReference<PersistenceProvider> reference) {
        String providerName = (String)reference.getProperty(JAVAX_PERSISTENCE_PROVIDER);
        if (this.punit.getPersistenceProviderClassName() == null) {
            this.punit.setProviderClassName(providerName);
        }
        StoredPerProvider stored = new StoredPerProvider();
        LOGGER.info("Found provider for " + this.punit.getPersistenceUnitName() + " " + this.punit.getPersistenceProviderClassName());
        PersistenceProvider provider = (PersistenceProvider)this.context.getService(reference);
        this.createAndCloseDummyEMF(provider);
        stored.dsTracker = this.createDataSourceTracker(provider);
        AriesEntityManagerFactoryBuilder emfBuilder = new AriesEntityManagerFactoryBuilder(provider, this.punit);
        Dictionary<String, String> props = ManagedEMF.createProperties(this.punit, this.punit.getBundle());
        stored.reg = this.context.registerService(EntityManagerFactoryBuilder.class, (Object)emfBuilder, props);
        return stored;
    }

    private void createAndCloseDummyEMF(PersistenceProvider provider) {
        DummyDataSource dummyDataSource = new DummyDataSource();
        this.punit.setJtaDataSource(dummyDataSource);
        this.punit.setNonJtaDataSource(dummyDataSource);
        try {
            EntityManagerFactory emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.punit, null);
            emf.close();
        }
        catch (Exception e) {
            LOGGER.debug("Error while creating the Dummy EntityManagerFactory to allow weaving.", (Throwable)e);
        }
        this.punit.setJtaDataSource(null);
        this.punit.setNonJtaDataSource(null);
    }

    private ServiceTracker<?, ?> createDataSourceTracker(PersistenceProvider provider) {
        if (this.usesDataSource()) {
            if (!this.usesDataSourceService()) {
                LOGGER.warn("Persistence unit " + this.punit.getPersistenceUnitName() + " refers to a non OSGi service DataSource");
                return null;
            }
            DataSourceTracker dsTracker = new DataSourceTracker(this.context, provider, this.punit);
            dsTracker.open();
            return dsTracker;
        }
        if (this.usesDSF()) {
            DSFTracker dsfTracker = new DSFTracker(this.context, provider, this.punit);
            dsfTracker.open();
            return dsfTracker;
        }
        LOGGER.debug("Persistence unit " + this.punit.getPersistenceUnitName() + " does not refer a DataSource. " + "It can only be used with EntityManagerFactoryBuilder.");
        return null;
    }

    private boolean usesDataSource() {
        return this.punit.getJtaDataSourceName() != null || this.punit.getNonJtaDataSourceName() != null;
    }

    private boolean usesDSF() {
        return DSFTracker.getDriverName(this.punit) != null;
    }

    private boolean usesDataSourceService() {
        return this.punit.getJtaDataSourceName() != null && this.punit.getJtaDataSourceName().startsWith("osgi:service/javax.sql.DataSource") || this.punit.getNonJtaDataSourceName() != null && this.punit.getNonJtaDataSourceName().startsWith("osgi:service/javax.sql.DataSource");
    }

    public void removedService(ServiceReference<PersistenceProvider> reference, StoredPerProvider stored) {
        LOGGER.info("Lost provider for " + this.punit.getPersistenceUnitName() + " " + this.punit.getPersistenceProviderClassName());
        if (stored.dsTracker != null) {
            stored.dsTracker.close();
        }
        stored.reg.unregister();
        super.removedService(reference, (Object)stored);
    }
}

