/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parser.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JPAHandler
extends DefaultHandler {
    private final Deque<PersistenceUnit> persistenceUnits = new ArrayDeque<PersistenceUnit>();
    private String elementName;
    private StringBuilder builder = new StringBuilder();
    private Bundle bundle;

    public JPAHandler(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.builder.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String string = this.elementName = localName == null || "".equals(localName) ? name : localName;
        if ("persistence-unit".equals(this.elementName)) {
            String tranTypeSt = attributes.getValue("transaction-type");
            PersistenceUnitTransactionType tranType = tranTypeSt == null ? null : PersistenceUnitTransactionType.valueOf((String)tranTypeSt);
            this.persistenceUnits.push(new PersistenceUnit(this.bundle, attributes.getValue("name"), tranType));
        } else if ("exclude-unlisted-classes".equals(this.elementName)) {
            this.persistenceUnits.peek().setExcludeUnlisted(true);
        } else if ("property".equals(this.elementName)) {
            this.persistenceUnits.peek().addProperty(attributes.getValue("name"), attributes.getValue("value"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        String s = this.builder.toString().trim();
        this.builder = new StringBuilder();
        if ("".equals(s)) {
            return;
        }
        PersistenceUnit pu = this.persistenceUnits.peek();
        if ("provider".equals(this.elementName)) {
            pu.setProviderClassName(s);
        } else if ("jta-data-source".equals(this.elementName)) {
            pu.setJtaDataSourceName(s);
        } else if ("non-jta-data-source".equals(this.elementName)) {
            pu.setNonJtaDataSourceName(s);
        } else if ("class".equals(this.elementName)) {
            pu.addClassName(s);
        } else if ("exclude-unlisted-classes".equals(this.elementName)) {
            pu.setExcludeUnlisted(Boolean.parseBoolean(s));
        } else if ("shared-cache-mode".equals(this.elementName)) {
            pu.setSharedCacheMode(SharedCacheMode.valueOf((String)s));
        } else if ("validation-mode".equals(this.elementName)) {
            pu.setValidationMode(ValidationMode.valueOf((String)s));
        }
    }

    @Override
    public void error(SAXParseException spe) throws SAXException {
        throw spe;
    }

    public Collection<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits;
    }
}

