/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parser.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.parser.impl.JPAAnnotationScanner;
import org.apache.aries.jpa.container.parser.impl.TempBundleDelegatingClassLoader;
import org.apache.aries.jpa.container.weaving.impl.TransformerRegistry;
import org.apache.aries.jpa.container.weaving.impl.TransformerRegistrySingleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class PersistenceUnit
implements PersistenceUnitInfo {
    private Bundle bundle;
    private ClassLoader classLoader;
    private Set<String> classNames;
    private boolean excludeUnlisted;
    private DataSource jtaDataSource;
    private String jtaDataSourceName;
    private DataSource nonJtaDataSource;
    private String nonJtaDataSourceName;
    private String persistenceProviderClassName;
    private String persistenceUnitName;
    private String persistenceXMLSchemaVersion;
    private Properties props;
    private SharedCacheMode sharedCacheMode = SharedCacheMode.UNSPECIFIED;
    private PersistenceUnitTransactionType transactionType;
    private ValidationMode validationMode = ValidationMode.NONE;

    public PersistenceUnit(Bundle bundle, String persistenceUnitName, PersistenceUnitTransactionType transactionType) {
        this.bundle = bundle;
        this.persistenceUnitName = persistenceUnitName;
        this.transactionType = transactionType;
        this.props = new Properties();
        this.classLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        this.classNames = new HashSet<String>();
    }

    public void addClassName(String className) {
        this.classNames.add(className);
    }

    public void addProperty(String name, String value) {
        this.props.put(name, value);
    }

    public void addTransformer(ClassTransformer transformer) {
        TransformerRegistry reg = TransformerRegistrySingleton.get();
        reg.addTransformer(this.bundle, transformer);
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlisted;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<URL> getJarFileUrls() {
        return Collections.emptyList();
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public String getJtaDataSourceName() {
        return this.jtaDataSourceName;
    }

    public List<String> getManagedClassNames() {
        return new ArrayList<String>(this.classNames);
    }

    public List<String> getMappingFileNames() {
        return Collections.emptyList();
    }

    public String getName() {
        return this.persistenceUnitName;
    }

    public ClassLoader getNewTempClassLoader() {
        return new TempBundleDelegatingClassLoader(this.bundle, this.classLoader);
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public String getNonJtaDataSourceName() {
        return this.nonJtaDataSourceName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.bundle.getResource("/");
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.persistenceXMLSchemaVersion;
    }

    public Properties getProperties() {
        return this.props;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public boolean isExcludeUnlisted() {
        return this.excludeUnlisted;
    }

    public void setExcludeUnlisted(boolean excludeUnlisted) {
        this.excludeUnlisted = excludeUnlisted;
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    public void setJtaDataSourceName(String jtaDataSourceName) {
        this.jtaDataSourceName = jtaDataSourceName;
    }

    public void setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public void setNonJtaDataSourceName(String nonJtaDataSourceName) {
        this.nonJtaDataSourceName = nonJtaDataSourceName;
    }

    public void setProviderClassName(String providerClassName) {
        this.persistenceProviderClassName = providerClassName;
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public void addAnnotated() {
        if (!this.excludeUnlistedClasses()) {
            Collection<String> detected = JPAAnnotationScanner.findJPAAnnotatedClasses(this.bundle);
            for (String name : detected) {
                this.addClassName(name);
            }
        }
    }
}

