/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.impl.AriesEntityManagerFactoryBuilder;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceTracker
extends ServiceTracker<DataSource, DataSource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceTracker.class);
    static final String DS_PREFIX = "osgi:service/javax.sql.DataSource";
    private final AriesEntityManagerFactoryBuilder builder;
    private final String dsName;

    public DataSourceTracker(BundleContext context, AriesEntityManagerFactoryBuilder builder, String dsName) {
        super(context, DataSourceTracker.createFilter(context, dsName, builder.getPUName()), null);
        this.builder = builder;
        this.dsName = dsName;
    }

    static Filter createFilter(BundleContext context, String dsName, String puName) {
        if (dsName == null) {
            throw new IllegalArgumentException("No DataSource supplied in persistence.xml");
        }
        String subFilter = DataSourceTracker.getSubFilter(dsName);
        String filter = String.format("(&(objectClass=%s)%s)", DataSource.class.getName(), subFilter);
        LOGGER.info("Tracking DataSource for punit " + puName + " with filter " + filter);
        try {
            return context.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String getSubFilter(String dsName) {
        if (dsName.startsWith(DS_PREFIX)) {
            return dsName.length() > DS_PREFIX.length() + 1 ? dsName.substring(DS_PREFIX.length() + 1) : "(osgi.jndi.service.name=*)";
        }
        return "(osgi.jndi.service.name=" + dsName + ")";
    }

    static String getDsName(PersistenceUnit punit) {
        return punit.getTransactionType() == PersistenceUnitTransactionType.JTA ? punit.getJtaDataSourceName() : punit.getNonJtaDataSourceName();
    }

    public DataSource addingService(ServiceReference<DataSource> reference) {
        LOGGER.info("Found DataSource for " + this.builder.getPUName() + " " + this.dsName);
        DataSource ds = (DataSource)super.addingService(reference);
        if (ds != null) {
            this.builder.foundDS(ds);
        }
        return ds;
    }

    public void removedService(ServiceReference<DataSource> reference, DataSource ds) {
        LOGGER.info("Lost DataSource for " + this.builder.getPUName() + " " + this.dsName);
        this.builder.lostDS(ds, (DataSource)this.getService());
        super.removedService(reference, (Object)ds);
    }
}

