/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.jpa.container.impl.AriesEntityManagerFactoryBuilder;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedEMF
implements ManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedEMF.class);
    private final AriesEntityManagerFactoryBuilder builder;
    private final String pUnitName;
    private final AtomicBoolean configured = new AtomicBoolean(false);

    public ManagedEMF(AriesEntityManagerFactoryBuilder builder, String name) {
        this.builder = builder;
        this.pUnitName = name;
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            if (this.configured.getAndSet(false)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("The configuration has been deleted for persistence unit {}. Destroying the EMF", (Object)this.pUnitName);
                }
                this.builder.closeEMF();
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ignoring the unset configuration for persistence unit {}", (Object)this.pUnitName);
                }
                return;
            }
        }
        Map<String, Object> overrides = properties != null ? this.asMap(properties) : null;
        LOGGER.info("Configuration received for persistence unit {}", (Object)this.pUnitName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using properties override {}", overrides);
        }
        this.builder.createEntityManagerFactory(overrides);
        this.configured.set(true);
    }

    private Map<String, Object> asMap(Dictionary<String, ?> dict) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> e = dict.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            map.put(key, dict.get(key));
        }
        return map;
    }
}

