/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.eclipselink.adapter;

import java.lang.reflect.Constructor;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.spi.PersistenceProvider;
import org.apache.aries.jpa.eclipselink.adapter.EclipseLinkPersistenceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
BundleListener {
    public static final String ECLIPSELINK_JPA_PROVIDER_BUNDLE_SYMBOLIC_NAME = "org.eclipse.persistence.jpa";
    public static final String ECLIPSELINK_JPA_PROVIDER_CLASS_NAME = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final Logger LOG = LoggerFactory.getLogger(Activator.class);
    private final ConcurrentMap<Bundle, ServiceRegistration<?>> registeredProviders = new ConcurrentHashMap();
    private BundleContext context;

    public void start(BundleContext ctx) {
        LOG.debug("Starting EclipseLink adapter");
        this.context = ctx;
        ctx.addBundleListener((BundleListener)this);
        for (Bundle b : ctx.getBundles()) {
            if ((b.getState() & 0x3C) == 0) continue;
            this.handlePotentialEclipseLink(b);
        }
    }

    public void stop(BundleContext ctx) {
        LOG.debug("Stopping EclipseLink adapter");
        for (ServiceRegistration reg : this.registeredProviders.values()) {
            reg.unregister();
        }
    }

    public void bundleChanged(BundleEvent event) {
        ServiceRegistration reg;
        if ((event.getType() & 0x20) != 0) {
            this.handlePotentialEclipseLink(event.getBundle());
        } else if ((event.getType() == 64 || event.getType() == 16) && (reg = (ServiceRegistration)this.registeredProviders.remove(event.getBundle())) != null) {
            reg.unregister();
        }
    }

    private void handlePotentialEclipseLink(Bundle b) {
        if (!ECLIPSELINK_JPA_PROVIDER_BUNDLE_SYMBOLIC_NAME.equals(b.getSymbolicName())) {
            return;
        }
        if (this.registeredProviders.containsKey(b)) {
            return;
        }
        PersistenceProvider provider = Activator.createEclipselinkProvider(b);
        if (provider == null) {
            return;
        }
        LOG.debug("Adding new EclipseLink provider for bundle {}", (Object)b);
        EclipseLinkPersistenceProvider proxiedProvider = new EclipseLinkPersistenceProvider(provider, b);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("org.apache.aries.jpa.container.weaving.packages", this.getJPAPackages(b));
        ((Dictionary)props).put("javax.persistence.provider", ECLIPSELINK_JPA_PROVIDER_CLASS_NAME);
        ServiceRegistration reg = this.context.registerService(PersistenceProvider.class, (Object)proxiedProvider, props);
        ServiceRegistration old = this.registeredProviders.putIfAbsent(b, reg);
        if (old != null) {
            reg.unregister();
        }
    }

    private static PersistenceProvider createEclipselinkProvider(Bundle b) {
        try {
            Class providerClass = b.loadClass(ECLIPSELINK_JPA_PROVIDER_CLASS_NAME);
            Constructor con = providerClass.getConstructor(new Class[0]);
            return (PersistenceProvider)con.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.debug("Unable to load EclipseLink provider class. Ignoring bundle " + b.getSymbolicName(), (Throwable)e);
            return null;
        }
    }

    private String[] getJPAPackages(Bundle jpaBundle) {
        HashSet<String> result = new HashSet<String>();
        for (Bundle b : this.context.getBundles()) {
            BundleWiring bw = (BundleWiring)b.adapt(BundleWiring.class);
            if (bw == null) continue;
            boolean isJpaBundle = b.equals(jpaBundle);
            List wires = bw.getProvidedWires("osgi.wiring.package");
            for (BundleWire w : wires) {
                String pkgName = (String)w.getCapability().getAttributes().get("osgi.wiring.package");
                boolean add = isJpaBundle || pkgName.startsWith("org.eclipse.persistence");
                if (!add) continue;
                result.add(Activator.getPkg(b, pkgName));
            }
        }
        result.add(Activator.getPkg(this.context.getBundle(), "org.apache.aries.jpa.eclipselink.adapter.platform"));
        LOG.debug("Found JPA packages {}", result);
        return result.toArray(new String[0]);
    }

    private static String getPkg(Bundle b, String pkgName) {
        return String.format("%s;%s=%s; %s=%s", pkgName, "bundle-symbolic-name", b.getSymbolicName(), "bundle-version", b.getVersion());
    }
}

